/*
 * Decompiled with CFR 0.152.
 */
package jdd.bdd;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jdd.bdd.BDD;
import jdd.util.Array;
import jdd.util.FileUtility;
import jdd.util.JDDConsole;
import jdd.util.Test;

public class BDDIO {
    private static final String BDD_HEADER_MAGIC = "FORMAT:JDD.BDD";
    private static BDD manager;
    private static OutputStream os;
    private static Writer wr;
    private static boolean binary_format;
    private static byte[] buffer;

    private static final int safe_read(InputStream inputStream, int n, byte[] byArray) throws IOException {
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = inputStream.read(byArray, n2, n - n2);
            if (n4 < n - n2 && ++n3 == 3) {
                return n2;
            }
            if (n4 <= 0) continue;
            n2 += n4;
        }
        return n2;
    }

    private static final void save_int(int n) throws IOException {
        BDDIO.buffer[0] = (byte)(n >> 24 & 0xFF);
        BDDIO.buffer[1] = (byte)(n >> 16 & 0xFF);
        BDDIO.buffer[2] = (byte)(n >> 8 & 0xFF);
        BDDIO.buffer[3] = (byte)(n & 0xFF);
        os.write(buffer, 0, 4);
    }

    private static final int load_int(InputStream inputStream) throws IOException {
        int n = BDDIO.safe_read(inputStream, 4, buffer);
        if (n != 4) {
            throw new IOException("immature end of file while reading the header fields");
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < 4) {
            int n4 = buffer[n3] & 0xFF;
            n2 = n2 << 8 | n4;
            ++n3;
        }
        return n2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void save(BDD bDD, int n, String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        os = new GZIPOutputStream(fileOutputStream);
        try {
            try {
                manager = bDD;
                binary_format = true;
                os.write(BDD_HEADER_MAGIC.getBytes(), 0, BDD_HEADER_MAGIC.length());
                BDDIO.save_int(bDD.nodeCount(n));
                BDDIO.save_int(n);
                BDDIO.recursive_save(n);
                os.flush();
                os.close();
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                JDDConsole.out.println("BDDIO.save Failed: " + iOException.getMessage());
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            bDD.unmark_tree(n);
            manager = null;
            os = null;
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        bDD.unmark_tree(n);
        manager = null;
        os = null;
    }

    private static final void recursive_save(int n) throws IOException {
        if (n < 2) {
            return;
        }
        if (!manager.isNodeMarked(n)) {
            manager.mark_node(n);
            int n2 = manager.getVarUnmasked(n);
            int n3 = manager.getLow(n);
            int n4 = manager.getHigh(n);
            BDDIO.recursive_save(n3);
            BDDIO.recursive_save(n4);
            if (binary_format) {
                BDDIO.save_int(n);
                BDDIO.save_int(n2);
                BDDIO.save_int(n3);
                BDDIO.save_int(n4);
            } else {
                wr.write("" + n + '\t' + n2 + '\t' + n3 + '\t' + n4 + '\n');
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int load(BDD bDD, String string) throws IOException {
        int n = 0;
        GZIPInputStream gZIPInputStream = new GZIPInputStream(new FileInputStream(string));
        byte[] byArray = new byte[BDD_HEADER_MAGIC.length()];
        int n2 = BDDIO.safe_read(gZIPInputStream, byArray.length, byArray);
        if (n2 != byArray.length) {
            throw new IOException("immature end of file while reading the header");
        }
        if (!Array.equals(byArray, BDD_HEADER_MAGIC.getBytes(), byArray.length)) {
            throw new IOException("this is not an BDD file in JDD format");
        }
        int n3 = bDD.numberOfVariables();
        int n4 = BDDIO.load_int(gZIPInputStream);
        int n5 = BDDIO.load_int(gZIPInputStream);
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        Integer n6 = new Integer(0);
        Integer n7 = new Integer(1);
        hashMap.put(n6, n6);
        hashMap.put(n7, n7);
        try {
            try {
                Integer n8;
                int n9 = 0;
                block5: while (true) {
                    if (n9 >= n4) {
                        ((InputStream)gZIPInputStream).close();
                        n8 = (Integer)hashMap.get(new Integer(n5));
                        if (n8 != null) break;
                        throw new IOException("Corrupt BDD file");
                    }
                    int n10 = BDDIO.load_int(gZIPInputStream);
                    int n11 = BDDIO.load_int(gZIPInputStream);
                    int n12 = BDDIO.load_int(gZIPInputStream);
                    int n13 = BDDIO.load_int(gZIPInputStream);
                    Integer n14 = (Integer)hashMap.get(new Integer(n12));
                    if (n14 == null) {
                        throw new IOException("Unknown child node" + n12);
                    }
                    n12 = n14;
                    n14 = (Integer)hashMap.get(new Integer(n13));
                    if (n14 == null) {
                        throw new IOException("Unknown child node" + n13);
                    }
                    n13 = n14;
                    while (true) {
                        if (n11 < n3) {
                            n = bDD.ref(bDD.mk(n11, n12, n13));
                            hashMap.put(new Integer(n10), new Integer(n));
                            ++n9;
                            continue block5;
                        }
                        bDD.createVar();
                        ++n3;
                    }
                    break;
                }
                n = n8;
                Collection collection = hashMap.values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Integer n15 = (Integer)iterator.next();
                    bDD.deref(n15);
                }
            }
            catch (IOException iOException) {
                JDDConsole.out.println("BDDIO.bddLoad Failed: " + iOException.getMessage());
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            Object var13_25 = null;
            ((InputStream)gZIPInputStream).close();
            throw throwable;
        }
        {
            Object var13_26 = null;
        }
        ((InputStream)gZIPInputStream).close();
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveBuDDy(BDD bDD, int n, String string) throws IOException {
        wr = new OutputStreamWriter(new FileOutputStream(string));
        try {
            try {
                manager = bDD;
                binary_format = false;
                if (n < 2) {
                    wr.write("0 0 " + n + '\n');
                } else {
                    int n2 = bDD.numberOfVariables();
                    int n3 = bDD.nodeCount(n);
                    wr.write("" + n3 + ' ' + n2 + '\n');
                    int n4 = 0;
                    while (true) {
                        if (n4 >= n2) {
                            wr.write("\n");
                            BDDIO.recursive_save(n);
                            break;
                        }
                        wr.write("" + n4 + ' ');
                        ++n4;
                    }
                }
                wr.close();
            }
            catch (IOException iOException) {
                JDDConsole.out.println("BDDIO.save Failed: " + iOException.getMessage());
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            bDD.unmark_tree(n);
            manager = null;
            wr = null;
            throw throwable;
        }
        {
            Object var4_9 = null;
        }
        bDD.unmark_tree(n);
        manager = null;
        wr = null;
    }

    public static void internal_test() {
        Test.start("BDDIO");
        try {
            BDD bDD = new BDD(100, 10);
            int n = bDD.createVar();
            int n2 = bDD.createVar();
            int n3 = bDD.createVar();
            int n4 = bDD.createVar();
            int n5 = bDD.cube("1-01");
            BDDIO.save(bDD, n5, "test.bdd");
            double d = bDD.satCount(n5);
            int n6 = bDD.nodeCount(n5);
            BDD bDD2 = new BDD(1, 10);
            int n7 = BDDIO.load(bDD2, "test.bdd");
            Test.checkEquality(d, bDD2.satCount(n7), "sat-count (1)");
            Test.checkEquality(n6, bDD2.nodeCount(n7), "node-count (1)");
            BDDIO.save(bDD2, n7, "test.bdd");
            int n8 = BDDIO.load(bDD, "test.bdd");
            Test.checkEquality(n5, n8, "BDD consistency failed");
            FileUtility.delete("test.bdd");
        }
        catch (IOException iOException) {
            Test.check(false, "EXCEPTION CAUGHT: " + iOException.getMessage());
        }
        Test.end();
    }

    static {
        buffer = new byte[4];
    }
}

