/*
 * Decompiled with CFR 0.152.
 */
package jdd.bdd;

import jdd.bdd.NodeTable;
import jdd.util.Allocator;
import jdd.util.Array;
import jdd.util.JDDConsole;
import jdd.util.Test;
import jdd.util.math.HashFunctions;

public class Permutation {
    private static int id_c = 0;
    int last;
    int first;
    int id;
    int hash;
    int[] perm;
    int[] from;
    int[] to;
    Permutation next;

    public void show() {
        JDDConsole.out.println("-----------------------------");
        int n = this.first;
        while (n <= this.last) {
            JDDConsole.out.println(" " + n + " --> " + this.perm[n]);
            ++n;
        }
    }

    public long getMemoryUsage() {
        return this.perm.length * 4 + this.from.length * 4 + this.to.length * 4;
    }

    static int computeHash(int[] nArray, int[] nArray2) {
        int n = HashFunctions.hash_FNV(nArray, 0, nArray.length);
        int n2 = HashFunctions.hash_FNV(nArray2, 0, nArray2.length);
        return HashFunctions.hash_FNV(n, n2, 0);
    }

    static Permutation findPermutation(Permutation permutation, int[] nArray, int[] nArray2) {
        int n = Permutation.computeHash(nArray, nArray2);
        while (permutation != null) {
            if (permutation.equals(n, nArray, nArray2)) {
                return permutation;
            }
            permutation = permutation.next;
        }
        return null;
    }

    boolean equals(int n, int[] nArray, int[] nArray2) {
        if (n != this.hash) {
            return false;
        }
        if (nArray.length != this.from.length || nArray2.length != this.to.length) {
            return false;
        }
        if (!Array.equals(nArray, this.from, nArray.length)) {
            return false;
        }
        return Array.equals(nArray2, this.to, nArray2.length);
    }

    Permutation(int[] nArray, int[] nArray2, NodeTable nodeTable) {
        boolean bl = false;
        if (nArray.length == nArray2.length) {
            bl = true;
        }
        Test.check(bl, "Permutations vectors must have equal length");
        boolean bl2 = false;
        if (nArray.length > 0) {
            bl2 = true;
        }
        Test.check(bl2, "non empty pemuration vectors");
        this.from = Array.clone(nArray);
        this.to = Array.clone(nArray2);
        int n = nArray.length;
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray3[n2] = nodeTable.getVar(nArray[n2]);
            nArray4[n2] = nodeTable.getVar(nArray2[n2]);
            ++n2;
        }
        this.first = this.last = nArray3[0];
        n2 = 1;
        while (n2 < n) {
            if (this.last < nArray3[n2]) {
                this.last = nArray3[n2];
            }
            if (this.first > nArray3[n2]) {
                this.first = nArray3[n2];
            }
            ++n2;
        }
        this.perm = Allocator.allocateIntArray(this.last + 1);
        n2 = 0;
        while (n2 < this.last) {
            this.perm[n2] = n2;
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            this.perm[nArray3[n2]] = nArray4[n2];
            ++n2;
        }
        this.next = null;
        this.hash = Permutation.computeHash(nArray, nArray2);
        this.id = id_c++;
    }
}

