/*
 * Decompiled with CFR 0.152.
 */
package jdd.bdd;

import jdd.bdd.CacheBase;
import jdd.bdd.NodeTable;
import jdd.util.Allocator;
import jdd.util.Configuration;
import jdd.util.JDDConsole;
import jdd.util.Options;
import jdd.util.Test;
import jdd.util.math.Digits;
import jdd.util.math.HashFunctions;
import jdd.util.math.Prime;

public class SimpleCache
extends CacheBase {
    private int[] data;
    public int answer;
    public int hash_value;
    private int cache_bits;
    private int shift_bits;
    private int cache_mask;
    protected int members;
    protected int width;
    protected int bdds;
    protected int num_clears;
    protected int num_grows;
    protected int cache_size;
    protected long num_access;
    protected long hit;
    protected long miss;
    protected long last_hit;
    protected long last_access;

    protected final int getOut(int n) {
        return this.data[n * this.width];
    }

    protected final void setOut(int n, int n2) {
        this.data[n * this.width] = n2;
    }

    protected final int getIn(int n, int n2) {
        return this.data[n * this.width + n2];
    }

    protected final void setIn(int n, int n2, int n3) {
        this.data[n * this.width + n2] = n3;
    }

    protected final void clear_cache() {
        int n = this.cache_size;
        while (n != 0) {
            this.invalidate(--n);
        }
    }

    protected final void invalidate(int n) {
        this.setIn(n, 1, -1);
    }

    protected final boolean isValid(int n) {
        boolean bl = false;
        if (this.getIn(n, 1) != -1) {
            bl = true;
        }
        return bl;
    }

    public long getMemoryUsage() {
        long l = 0L;
        if (this.data != null) {
            l += (long)(this.data.length * 4);
        }
        return l;
    }

    public int getSize() {
        return this.cache_size;
    }

    protected boolean may_grow() {
        if (this.num_grows < Configuration.maxSimplecacheGrows) {
            long l = this.num_access - this.last_access;
            if (l * 100L < (long)(this.cache_size * Configuration.minSimplecacheAccessToGrow)) {
                return false;
            }
            int n = (int)((double)(this.hit - this.last_hit) * 100.0 / (double)l);
            if (n > Configuration.minSimplecacheHitrateToGrow) {
                this.last_hit = this.hit;
                this.last_access = this.num_access;
                ++this.num_grows;
                return true;
            }
        }
        return false;
    }

    public void invalidate_cache() {
        this.clear_cache();
        ++this.num_clears;
    }

    public void free_or_grow() {
        if (this.may_grow()) {
            this.grow_and_invalidate_cache();
        } else {
            this.invalidate_cache();
        }
    }

    protected void grow_and_invalidate_cache() {
        ++this.cache_bits;
        --this.shift_bits;
        this.cache_size = 1 << this.cache_bits;
        this.cache_size = Prime.nextPrime(this.cache_size);
        this.cache_mask = this.cache_size - 1;
        this.data = null;
        this.data = Allocator.allocateIntArray(this.cache_size * this.width);
        if (Options.verbose) {
            JDDConsole.out.println("Cache " + this.getName() + " grown to " + this.cache_size + " entries");
        }
        this.invalidate_cache();
    }

    public void free_or_grow(NodeTable nodeTable) {
        if (this.may_grow()) {
            this.grow_and_invalidate_cache();
        } else {
            this.invalidate_cache(nodeTable);
        }
    }

    public void invalidate_cache(NodeTable nodeTable) {
        this.invalidate_cache();
    }

    public void insert(int n, int n2, int n3) {
        this.setOut(n, n3);
        this.setIn(n, 1, n2);
    }

    public void insert(int n, int n2, int n3, int n4) {
        this.setOut(n, n4);
        this.setIn(n, 1, n2);
        this.setIn(n, 2, n3);
    }

    public void insert(int n, int n2, int n3, int n4, int n5) {
        this.setOut(n, n5);
        this.setIn(n, 1, n2);
        this.setIn(n, 2, n3);
        this.setIn(n, 3, n4);
    }

    void add(int n, int n2) {
        this.insert(this.good_hash(n), n, n2);
    }

    void add(int n, int n2, int n3) {
        this.insert(this.good_hash(n, n2), n, n2, n3);
    }

    void add(int n, int n2, int n3, int n4) {
        this.insert(this.good_hash(n, n2, n3), n, n2, n3, n4);
    }

    public final boolean lookup(int n) {
        ++this.num_access;
        int n2 = this.good_hash(n);
        if (this.getIn(n2, 1) == n) {
            ++this.hit;
            this.answer = this.getOut(n2);
            return true;
        }
        ++this.miss;
        this.hash_value = n2;
        return false;
    }

    public final boolean lookup(int n, int n2) {
        ++this.num_access;
        int n3 = this.good_hash(n, n2);
        if (this.getIn(n3, 1) == n && this.getIn(n3, 2) == n2) {
            ++this.hit;
            this.answer = this.getOut(n3);
            return true;
        }
        ++this.miss;
        this.hash_value = n3;
        return false;
    }

    public final boolean lookup(int n, int n2, int n3) {
        ++this.num_access;
        int n4 = this.good_hash(n, n2, n3);
        if (this.getIn(n4, 1) == n && this.getIn(n4, 2) == n2 && this.getIn(n4, 3) == n3) {
            ++this.hit;
            this.answer = this.getOut(n4);
            return true;
        }
        ++this.miss;
        this.hash_value = n4;
        return false;
    }

    protected final int good_hash(int n) {
        return n % this.cache_size;
    }

    protected final int good_hash(int n, int n2) {
        return (HashFunctions.hash_prime(n, n2) & Integer.MAX_VALUE) % this.cache_size;
    }

    protected final int good_hash(int n, int n2, int n3) {
        return (HashFunctions.hash_prime(n, n2, n3) & Integer.MAX_VALUE) % this.cache_size;
    }

    public double computeLoadFactor() {
        if (this.data == null) {
            return 0.0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.cache_size) {
            if (this.isValid(n2)) {
                ++n;
            }
            ++n2;
        }
        return (double)(n * 10000 / this.cache_size) / 100.0;
    }

    public double computeHitRate() {
        if (this.num_access == 0L) {
            return 0.0;
        }
        return (double)((int)(this.hit * 10000L / this.num_access)) / 100.0;
    }

    public long getAccessCount() {
        return this.num_access;
    }

    public int getCacheSize() {
        return this.cache_size;
    }

    public int getNumberOfClears() {
        return this.num_clears;
    }

    public int getNumberOfPartialClears() {
        return 0;
    }

    public int getNumberOfGrows() {
        return this.num_grows;
    }

    public void showStats() {
        if (this.num_access != 0L) {
            JDDConsole.out.print(this.getName() + "-cache ");
            JDDConsole.out.print("ld=" + this.computeLoadFactor() + "% ");
            JDDConsole.out.print("sz=");
            Digits.printNumber1024(this.cache_size);
            JDDConsole.out.print("accs=");
            Digits.printNumber1024(this.num_access);
            JDDConsole.out.print("clrs=" + this.num_clears + "/0 ");
            JDDConsole.out.print("hitr=" + this.computeHitRate() + "% ");
            if (this.num_grows > 0) {
                JDDConsole.out.print("grws=" + this.num_grows + ' ');
            }
            JDDConsole.out.println();
        }
    }

    public void show_tuple(int n) {
        JDDConsole.out.print(n + ":   " + this.getOut(n));
        int n2 = 0;
        while (n2 < this.members) {
            JDDConsole.out.print("\t" + this.getIn(n, 1 + n2));
            ++n2;
        }
        JDDConsole.out.println();
    }

    public void check_cache(NodeTable nodeTable) {
        int n = 0;
        while (n < this.cache_size) {
            if (this.isValid(n)) {
                if (!nodeTable.isValid(this.getOut(n))) {
                    JDDConsole.out.println("Invalied cache output entry");
                    this.show_tuple(n);
                    System.exit(20);
                }
                int n2 = 0;
                while (n2 < this.bdds) {
                    if (!nodeTable.isValid(this.getIn(n, n2 + 1))) {
                        JDDConsole.out.println("Invalied cache member " + n2 + " entry");
                        this.show_tuple(n);
                        System.exit(20);
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public static void internal_test() {
        Test.start("SimpleCache");
        SimpleCache simpleCache = new SimpleCache("test", 200, 3, 3);
        simpleCache.add(2, 1, 2, 3);
        boolean bl = false;
        if (simpleCache.lookup(2, 1, 2) && simpleCache.answer == 3) {
            bl = true;
        }
        Test.check(bl, "lookup 3");
        simpleCache.add(2, 1, 2, 5);
        boolean bl2 = false;
        if (simpleCache.lookup(2, 1, 2) && simpleCache.answer == 5) {
            bl2 = true;
        }
        Test.check(bl2, "lookup overwritten with 5");
        Test.check(simpleCache.lookup(1, 1, 2) ^ true, "non-existing entry 1");
        Test.check(simpleCache.lookup(2, 2, 2) ^ true, "non-existing entry 2");
        Test.check(simpleCache.lookup(2, 2, 1) ^ true, "non-existing entry 3");
        simpleCache = new SimpleCache("test", 200, 2, 2);
        simpleCache.add(2, 1, 3);
        boolean bl3 = false;
        if (simpleCache.lookup(2, 1) && simpleCache.answer == 3) {
            bl3 = true;
        }
        Test.check(bl3, "lookup 3");
        simpleCache.add(2, 1, 5);
        boolean bl4 = false;
        if (simpleCache.lookup(2, 1) && simpleCache.answer == 5) {
            bl4 = true;
        }
        Test.check(bl4, "lookup overwritten with 5");
        Test.check(simpleCache.lookup(1, 1) ^ true, "non-existing entry 1");
        Test.check(simpleCache.lookup(2, 2) ^ true, "non-existing entry 2");
        simpleCache = new SimpleCache("test", 200, 1, 1);
        simpleCache.add(1, 3);
        boolean bl5 = false;
        if (simpleCache.lookup(1) && simpleCache.answer == 3) {
            bl5 = true;
        }
        Test.check(bl5, "lookup 3");
        simpleCache.add(1, 5);
        boolean bl6 = false;
        if (simpleCache.lookup(1) && simpleCache.answer == 5) {
            bl6 = true;
        }
        Test.check(bl6, "lookup overwritten with 5");
        Test.check(simpleCache.lookup(2) ^ true, "non-existing entry 1");
        Test.check(simpleCache.lookup(3) ^ true, "non-existing entry 2");
        Test.end();
    }

    public SimpleCache(String string, int n, int n2, int n3) {
        super(string);
        if (n < 32) {
            n = 32;
        }
        this.members = n2;
        this.width = n2 + 1;
        this.bdds = n3;
        this.cache_bits = Digits.closest_log2(n);
        this.shift_bits = 32 - this.cache_bits;
        this.cache_size = 1 << this.cache_bits;
        this.cache_mask = this.cache_size - 1;
        this.num_grows = 0;
        this.num_access = 0L;
        this.last_access = 0L;
        this.last_hit = 0L;
        this.miss = 0L;
        this.hit = 0L;
        this.num_clears = 0;
        this.cache_size = Prime.nextPrime(this.cache_size);
        this.data = Allocator.allocateIntArray(this.cache_size * this.width);
        this.clear_cache();
    }
}

