/*
 * Decompiled with CFR 0.152.
 */
package jdd.bdd.debug;

import java.util.Collection;
import jdd.bdd.BDD;
import jdd.bdd.Permutation;
import jdd.bdd.debug.BDDDebugFrame;
import jdd.bdd.debug.BDDDebuger;
import jdd.util.JDDConsole;
import jdd.util.Options;

public class ProfiledBDD
extends BDD {
    private long p_and = 0L;
    private long p_or = 0L;
    private long p_xor = 0L;
    private long p_biimp = 0L;
    private long p_imp = 0L;
    private long p_not = 0L;
    private long p_nand;
    private long p_nor;
    private long p_replace = 0L;
    private long p_exists = 0L;
    private long p_forall = 0L;
    private long p_relprod = 0L;
    private long p_support = 0L;
    private long p_restrict = 0L;
    private long p_simplify = 0L;
    private long p_ite = 0L;
    private long p_satcount = 0L;

    public Collection addDebugger(BDDDebuger bDDDebuger) {
        Collection collection = super.addDebugger(bDDDebuger);
        collection.add(this.quant_cache);
        collection.add(this.ite_cache);
        collection.add(this.not_cache);
        collection.add(this.op_cache);
        collection.add(this.replace_cache);
        collection.add(this.sat_cache);
        return collection;
    }

    public int and(int n, int n2) {
        ++this.p_and;
        return super.and(n, n2);
    }

    public int or(int n, int n2) {
        ++this.p_or;
        return super.or(n, n2);
    }

    public int xor(int n, int n2) {
        ++this.p_xor;
        return super.xor(n, n2);
    }

    public int biimp(int n, int n2) {
        ++this.p_biimp;
        return super.biimp(n, n2);
    }

    public int imp(int n, int n2) {
        ++this.p_imp;
        return super.imp(n, n2);
    }

    public int nor(int n, int n2) {
        ++this.p_nor;
        return super.nor(n, n2);
    }

    public int nand(int n, int n2) {
        ++this.p_nand;
        return super.nand(n, n2);
    }

    public int not(int n) {
        ++this.p_not;
        return super.not(n);
    }

    public int replace(int n, Permutation permutation) {
        ++this.p_replace;
        return super.replace(n, permutation);
    }

    public int exists(int n, int n2) {
        ++this.p_exists;
        return super.exists(n, n2);
    }

    public int forall(int n, int n2) {
        ++this.p_forall;
        return super.forall(n, n2);
    }

    public int relProd(int n, int n2, int n3) {
        ++this.p_relprod;
        return super.relProd(n, n2, n3);
    }

    public int ite(int n, int n2, int n3) {
        ++this.p_ite;
        return super.ite(n, n2, n3);
    }

    public double satCount(int n) {
        ++this.p_satcount;
        return super.satCount(n);
    }

    public int support(int n) {
        ++this.p_support;
        return super.support(n);
    }

    public int restrict(int n, int n2) {
        ++this.p_restrict;
        return super.restrict(n, n2);
    }

    public int simplify(int n, int n2) {
        ++this.p_simplify;
        return super.simplify(n, n2);
    }

    public void showStats() {
        if (this.p_and > 0L || this.p_or > 0L || this.p_not > 0L) {
            JDDConsole.out.println("# calls to and/or/not:                    " + this.p_and + '/' + this.p_or + '/' + this.p_not);
        }
        if (this.p_biimp > 0L || this.p_imp > 0L || this.p_xor > 0L) {
            JDDConsole.out.println("# calls to biimp/imp/xor:                 " + this.p_biimp + '/' + this.p_imp + '/' + this.p_xor);
        }
        if (this.p_nand > 0L || this.p_nor > 0L || this.p_ite > 0L) {
            JDDConsole.out.println("# calls to nand/nor/ite:                  " + this.p_nand + '/' + this.p_nor + '/' + this.p_ite);
        }
        if (this.p_replace > 0L || this.p_exists > 0L || this.p_forall > 0L || this.p_relprod > 0L) {
            JDDConsole.out.println("# calls to replace/exists/forall/relProd: " + this.p_replace + '/' + this.p_exists + '/' + this.p_forall + '/' + this.p_relprod);
        }
        if (this.p_support > 0L || this.p_restrict > 0L || this.p_simplify > 0L) {
            JDDConsole.out.println("# calls to support/restrict/simplify:     " + this.p_support + '/' + this.p_restrict + '/' + this.p_simplify);
        }
        if (this.p_satcount > 0L) {
            JDDConsole.out.println("# calls to satCount:     " + this.p_satcount);
        }
        super.showStats();
    }

    public ProfiledBDD(int n) {
        this(n, 1000);
    }

    public ProfiledBDD(int n, int n2) {
        super(n, n2);
        if (Options.profile_cache) {
            new BDDDebugFrame(this);
        }
    }
}

