/*
 * Decompiled with CFR 0.152.
 */
package jdd.util.math;

import jdd.util.Test;

public final class Prime {
    private static final int NUM_TRIALS = 8;

    private static final long witness(long l, long l2, long l3) {
        if (l2 == 0L) {
            return 1L;
        }
        long l4 = Prime.witness(l, l2 / (long)2, l3);
        if (l4 == 0L) {
            return 0L;
        }
        long l5 = l4 * l4 % l3;
        if (l5 == 1L && l4 != 1L && l4 != l3 - 1L) {
            return 0L;
        }
        if (l2 % (long)2 == 1L) {
            l5 = l * l5 % l3;
        }
        return l5;
    }

    public static final boolean isPrime(int n) {
        if (n < 20 && (n == 1 || n == 2 || n == 3 || n == 5 || n == 7 || n == 11 || n == 13 || n == 17 || n == 19)) {
            return true;
        }
        if (n % 2 == 0 || n % 3 == 0 || n % 5 == 0 || n % 7 == 0 || n % 11 == 0 || n % 13 == 0 || n % 17 == 0 || n % 19 == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < 8) {
            if (Prime.witness((long)2 + (long)(Math.random() * (double)(n - 2)), n - 1, n) != 1L) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static final int nextPrime(int n) {
        if (n % 2 == 0) {
            ++n;
        }
        while (!Prime.isPrime(n)) {
            n += 2;
        }
        return n;
    }

    public static final int prevPrime(int n) {
        if (n % 2 == 0) {
            --n;
        }
        while (!Prime.isPrime(n)) {
            n -= 2;
        }
        return n;
    }

    private static final boolean dumb_prime_check(int n) {
        int n2 = (int)Math.sqrt(n);
        if (n == 0) {
            return false;
        }
        if (n == 1) {
            return true;
        }
        int n3 = 2;
        while (n3 <= n2) {
            if (n % n3 == 0) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private static final int dumb_next_prime(int n) {
        while (!Prime.dumb_prime_check(n)) {
            ++n;
        }
        return n;
    }

    public static final void internal_test() {
        int n;
        Test.start("Prime");
        Test.check(Prime.isPrime(1), "1 is prime");
        Test.check(Prime.isPrime(2), "2 is prime");
        Test.check(Prime.isPrime(3), "3 is prime");
        Test.check(Prime.isPrime(4) ^ true, "4 is NOT prime");
        Test.check(Prime.isPrime(5), "5 is prime");
        Test.check(Prime.isPrime(6) ^ true, "6 is NOT prime");
        Test.check(Prime.isPrime(7), "7 is prime");
        Test.check(Prime.isPrime(8) ^ true, "8 is NOT prime");
        Test.check(Prime.isPrime(256) ^ true, "256 is NOT prime");
        Test.check(Prime.isPrime(13221) ^ true, "13221 is NOTprime");
        boolean bl = false;
        int n2 = 0;
        while (!bl && n2 < 3000) {
            n = (int)(Math.random() * 1234567.0);
            if (Prime.isPrime(n) != Prime.dumb_prime_check(n)) {
                bl = true;
            }
            ++n2;
        }
        Test.check(bl ^ true, "isPrime failed");
        n2 = 0;
        while (!bl && n2 < 3000) {
            n = (int)(Math.random() * 1234567.0);
            if (Prime.nextPrime(n) != Prime.dumb_next_prime(n)) {
                bl = true;
            }
            ++n2;
        }
        Test.check(bl ^ true, "nextPrime failed");
        Test.end();
    }
}

