/*
 * Decompiled with CFR 0.152.
 */
package jdd.sat;

import jdd.sat.Lit;
import jdd.sat.Var;
import jdd.util.JDDConsole;
import jdd.util.Sortable;
import jdd.util.Test;

public class Clause
implements Sortable {
    public Lit[] lits;
    public int curr;
    public int num_lits;
    public int index = -1;
    public int flag;
    public int offset;
    public int top;
    int hash;
    public double heat = 0.0;

    public Clause(int n) {
        this.num_lits = n;
        this.lits = new Lit[this.num_lits];
        this.curr = 0;
        this.top = 0;
        this.hash = 0;
    }

    public void insert(Lit lit) {
        if (!lit.var.occurs.contains(this)) {
            lit.var.occurs.add(this);
        }
        ++lit.occurnece;
        if (this.curr < this.num_lits) {
            this.lits[this.curr++] = lit;
        }
        this.top = this.curr;
    }

    public void showDIMACS() {
        for (int i = 0; i < this.curr; ++i) {
            this.lits[i].showDIMACS();
        }
        JDDConsole.out.println(" 0");
    }

    @Override
    public boolean greater_than(Sortable sortable) {
        Clause clause = (Clause)sortable;
        return this.heat > clause.heat;
    }

    public boolean satisfies(boolean[] blArray) {
        for (int i = 0; i < this.curr; ++i) {
            if (this.lits[i].neg == blArray[this.lits[i].index]) continue;
            return true;
        }
        return false;
    }

    public boolean satisfies(int n, boolean bl) {
        for (int i = 0; i < this.curr; ++i) {
            if (this.lits[i].index != n) continue;
            return this.lits[i].neg != bl;
        }
        return false;
    }

    public boolean simplify() {
        int n;
        for (n = 0; n < this.curr; ++n) {
            this.lits[n].var.extra = 0;
        }
        n = 0;
        int n2 = 0;
        while (n2 < this.curr) {
            int n3;
            int n4 = n3 = this.lits[n2].neg ? -1 : 1;
            if (n2 != n) {
                this.lits[n] = this.lits[n2];
            }
            if (this.lits[n2].var.extra == 0) {
                this.lits[n2].var.extra += n3;
            } else {
                if (this.lits[n2].var.extra * n3 < 0) {
                    return true;
                }
                --this.lits[n2].occurnece;
                --n;
            }
            ++n2;
            ++n;
        }
        this.curr = n;
        return false;
    }

    public void removeFromDatabase() {
        for (int i = 0; i < this.curr; ++i) {
            this.lits[i].var.occurs.remove(this);
            ++this.lits[i].occurnece;
        }
    }

    void computeHash() {
        this.hash = 0;
        for (int i = 0; i < this.curr; ++i) {
            this.hash += this.lits[i].id;
        }
    }

    public boolean equals(Clause clause) {
        int n;
        if (this.hash != clause.hash) {
            return false;
        }
        if (this.curr != clause.curr) {
            return false;
        }
        for (n = 0; n < this.curr; ++n) {
            clause.lits[n].extra = 0;
        }
        for (n = 0; n < this.curr; ++n) {
            this.lits[n].extra = 1;
        }
        for (n = 0; n < this.curr; ++n) {
            if (clause.lits[n].extra == 1) continue;
            return false;
        }
        return true;
    }

    public boolean largerOrEquals(Clause clause) {
        int n;
        if (this.curr < clause.curr) {
            return false;
        }
        for (n = 0; n < clause.curr; ++n) {
            clause.lits[n].extra = 0;
        }
        for (n = 0; n < this.curr; ++n) {
            this.lits[n].extra = 1;
        }
        for (n = 0; n < clause.curr; ++n) {
            if (clause.lits[n].extra == 1) continue;
            return false;
        }
        return true;
    }

    public final boolean isNull() {
        return this.top == 0;
    }

    public final boolean isUnit() {
        return this.top == 1;
    }

    public final int litsRemoved() {
        return this.curr - this.top;
    }

    public final Lit first() {
        return this.lits[0];
    }

    public final boolean used(Lit lit) {
        for (int i = 0; i < this.top; ++i) {
            if (lit.id != this.lits[i].id) continue;
            return true;
        }
        return false;
    }

    public final boolean removed(Lit lit) {
        for (int i = this.top; i < this.curr; ++i) {
            if (lit.id != this.lits[i].id) continue;
            return true;
        }
        return false;
    }

    public final boolean removed(Var var) {
        for (int i = 0; i < this.top; ++i) {
            if (var.index != this.lits[i].index) continue;
            return false;
        }
        return true;
    }

    public final boolean active(Var var) {
        for (int i = this.top; i < this.curr; ++i) {
            if (var.index != this.lits[i].index) continue;
            return false;
        }
        return true;
    }

    public final boolean remove(Var var) {
        for (int i = 0; i < this.top; ++i) {
            if (this.lits[i].var != var) continue;
            boolean bl = this.lits[i].neg;
            this.remove(i);
            return bl;
        }
        Test.check(false, "should not come here!");
        return false;
    }

    public final void remove(int n) {
        Lit lit;
        --this.top;
        Lit lit2 = this.lits[n];
        this.lits[n] = lit = this.lits[this.top];
        this.lits[this.top] = lit2;
    }

    public final boolean reinsert(Var var) {
        int n = var.index;
        for (int i = this.top; i < this.curr; ++i) {
            if (this.lits[i].index != n) continue;
            boolean bl = this.lits[i].neg;
            this.reinsert(i);
            return bl;
        }
        Test.check(false, "should not come here!");
        return false;
    }

    public final void reinsert(int n) {
        Lit lit;
        Lit lit2 = this.lits[n];
        this.lits[n] = lit = this.lits[this.top];
        this.lits[this.top] = lit2;
        ++this.top;
    }

    public void showClause() {
        JDDConsole.out.print("c" + (this.index + 1) + " = { ");
        for (int i = 0; i < this.curr; ++i) {
            if (i > 0) {
                JDDConsole.out.print(", ");
            }
            JDDConsole.out.print((this.lits[i].neg ? "~" : "") + "v" + (this.lits[i].index + 1));
        }
        JDDConsole.out.println("}");
    }

    public static void internal_test() {
        Test.start("Clause");
        Clause clause = new Clause(3);
        Var var = new Var(0);
        Var var2 = new Var(1);
        Var var3 = new Var(2);
        Lit lit = new Lit(var, false);
        Lit lit2 = new Lit(var2, false);
        Lit lit3 = new Lit(var3, false);
        clause.insert(lit);
        clause.insert(lit2);
        clause.insert(lit3);
        Test.check(!clause.removed(lit));
        clause.remove(var);
        Test.check(clause.removed(lit));
        clause.reinsert(var);
        clause.remove(var3);
        Test.check(clause.removed(lit3));
        Test.check(!clause.removed(lit));
        Clause clause2 = new Clause(1);
        clause2.insert(lit);
        Clause clause3 = new Clause(3);
        clause3.insert(lit);
        clause3.insert(lit2);
        clause3.insert(lit3);
        Test.check(!clause2.equals(clause3));
        Test.check(!clause3.equals(clause2));
        Test.check(clause2.equals(clause2));
        Test.check(clause3.equals(clause3));
        Test.check(clause2.equals(clause2));
        Test.check(!clause2.largerOrEquals(clause3));
        Test.check(clause3.largerOrEquals(clause2));
        Test.end();
    }
}

