/*
 * Decompiled with CFR 0.152.
 */
package v1;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import v1.ConstraintHandler;
import v1.Error;
import v1.GList;
import v1.Group;
import v1.Main;
import v1.OutOfMaxNumOfTestcasesException;
import v1.ParameterModel;
import v1.Testcase;

abstract class Generator {
    final ParameterModel parametermodel;
    final GList groupList;
    final ConstraintHandler constrainthandler;
    final List<Testcase> seed;
    final int numOfParameters;
    final Random rnd;
    static final int MaxNumOfTestcases = 65532;

    Generator(ParameterModel parametermodel, GList groupList, ConstraintHandler constrainthandler, List<Testcase> seed, long randomseed) {
        this.parametermodel = parametermodel;
        this.groupList = groupList;
        this.constrainthandler = constrainthandler;
        this.seed = seed;
        this.numOfParameters = parametermodel.size;
        this.rnd = new Random(randomseed);
    }

    abstract List<Testcase> generate() throws OutOfMaxNumOfTestcasesException;

    protected List<List<Testcase>> generateTupleSequenceList() {
        ArrayList<List<Testcase>> listOfTupleSequence = new ArrayList<List<Testcase>>();
        for (Group g : this.groupList) {
            listOfTupleSequence.add(this.generateTupleSequence(g));
        }
        return listOfTupleSequence;
    }

    private List<Testcase> generateTupleSequence(Group g) {
        int numOfCombinations = 1;
        int i = 0;
        while (i < g.member.length) {
            numOfCombinations *= this.parametermodel.range[g.member[i]];
            ++i;
        }
        ArrayList<Testcase> testSet = new ArrayList<Testcase>();
        Testcase tmptest = new Testcase(this.parametermodel.size);
        tmptest.quantify();
        int i2 = 0;
        while (i2 < g.member.length) {
            tmptest.set(g.member[i2], (byte)0);
            ++i2;
        }
        if (this.constrainthandler.isPossible(tmptest)) {
            testSet.add(tmptest);
        }
        i2 = 1;
        while (i2 < numOfCombinations) {
            tmptest = tmptest.makeClone();
            int j = 0;
            while (j < g.member.length) {
                int p = g.member[j];
                if (tmptest.get(p) + 1 < this.parametermodel.range[p]) {
                    tmptest.set(p, (byte)(tmptest.get(p) + 1));
                    break;
                }
                tmptest.set(p, (byte)0);
                ++j;
            }
            if (this.constrainthandler.isPossible(tmptest)) {
                testSet.add(tmptest);
                if (testSet.size() > 65532) {
                    Error.printError(Main.language == Main.Language.JP ? "\u7279\u5b9a\u56e0\u5b50\u306e\u5168\u7db2\u7f85\u306b\u4e0a\u965065532\u3092\u8d85\u3048\u308b\u30c6\u30b9\u30c8\u30b1\u30fc\u30b9\u304c\u5fc5\u8981\u3067\u3059" : "The number of test cases exceeds the upper bound 65532");
                }
            }
            ++i2;
        }
        return testSet;
    }

    protected boolean hasTuplesToCover(List<List<Testcase>> tupleSequenceList) {
        for (List<Testcase> tupleSequence : tupleSequenceList) {
            if (tupleSequence.size() <= 0) continue;
            return true;
        }
        return false;
    }
}

