/*
 * Decompiled with CFR 0.152.
 */
package jdd.examples;

import jdd.bdd.Permutation;
import jdd.bdd.debug.ProfiledBDD2;
import jdd.util.Configuration;
import jdd.util.JDDConsole;
import jdd.util.Options;

public class Solitaire
extends ProfiledBDD2 {
    private static final int SIZE = 33;
    private static final int CENTER = 16;
    private int[] boardC = new int[33];
    private int[] not_boardC = new int[33];
    private int[] boardN = new int[33];
    private int[] not_boardN = new int[33];
    private double dummyStateNum;
    private int I;
    private int T;
    private int currentvar;
    Permutation pair;
    private static final int[][] moves = new int[][]{{1, 4, 9}, {1, 2, 3}, {2, 5, 10}, {3, 2, 1}, {3, 6, 11}, {4, 5, 6}, {4, 9, 16}, {5, 10, 17}, {6, 5, 4}, {6, 11, 18}, {7, 8, 9}, {7, 14, 21}, {8, 9, 10}, {8, 15, 22}, {9, 8, 7}, {9, 10, 11}, {9, 4, 1}, {9, 16, 23}, {10, 9, 8}, {10, 11, 12}, {10, 5, 2}, {10, 17, 24}, {11, 10, 9}, {11, 12, 13}, {11, 6, 3}, {11, 18, 25}, {12, 11, 10}, {12, 19, 26}, {13, 12, 11}, {13, 20, 27}, {14, 15, 16}, {15, 16, 17}, {16, 15, 14}, {16, 17, 18}, {16, 9, 4}, {16, 23, 28}, {17, 16, 15}, {17, 18, 19}, {17, 10, 5}, {17, 24, 29}, {18, 17, 16}, {18, 19, 20}, {18, 11, 6}, {18, 25, 30}, {19, 18, 17}, {20, 19, 18}, {21, 22, 23}, {21, 14, 7}, {22, 23, 24}, {22, 15, 8}, {23, 22, 21}, {23, 24, 25}, {23, 16, 9}, {23, 28, 31}, {24, 23, 22}, {24, 25, 26}, {24, 17, 10}, {24, 29, 32}, {25, 24, 23}, {25, 26, 27}, {25, 18, 11}, {25, 30, 33}, {26, 25, 24}, {26, 19, 12}, {27, 26, 25}, {27, 20, 13}, {28, 29, 30}, {28, 23, 16}, {29, 24, 17}, {30, 29, 28}, {30, 25, 18}, {31, 32, 33}, {31, 28, 23}, {32, 29, 24}, {33, 32, 31}, {33, 30, 25}};

    public Solitaire() {
        super(8300000, 63000);
        Configuration.minFreeNodesProcent = 1;
    }

    public void setup() {
        this.dummyStateNum = Math.pow(2.0, 33.0);
        this.make_board();
        this.make_transition_relation();
        this.make_initial_state();
    }

    private void make_board() {
        for (int i = 0; i < 33; ++i) {
            this.boardC[i] = this.createVar();
            this.not_boardC[i] = this.ref(this.not(this.boardC[i]));
            this.boardN[i] = this.createVar();
            this.not_boardN[i] = this.ref(this.not(this.boardN[i]));
        }
    }

    private void make_initial_state() {
        this.I = 1;
        for (int i = 0; i < 33; ++i) {
            this.I = this.andTo(this.I, i == 16 ? this.not_boardC[i] : this.boardC[i]);
        }
    }

    private int all_other_idle(int n, int n2, int n3) {
        int n4 = 1;
        for (int i = 0; i < 33; ++i) {
            if (i == n || i == n2 || i == n3) continue;
            int n5 = this.ref(this.biimp(this.boardC[i], this.boardN[i]));
            n4 = this.andTo(n4, n5);
            this.deref(n5);
        }
        return n4;
    }

    private int make_move(int n, int n2, int n3) {
        int n4 = this.ref(this.and(this.boardC[n], this.not_boardN[n]));
        int n5 = this.ref(this.and(this.boardC[n2], this.not_boardN[n2]));
        int n6 = this.ref(this.and(n4, n5));
        this.deref(n4);
        this.deref(n5);
        int n7 = this.ref(this.and(this.boardN[n3], this.not_boardC[n3]));
        int n8 = this.all_other_idle(n, n2, n3);
        int n9 = this.ref(this.and(n7, n8));
        this.deref(n7);
        this.deref(n8);
        int n10 = this.ref(this.and(n6, n9));
        this.deref(n6);
        this.deref(n9);
        return n10;
    }

    private void make_transition_relation() {
        this.T = 0;
        for (int i = 0; i < moves.length; ++i) {
            int n = this.make_move(moves[i][0] - 1, moves[i][1] - 1, moves[i][2] - 1);
            this.T = this.orTo(this.T, n);
            this.deref(n);
        }
        JDDConsole.out.println("Transition relation: " + this.nodeCount(this.T) + " nodes, " + this.satCount(this.T) + " distinct transitions.");
    }

    private void make_itedata() {
        this.pair = this.createPermutation(this.boardN, this.boardC);
        this.currentvar = 1;
        for (int i = 0; i < 33; ++i) {
            this.currentvar = this.andTo(this.currentvar, this.boardC[i]);
        }
    }

    private void iterate() {
        int n;
        int n2 = this.I;
        int n3 = 1;
        this.make_itedata();
        do {
            n = n2;
            int n4 = this.ref(this.relProd(n2, this.T, this.currentvar));
            int n5 = this.ref(this.replace(n4, this.pair));
            this.deref(n4);
            n2 = this.orTo(n2, n5);
            this.deref(n5);
            JDDConsole.out.println("" + n3 + ": " + this.nodeCount(n2) + " nodes, " + this.satCount(n2) / this.dummyStateNum + " states.");
            ++n3;
        } while (n != n2);
    }

    public static void main(String[] stringArray) {
        Options.verbose = true;
        long l = System.currentTimeMillis();
        Solitaire solitaire = new Solitaire();
        solitaire.setup();
        solitaire.iterate();
        solitaire.showStats();
        long l2 = System.currentTimeMillis();
        JDDConsole.out.println("Time: " + (l2 - l) + " [ms]");
    }
}

