/*
 * Decompiled with CFR 0.152.
 */
package jdd.util.jre;

import java.util.Arrays;
import java.util.Random;
import jdd.util.JDDConsole;
import jdd.util.jre.JREInfo;
import jdd.util.math.FastRandom;

public class JRETest {
    public static long mem_start;
    private static double[] array_save;

    public static void mem_start() {
        for (int i = 0; i < 6; ++i) {
            System.gc();
        }
        mem_start = JREInfo.usedMemory();
    }

    public static long mem_end() {
        return JREInfo.usedMemory() - mem_start;
    }

    public static int rnd_size(int n) {
        if (n < 0) {
            return 0;
        }
        int n2 = 1 << n;
        return n2 + (int)(Math.random() * (double)n2);
    }

    public static void set1(int[] nArray, int n) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n;
        }
    }

    public static void set2(int[] nArray, int n) {
        Arrays.fill(nArray, n);
    }

    public static void set3(int[] nArray, int n) {
        int n2 = nArray.length / 4;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            nArray[n3] = n;
            nArray[n3 + 1] = n;
            nArray[n3 + 2] = n;
            nArray[n3 + 3] = n;
            n3 += 4;
        }
        n2 = nArray.length & 3;
        while (n2-- != 0) {
            nArray[n3++] = n;
        }
    }

    public static void copy1(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            nArray[i] = nArray2[i];
        }
    }

    public static void copy2(int[] nArray, int[] nArray2) {
        System.arraycopy(nArray2, 0, nArray, 0, nArray.length);
    }

    public static void copy3(int[] nArray, int[] nArray2) {
        int n = nArray.length / 4;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            nArray[n2] = nArray2[n2];
            nArray[n2 + 1] = nArray2[n2 + 1];
            nArray[n2 + 2] = nArray2[n2 + 2];
            nArray[n2 + 3] = nArray2[n2 + 3];
            n2 += 4;
        }
        n = nArray.length & 3;
        while (n-- != 0) {
            nArray[n2] = nArray2[n2];
            ++n2;
        }
    }

    public static void test_rec(double[] dArray) {
        array_save = dArray;
        JRETest.test_rec_rec(dArray.length - 1);
    }

    public static final double test_rec_rec(int n) {
        if (n != 0) {
            return array_save[n] + JRETest.test_rec_rec(n - 1);
        }
        return array_save[n];
    }

    public static final void test_local(double[] dArray) {
        double d = 0.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            d += dArray[i];
        }
    }

    public static void test_local2(double[] dArray) {
        double d = 0.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            d += dArray[i];
        }
    }

    public void test_local3(double[] dArray) {
        double d = 0.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            d += dArray[i];
        }
    }

    public static void main(String[] stringArray) {
        long l;
        Object object;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        JREInfo.show();
        JRETest jRETest = new JRETest();
        int n6 = 10240;
        int n7 = 10240;
        int[] nArray = new int[n6];
        int[] nArray2 = new int[n6];
        for (n5 = 0; n5 < n7; ++n5) {
            JRETest.set1(nArray, n5);
        }
        long l2 = System.currentTimeMillis();
        for (n5 = 0; n5 < n7; ++n5) {
            JRETest.set1(nArray, n5);
        }
        long l3 = System.currentTimeMillis() - l2;
        for (n5 = 0; n5 < n7; ++n5) {
            JRETest.set2(nArray, n5);
        }
        l2 = System.currentTimeMillis();
        for (n5 = 0; n5 < n7; ++n5) {
            JRETest.set2(nArray, n5);
        }
        long l4 = System.currentTimeMillis() - l2;
        if (l3 < l4) {
            System.out.println("SET: Java code is faster than Arrays.fill() [" + l3 + " vs " + l4 + "]");
        } else {
            System.out.println("SET: Arrays.fill() is faster than Java code [" + l4 + " vs " + l3 + "]");
        }
        for (n5 = 0; n5 < n7; ++n5) {
            JRETest.set3(nArray, n5);
        }
        l2 = System.currentTimeMillis();
        for (n5 = 0; n5 < n7; ++n5) {
            JRETest.set3(nArray, n5);
        }
        l3 = System.currentTimeMillis() - l2;
        if (l3 < l4) {
            System.out.println("SET: unrollced java code is faster than Arrays.fill() [" + l3 + " vs " + l4 + "]");
        } else {
            System.out.println("SET: Arrays.fill() is faster than unrolled java code [" + l4 + " vs " + l3 + "]");
        }
        for (n5 = 0; n5 < n7; ++n5) {
            JRETest.copy1(nArray, nArray2);
        }
        l2 = System.currentTimeMillis();
        for (n5 = 0; n5 < n7; ++n5) {
            JRETest.copy1(nArray, nArray2);
        }
        l3 = System.currentTimeMillis() - l2;
        for (n5 = 0; n5 < n7; ++n5) {
            JRETest.copy2(nArray, nArray2);
        }
        l2 = System.currentTimeMillis();
        for (n5 = 0; n5 < n7; ++n5) {
            JRETest.copy2(nArray, nArray2);
        }
        l4 = System.currentTimeMillis() - l2;
        if (l3 < l4) {
            System.out.println("COPY: Java code is faster than System.arraycopy() [" + l3 + " vs " + l4 + "]");
        } else {
            System.out.println("COPY: System.arraycopy() is faster than Java code [" + l4 + " vs " + l3 + "]");
        }
        for (n5 = 0; n5 < n7; ++n5) {
            JRETest.copy3(nArray, nArray2);
        }
        l2 = System.currentTimeMillis();
        for (n5 = 0; n5 < n7; ++n5) {
            JRETest.copy3(nArray, nArray2);
        }
        l3 = System.currentTimeMillis() - l2;
        if (l3 < l4) {
            System.out.println("COPY: unrolled loop is faster than System.arraycopy() [" + l3 + " vs " + l4 + "]");
        } else {
            System.out.println("COPY: System.arraycopy() is faster than unrolled loop [" + l4 + " vs " + l3 + "]");
        }
        double[] dArray = new double[4096];
        for (n4 = 0; n4 < dArray.length; ++n4) {
            dArray[n4] = Math.random();
        }
        for (n4 = 0; n4 < n7; ++n4) {
            JRETest.test_rec(dArray);
        }
        l2 = System.currentTimeMillis();
        for (n4 = 0; n4 < n7; ++n4) {
            JRETest.test_rec(dArray);
        }
        l3 = System.currentTimeMillis() - l2;
        for (n4 = 0; n4 < n7; ++n4) {
            JRETest.test_local(dArray);
        }
        l2 = System.currentTimeMillis();
        for (n4 = 0; n4 < n7; ++n4) {
            JRETest.test_local(dArray);
        }
        l4 = System.currentTimeMillis() - l2;
        double d = (double)((int)(10000.0 * (double)l3 / (double)l4)) / 100.0;
        System.out.println("CALL: recursive array-access speed is " + d + "% of the final local code");
        for (n3 = 0; n3 < n7; ++n3) {
            JRETest.test_local2(dArray);
        }
        l2 = System.currentTimeMillis();
        for (n3 = 0; n3 < n7; ++n3) {
            JRETest.test_local2(dArray);
        }
        l4 = System.currentTimeMillis() - l2;
        d = (double)((int)(10000.0 * (double)l3 / (double)l4)) / 100.0;
        System.out.println("CALL: recursive array-access speed is " + d + "% of the non-final local code");
        for (n3 = 0; n3 < n7; ++n3) {
            jRETest.test_local3(dArray);
        }
        l2 = System.currentTimeMillis();
        for (n3 = 0; n3 < n7; ++n3) {
            jRETest.test_local3(dArray);
        }
        l4 = System.currentTimeMillis() - l2;
        d = (double)((int)(10000.0 * (double)l3 / (double)l4)) / 100.0;
        System.out.println("CALL: recursive array-access speed is " + d + "% of the non-final member local code");
        JRETest.mem_start();
        Object object2 = new Object();
        long l5 = JRETest.mem_end();
        System.out.println("MEMORY: Object size = " + l5);
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        for (n2 = -1; n2 < 22; ++n2) {
            n = JRETest.rnd_size(n2);
            JRETest.mem_start();
            object = new int[n];
            l = JRETest.mem_end();
            l6 = Math.max(l6, l - (long)(4 * n) - l5);
            JRETest.mem_start();
            short[] sArray = new short[n];
            l = JRETest.mem_end();
            l7 = Math.max(l7, l - (long)(2 * n) - l5);
            JRETest.mem_start();
            byte[] byArray = new byte[n];
            l = JRETest.mem_end();
            l8 = Math.max(l8, l - (long)(1 * n) - l5);
        }
        JDDConsole.out.println("MEMORY: int array memory overhead: " + l6);
        JDDConsole.out.println("MEMORY: short array memory overhead: " + l7);
        JDDConsole.out.println("MEMORY: byte array memory overhead: " + l8);
        n = 10000;
        object = new Random();
        l = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            n2 = FastRandom.mtrand() % n;
            n2 = FastRandom.mtrand() % n;
            n2 = FastRandom.mtrand() % n;
            n2 = FastRandom.mtrand() % n;
            n2 = FastRandom.mtrand() % n;
            n2 = FastRandom.mtrand() % n;
        }
        l = System.currentTimeMillis() - l;
        long l9 = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            n2 = ((Random)object).nextInt(n);
            n2 = ((Random)object).nextInt(n);
            n2 = ((Random)object).nextInt(n);
            n2 = ((Random)object).nextInt(n);
            n2 = ((Random)object).nextInt(n);
            n2 = ((Random)object).nextInt(n);
        }
        l9 = System.currentTimeMillis() - l9;
        if (l < l9) {
            JDDConsole.out.println("LPRNG: FastRandom.mtrand() is " + (100L * l9 / l - 100L) + "% faster that Java code");
        } else {
            JDDConsole.out.println("LPRNG: Java is " + (100L * l / l9 - 100L) + "% faster that FastRandom.mtrand()");
        }
    }
}

