/*
 * Decompiled with CFR 0.152.
 */
package jdd.graph;

import jdd.graph.Node;
import jdd.util.Sortable;

public class Edge
implements Sortable {
    public static final int FLAGS_NONE = 0;
    public static final int FLAGS_STRONG = 1;
    public static final int FLAGS_MARKED = 2;
    public static final int FLAGS_WEIGTHED = 4;
    public static final int FLAGS_LABLED = 8;
    public Node n1;
    public Node n2;
    public int id;
    public int flags;
    public int extra1;
    public int extra2;
    public double weight;
    public double extra3;
    public Edge next;
    public Edge prev;
    public String label;

    public Edge(Node node, Node node2, int n) {
        this(node, node2, n, null);
    }

    public Edge(Node node, Node node2, int n, String string) {
        this.n1 = node;
        this.n2 = node2;
        this.id = n;
        this.flags = 0;
        this.weight = 1.0;
        this.next = null;
        this.prev = null;
        this.setLabel(string);
    }

    public void setLabel(String string) {
        this.label = string;
        this.flags = string != null ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public String getLabel() {
        return (this.flags & 8) == 0 ? "E" + this.id : this.label;
    }

    @Override
    public boolean greater_than(Sortable sortable) {
        return this.weight > ((Edge)sortable).weight;
    }

    public void setWeight(double d) {
        this.weight = d;
        this.flags |= 4;
    }

    public double getWeight() {
        return this.weight;
    }

    public void copyAttributesFrom(Edge edge) {
        this.flags = edge.flags;
        this.extra1 = edge.extra1;
        this.extra2 = edge.extra2;
        this.extra3 = edge.extra3;
        this.weight = edge.weight;
    }
}

