/*
 * Decompiled with CFR 0.152.
 */
package jdd.bdd;

import jdd.bdd.NodeTable;
import jdd.bdd.SimpleCache;
import jdd.util.JDDConsole;
import jdd.util.Test;
import jdd.util.math.Digits;

public final class OptimizedCache
extends SimpleCache {
    protected int possible_bins_count;
    protected int num_partial_clears;
    protected long partial_count;
    protected long partial_kept;
    protected long partial_given_up;
    private long access_last_gc;
    private int cache_not_used_count;

    public OptimizedCache(String string, int n, int n2, int n3) {
        super(string, n, n2, n3);
        Test.check(n3 <= 3, "BDD members cannot be more than 3 for this type of cache!");
        this.partial_kept = 0L;
        this.partial_count = 0L;
        this.possible_bins_count = 0;
        this.num_partial_clears = 0;
        this.access_last_gc = 0L;
        this.cache_not_used_count = 0;
        this.partial_given_up = 0L;
    }

    protected boolean shouldWipeUnusedCache() {
        this.cache_not_used_count = this.access_last_gc == this.num_access ? ++this.cache_not_used_count : 0;
        this.access_last_gc = this.num_access;
        return this.cache_not_used_count > 5;
    }

    @Override
    public void invalidate_cache() {
        if (this.possible_bins_count != 0) {
            super.invalidate_cache();
            this.possible_bins_count = 0;
        }
    }

    @Override
    protected void grow_and_invalidate_cache() {
        super.grow_and_invalidate_cache();
        this.possible_bins_count = 0;
    }

    @Override
    public void invalidate_cache(NodeTable nodeTable) {
        if (this.bdds < 1) {
            Test.check(false, "Cannot partiall clean a non-bdd cache!");
        }
        if (this.possible_bins_count == 0) {
            return;
        }
        if (this.shouldWipeUnusedCache()) {
            ++this.partial_given_up;
            this.invalidate_cache();
            return;
        }
        int n = 0;
        if (this.bdds == 3) {
            n = this.partial_clean3(nodeTable);
        } else if (this.bdds == 2) {
            n = this.partial_clean2(nodeTable);
        } else if (this.bdds == 1) {
            n = this.partial_clean1(nodeTable);
        }
        ++this.num_partial_clears;
        this.partial_count += (long)this.cache_size;
        this.partial_kept += (long)n;
        this.possible_bins_count = n;
    }

    private final int partial_clean3(NodeTable nodeTable) {
        int n = 0;
        int n2 = this.cache_size;
        while (n2 != 0) {
            if (!(this.isValid(--n2) && nodeTable.isValid(this.getIn(n2, 1)) && nodeTable.isValid(this.getIn(n2, 2)) && nodeTable.isValid(this.getIn(n2, 3)) && nodeTable.isValid(this.getOut(n2)))) {
                this.invalidate(n2);
                continue;
            }
            ++n;
        }
        return n;
    }

    private final int partial_clean2(NodeTable nodeTable) {
        int n = 0;
        int n2 = this.cache_size;
        while (n2 != 0) {
            if (!(this.isValid(--n2) && nodeTable.isValid(this.getIn(n2, 1)) && nodeTable.isValid(this.getIn(n2, 2)) && nodeTable.isValid(this.getOut(n2)))) {
                this.invalidate(n2);
                continue;
            }
            ++n;
        }
        return n;
    }

    private final int partial_clean1(NodeTable nodeTable) {
        int n = 0;
        int n2 = this.cache_size;
        while (n2 != 0) {
            if (!(this.isValid(--n2) && nodeTable.isValid(this.getIn(n2, 1)) && nodeTable.isValid(this.getOut(n2)))) {
                this.invalidate(n2);
                continue;
            }
            ++n;
        }
        return n;
    }

    @Override
    public void insert(int n, int n2, int n3) {
        super.insert(n, n2, n3);
        ++this.possible_bins_count;
    }

    @Override
    public void insert(int n, int n2, int n3, int n4) {
        super.insert(n, n2, n3, n4);
        ++this.possible_bins_count;
    }

    @Override
    public void insert(int n, int n2, int n3, int n4, int n5) {
        super.insert(n, n2, n3, n4, n5);
        ++this.possible_bins_count;
    }

    @Override
    public int getNumberOfPartialClears() {
        return this.num_partial_clears;
    }

    @Override
    public void showStats() {
        if (this.num_access != 0L) {
            JDDConsole.out.print(this.getName() + "-cache ");
            JDDConsole.out.print("ld=" + this.computeLoadFactor() + "% ");
            JDDConsole.out.print("sz=");
            Digits.printNumber1024(this.cache_size);
            JDDConsole.out.print("accs=");
            Digits.printNumber1024(this.num_access);
            JDDConsole.out.print("clrs=" + this.num_clears + "/" + this.num_partial_clears + " ");
            JDDConsole.out.print("hitr=" + this.computeHitRate() + "% ");
            if (this.partial_count > 0L) {
                double d = (double)((int)(10000.0 * (double)this.partial_kept / (double)this.partial_count)) / 100.0;
                JDDConsole.out.print("pck=" + d + "% ");
            }
            if (this.partial_given_up > 0L) {
                JDDConsole.out.print("giveup=" + this.partial_given_up + " ");
            }
            if (this.num_grows > 0) {
                JDDConsole.out.print("grws=" + this.num_grows + " ");
            }
            JDDConsole.out.println();
        }
    }

    public static void internal_test() {
        Test.start("OptimizedCache");
        OptimizedCache optimizedCache = new OptimizedCache("test", 200, 3, 3);
        optimizedCache.add(2, 1, 2, 3);
        Test.check(optimizedCache.lookup(2, 1, 2) && optimizedCache.answer == 3, "lookup 3");
        optimizedCache.add(2, 1, 2, 5);
        Test.check(optimizedCache.lookup(2, 1, 2) && optimizedCache.answer == 5, "lookup overwritten with 5");
        Test.check(!optimizedCache.lookup(1, 1, 2), "non-existing entry 1");
        Test.check(!optimizedCache.lookup(2, 2, 2), "non-existing entry 2");
        Test.check(!optimizedCache.lookup(2, 2, 1), "non-existing entry 3");
        optimizedCache = new OptimizedCache("test", 200, 2, 2);
        optimizedCache.add(2, 1, 3);
        Test.check(optimizedCache.lookup(2, 1) && optimizedCache.answer == 3, "lookup 3");
        optimizedCache.add(2, 1, 5);
        Test.check(optimizedCache.lookup(2, 1) && optimizedCache.answer == 5, "lookup overwritten with 5");
        Test.check(!optimizedCache.lookup(1, 1), "non-existing entry 1");
        Test.check(!optimizedCache.lookup(2, 2), "non-existing entry 2");
        optimizedCache = new OptimizedCache("test", 200, 1, 1);
        optimizedCache.add(1, 3);
        Test.check(optimizedCache.lookup(1) && optimizedCache.answer == 3, "lookup 3");
        optimizedCache.add(1, 5);
        Test.check(optimizedCache.lookup(1) && optimizedCache.answer == 5, "lookup overwritten with 5");
        Test.check(!optimizedCache.lookup(2), "non-existing entry 1");
        Test.check(!optimizedCache.lookup(3), "non-existing entry 2");
        Test.end();
    }
}

