/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.kernel;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.oarts.pirka.core.ajax.AjaxScript;
import jp.oarts.pirka.core.ctrl.SelectList;
import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.kernel.PirkaImage;
import jp.oarts.pirka.core.kernel.PirkaUploadManager;
import jp.oarts.pirka.core.util.field.FieldItem;
import jp.oarts.pirka.core.util.format.FieldFormat;
import jp.oarts.pirka.core.util.format.PirkaFormatUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldMap
implements Serializable {
    protected HashMap<String, FieldItem> fieldMap = new HashMap();

    public void setValue(String fieldName, String value) {
        this.checkFieldName(fieldName);
        FieldItem fieldItem = this.fieldMap.get(fieldName);
        fieldItem.getCtrl().getCtrlProcesser().setValue(value == null ? "" : value, fieldItem);
    }

    public void setGroupValue(String fieldName, String value) {
        this.setGroupValueMain(this, fieldName, value == null ? "" : value, 0);
    }

    private void setGroupValueMain(FieldMap fieldMap, String fieldName, String value, int groupLevel) {
        String[] fieldNames;
        String[] stringArray = fieldNames = fieldMap.getFieldNames();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String name = stringArray[n];
            FieldItem fieldItem = fieldMap.getFieldItem(name);
            if (fieldItem.getCtrl().getCtrlProcesser().isGroupItem() && fieldName.equals(fieldItem.getCtrl().getBaseName()) && groupLevel == fieldItem.getCtrl().getGroupLevel()) {
                if (value.equals(fieldItem.getValue())) {
                    fieldItem.setChecked(true);
                } else {
                    fieldItem.setChecked(false);
                }
            }
            if (fieldItem.getCtrl().getCtrlProcesser().isLoop()) {
                List loopList = (List)fieldItem.getValue();
                for (FieldMap childMap : loopList) {
                    this.setGroupValueMain(childMap, fieldName, value, groupLevel + 1);
                }
            }
            ++n;
        }
    }

    public void setValue(String fieldName, String[] values) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = values;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String value = stringArray[n];
            if (sb.length() > 0) {
                sb.append('\t');
            }
            sb.append(value);
            ++n;
        }
        this.setValue(fieldName, sb.toString());
    }

    public void setValue(String fieldName, boolean value) {
        this.checkFieldName(fieldName);
        FieldItem fieldItem = this.fieldMap.get(fieldName);
        fieldItem.getCtrl().getCtrlProcesser().setValue(value, fieldItem);
    }

    public void setValue(String fieldName, int value) {
        this.setValue(fieldName, "" + value);
    }

    public void setValue(String fieldName, long value) {
        this.setValue(fieldName, "" + value);
    }

    public void setValue(String fieldName, BigDecimal value) {
        if (value == null) {
            this.setValue(fieldName, "");
        } else {
            this.setValue(fieldName, value.toString());
        }
    }

    public void setValue(String fieldName, Date value) {
        if (value == null) {
            this.setValue(fieldName, "");
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
            this.setValue(fieldName, sdf.format(value));
        }
    }

    public void setValue(String fieldName, Time value) {
        if (value == null) {
            this.setValue(fieldName, "");
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
            this.setValue(fieldName, sdf.format(value));
        }
    }

    public void setValue(String fieldName, Timestamp value) {
        if (value == null) {
            this.setValue(fieldName, "");
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            this.setValue(fieldName, sdf.format(value));
        }
    }

    public void setFieldMap(String fieldName, int index, FieldMap fieldMapValue) {
        this.checkFieldName(fieldName);
        if (!this.fieldMap.get(fieldName).getCtrl().getCtrlProcesser().isLoop()) {
            throw new RuntimeException("\u6307\u5b9a\u3055\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u306f\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        List list = (List)this.fieldMap.get(fieldName).getValue();
        list.set(index, fieldMapValue);
    }

    public void addFieldMap(String fieldName, FieldMap fieldMapValue) {
        this.checkFieldName(fieldName);
        if (!this.fieldMap.get(fieldName).getCtrl().getCtrlProcesser().isLoop()) {
            throw new RuntimeException("\u6307\u5b9a\u3055\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u306f\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        List list = (List)this.fieldMap.get(fieldName).getValue();
        list.add(fieldMapValue);
    }

    public void removeFieldMap(String fieldName, int index) {
        this.checkFieldName(fieldName);
        if (!this.fieldMap.get(fieldName).getCtrl().getCtrlProcesser().isLoop()) {
            throw new RuntimeException("\u6307\u5b9a\u3055\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u306f\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        List list = (List)this.fieldMap.get(fieldName).getValue();
        list.remove(index);
    }

    public void clearFieldMap(String fieldName) {
        this.checkFieldName(fieldName);
        if (!this.fieldMap.get(fieldName).getCtrl().getCtrlProcesser().isLoop()) {
            throw new RuntimeException("\u6307\u5b9a\u3055\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u306f\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        List list = (List)this.fieldMap.get(fieldName).getValue();
        list.clear();
    }

    public void clearAllValue() {
        Map<String, String> groupMap = FieldMap.createGroupMap(this);
        for (String fieldName : this.fieldMap.keySet()) {
            FieldItem fieldItem = this.fieldMap.get(fieldName);
            CtrlProcesser cp = fieldItem.getCtrl().getCtrlProcesser();
            if (cp.isInputCtrl() && !cp.isGroupItem()) {
                if (cp.isCheckCtrl()) {
                    this.setValue(fieldName, false);
                    continue;
                }
                this.setValue(fieldName, "");
                continue;
            }
            if (cp.isSwitch()) {
                this.setValue(fieldName, false);
                continue;
            }
            if (!cp.isLoop()) continue;
            this.clearFieldMap(fieldName);
        }
        for (String fieldName : groupMap.keySet()) {
            this.setGroupValue(fieldName, "");
        }
    }

    public String getValueString(String fieldName) {
        this.checkFieldName(fieldName);
        if (this.fieldMap.get(fieldName).getCtrl().getCtrlProcesser().isLoop()) {
            throw new RuntimeException("\u6307\u5b9a\u3055\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u306f\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        return (String)this.fieldMap.get(fieldName).getValue();
    }

    public String getGroupValue(String fieldName) {
        return this.getGroupValueMain(this, fieldName, 0);
    }

    private String getGroupValueMain(FieldMap fieldMap, String fieldName, int groupLevel) {
        String[] fieldNames;
        String[] stringArray = fieldNames = fieldMap.getFieldNames();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String name = stringArray[n];
            FieldItem fieldItem = fieldMap.getFieldItem(name);
            if (fieldItem.getCtrl().getCtrlProcesser().isGroupItem() && fieldName.equals(fieldItem.getCtrl().getBaseName()) && groupLevel == fieldItem.getCtrl().getGroupLevel() && fieldItem.isChecked()) {
                return (String)fieldItem.getValue();
            }
            if (fieldItem.getCtrl().getCtrlProcesser().isLoop()) {
                List loopList = (List)fieldItem.getValue();
                for (FieldMap childMap : loopList) {
                    String ret = this.getGroupValueMain(childMap, fieldName, groupLevel + 1);
                    if (ret.length() <= 0) continue;
                    return ret;
                }
            }
            ++n;
        }
        return "";
    }

    public String[] getValueStrings(String fieldName) {
        this.checkFieldName(fieldName);
        if (this.fieldMap.get(fieldName).getCtrl().getCtrlProcesser().isLoop()) {
            throw new RuntimeException("\u6307\u5b9a\u3055\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u306f\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        if (this.getValueString(fieldName).length() <= 0) {
            return new String[0];
        }
        return this.getValueString(fieldName).split("\\t");
    }

    public boolean getValueBoolean(String fieldName) {
        this.checkFieldName(fieldName);
        if (this.fieldMap.get(fieldName).getCtrl().getCtrlProcesser().isLoop()) {
            throw new RuntimeException("\u6307\u5b9a\u3055\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u306f\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        Object booleanValue = this.fieldMap.get(fieldName).getValue();
        if (!(booleanValue instanceof Boolean)) {
            return false;
        }
        return (Boolean)booleanValue;
    }

    public Integer getValueIntObject(String fieldName) {
        String value = this.getValueString(fieldName);
        return PirkaFormatUtil.parseInteger(value);
    }

    public int getValueInt(String fieldName) {
        return this.getValueInt(fieldName, 0);
    }

    public int getValueInt(String fieldName, int defaultValue) {
        String value = this.getValueString(fieldName);
        if (value == null) {
            return defaultValue;
        }
        Integer intValue = PirkaFormatUtil.parseInteger(value);
        if (intValue == null) {
            return defaultValue;
        }
        return intValue;
    }

    public Long getValueLongObject(String fieldName) {
        String value = this.getValueString(fieldName);
        return PirkaFormatUtil.parseLong(value);
    }

    public long getValueLong(String fieldName) {
        return this.getValueLong(fieldName, 0L);
    }

    public long getValueLong(String fieldName, long defaultValue) {
        String value = this.getValueString(fieldName);
        if (value == null) {
            return defaultValue;
        }
        Long longValue = PirkaFormatUtil.parseLong(value);
        if (longValue == null) {
            return defaultValue;
        }
        return longValue;
    }

    public BigDecimal getValueBigDecimal(String fieldName) {
        String value = this.getValueString(fieldName);
        return PirkaFormatUtil.parseBigDecimal(value);
    }

    public Date getValueDate(String fieldName) {
        String value = this.getValueString(fieldName);
        return PirkaFormatUtil.parseDate(value);
    }

    public Time getValueTime(String fieldName) {
        String value = this.getValueString(fieldName);
        return PirkaFormatUtil.parseTime(value);
    }

    public Timestamp getValueTimestamp(String fieldName) {
        String value = this.getValueString(fieldName);
        return PirkaFormatUtil.parseTimestamp(value);
    }

    public int getFieldMapSize(String fieldName) {
        this.checkFieldName(fieldName);
        if (!this.fieldMap.get(fieldName).getCtrl().getCtrlProcesser().isLoop()) {
            throw new RuntimeException("\u6307\u5b9a\u3055\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u306f\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        List list = (List)this.fieldMap.get(fieldName).getValue();
        return list.size();
    }

    public FieldMap getFieldMap(String fieldName, int index) {
        this.checkFieldName(fieldName);
        if (!this.fieldMap.get(fieldName).getCtrl().getCtrlProcesser().isLoop()) {
            throw new RuntimeException("\u6307\u5b9a\u3055\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u306f\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        List list = (List)this.fieldMap.get(fieldName).getValue();
        return (FieldMap)list.get(index);
    }

    public FieldMap[] getFieldMaps(String fieldName) {
        this.checkFieldName(fieldName);
        if (!this.fieldMap.get(fieldName).getCtrl().getCtrlProcesser().isLoop()) {
            throw new RuntimeException("\u6307\u5b9a\u3055\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u306f\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        List list = (List)this.fieldMap.get(fieldName).getValue();
        return list.toArray(new FieldMap[0]);
    }

    public InputStream getInputStream(String fieldName) throws IOException {
        this.checkFieldName(fieldName);
        long fileNo = this.fieldMap.get(fieldName).getFileNo();
        if (fileNo > 0L) {
            return PirkaUploadManager.getInputStream(fileNo);
        }
        return null;
    }

    public void setOption(String fieldName, String optionName) {
        this.setOption(fieldName, optionName, null);
    }

    public void setOption(String fieldName, String optionName, String optionValue) {
        this.checkFieldName(fieldName);
        if ("name".equalsIgnoreCase(optionName)) {
            throw new RuntimeException("name\u5c5e\u6027\u306f\u5909\u66f4\u3067\u304d\u307e\u305b\u3093");
        }
        if ("type".equalsIgnoreCase(optionName)) {
            throw new RuntimeException("type\u5c5e\u6027\u306f\u5909\u66f4\u3067\u304d\u307e\u305b\u3093");
        }
        if ("value".equalsIgnoreCase(optionName)) {
            throw new RuntimeException("value\u5c5e\u6027\u306f\u5909\u66f4\u3067\u304d\u307e\u305b\u3093\u3002\u30c7\u30fc\u30bf\u30e1\u30bd\u30c3\u30c9\u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        Map<String, String> map = this.fieldMap.get(fieldName).getCtrl().getOptionMap();
        map.put(optionName.toLowerCase(), optionValue);
    }

    public void setOption(String fieldName, Map<String, String> optionMap) {
        String[] keys;
        optionMap.remove("name");
        optionMap.remove("type");
        optionMap.remove("value");
        String[] stringArray = keys = optionMap.keySet().toArray(new String[0]);
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String key = stringArray[n];
            String toLowKey = key.toLowerCase();
            if (!key.equals(toLowKey)) {
                String value = optionMap.get(key);
                optionMap.remove(key);
                optionMap.put(key, value);
            }
            ++n;
        }
        this.fieldMap.get(fieldName).getCtrl().setOptionMap(optionMap);
    }

    public boolean isOptionExist(String fieldName, String optionName) {
        this.checkFieldName(fieldName);
        return this.fieldMap.get(fieldName).getCtrl().getOptionMap().containsKey(optionName.toLowerCase());
    }

    public String getOption(String fieldName, String optionName) {
        this.checkFieldName(fieldName);
        return this.fieldMap.get(fieldName).getCtrl().getOptionMap().get(optionName.toLowerCase());
    }

    public Map<String, String> getOption(String fieldName) {
        this.checkFieldName(fieldName);
        return this.fieldMap.get(fieldName).getCtrl().getOptionMap();
    }

    public void clearOption(String fieldName, String optionName) {
        this.checkFieldName(fieldName);
        this.fieldMap.get(fieldName).getCtrl().getOptionMap().remove(optionName.toLowerCase());
    }

    public void clearOption(String fieldName) {
        this.checkFieldName(fieldName);
        this.fieldMap.get(fieldName).getCtrl().getOptionMap().clear();
    }

    public void setSelectList(String fieldName, SelectList selectList) {
        this.checkFieldName(fieldName);
        this.fieldMap.get(fieldName).getCtrl().setSelectList(selectList);
    }

    public SelectList getSelectList(String fieldName) {
        this.checkFieldName(fieldName);
        return this.fieldMap.get(fieldName).getCtrl().getSelectList();
    }

    public void clearSelectList(String fieldName) {
        this.checkFieldName(fieldName);
        SelectList selectList = this.fieldMap.get(fieldName).getCtrl().getSelectList();
        if (selectList != null) {
            selectList.clear();
        }
    }

    public void setAjaxScript(String fieldName, AjaxScript ajaxScript) {
        this.checkFieldName(fieldName);
        this.fieldMap.get(fieldName).getCtrl().setAjaxScript(ajaxScript);
    }

    public AjaxScript getAjaxScript(String fieldName) {
        this.checkFieldName(fieldName);
        return this.fieldMap.get(fieldName).getCtrl().getAjaxScript();
    }

    public void setError(String fieldName, boolean errorFlag) {
        this.checkFieldName(fieldName);
        this.fieldMap.get(fieldName).setErrorFlag(errorFlag);
    }

    public boolean isError(String fieldName) {
        this.checkFieldName(fieldName);
        return this.fieldMap.get(fieldName).isErrorFlag();
    }

    public void setFormat(String fieldName, FieldFormat fieldFormat) {
        this.checkFieldName(fieldName);
        if (!this.fieldMap.get(fieldName).getCtrl().getCtrlProcesser().isFormatCtrl()) {
            throw new RuntimeException("\u6307\u5b9a\u3055\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u306f\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        this.fieldMap.get(fieldName).getCtrl().setFormat(fieldFormat);
    }

    public FieldFormat getFormat(String fieldName) {
        this.checkFieldName(fieldName);
        if (!this.fieldMap.get(fieldName).getCtrl().getCtrlProcesser().isFormatCtrl()) {
            throw new RuntimeException("\u6307\u5b9a\u3055\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u306f\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        return this.fieldMap.get(fieldName).getCtrl().getFormat();
    }

    public void clearFormat(String fieldName) {
        this.checkFieldName(fieldName);
        if (!this.fieldMap.get(fieldName).getCtrl().getCtrlProcesser().isFormatCtrl()) {
            throw new RuntimeException("\u6307\u5b9a\u3055\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u306f\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        this.fieldMap.get(fieldName).getCtrl().setFormat(null);
    }

    public void setSafeMode(String fieldName, boolean safeFlag) {
        this.checkFieldName(fieldName);
        this.fieldMap.get(fieldName).getCtrl().setWebSafe(safeFlag);
    }

    public boolean isSafeMode(String fieldName) {
        this.checkFieldName(fieldName);
        return this.fieldMap.get(fieldName).getCtrl().isWebSafe();
    }

    public void setTagEffective(String fieldName, boolean tagEffective) {
        this.checkFieldName(fieldName);
        this.fieldMap.get(fieldName).getCtrl().setTagEffective(tagEffective);
    }

    public boolean isTagEffective(String fieldName) {
        this.checkFieldName(fieldName);
        return this.fieldMap.get(fieldName).getCtrl().isTagEffective();
    }

    public void setGroupLoopLevel(String fieldName, int groupLevel) {
        this.checkFieldName(fieldName);
        this.fieldMap.get(fieldName).getCtrl().setGroupLevel(groupLevel);
    }

    public int getGroupLevel(String fieldName) {
        this.checkFieldName(fieldName);
        return this.fieldMap.get(fieldName).getCtrl().getGroupLevel();
    }

    public void setSuffixFlag(String fieldName, boolean suffixFlag) {
        this.checkFieldName(fieldName);
        this.fieldMap.get(fieldName).getCtrl().setSuffix(suffixFlag);
    }

    public void setImage(String fieldName, PirkaImage image) {
        this.checkFieldName(fieldName);
        this.fieldMap.get(fieldName).getCtrl().setImage(image);
    }

    public void setAutoCheck(String fieldName, boolean autoCheckFlag) {
        this.checkFieldName(fieldName);
        this.fieldMap.get(fieldName).getCtrl().setAutoCheck(autoCheckFlag);
    }

    public void setOfficialFieldName(String fieldName, String officialFieldName) {
        this.checkFieldName(fieldName);
        this.fieldMap.get(fieldName).getCtrl().setOfficialFieldName(officialFieldName);
    }

    public String getOfficialFieldName(String fieldName) {
        this.checkFieldName(fieldName);
        return this.fieldMap.get(fieldName).getCtrl().getOfficialFieldName();
    }

    @Deprecated
    public Map<String, FieldItem> getRootMap() {
        HashMap<String, FieldItem> rootMap = new HashMap<String, FieldItem>();
        this.remakeRootMap(rootMap, this.fieldMap, "");
        return rootMap;
    }

    @Deprecated
    protected void remakeRootMap(Map<String, FieldItem> rootMap, HashMap<String, FieldItem> map, String loopSuffix) {
        for (String fieldName : map.keySet()) {
            Object object;
            FieldItem fieldItem = map.get(fieldName);
            rootMap.put(String.valueOf(fieldName) + loopSuffix, fieldItem);
            if (!fieldItem.getCtrl().getCtrlProcesser().isLoop() || (object = fieldItem.getValue()) == null || !(object instanceof List)) continue;
            List list = (List)object;
            int index = 0;
            while (index < list.size()) {
                FieldMap childMap = (FieldMap)list.get(index);
                this.remakeRootMap(rootMap, childMap.fieldMap, String.valueOf(loopSuffix) + '$' + index);
                ++index;
            }
        }
    }

    @Deprecated
    public Object clone() {
        FieldMap newMap = new FieldMap();
        for (String key : this.fieldMap.keySet()) {
            FieldItem fieldItem = this.fieldMap.get(key);
            if (fieldItem.getValue() != null && fieldItem.getValue() instanceof List) {
                ArrayList<FieldMap> list = new ArrayList<FieldMap>();
                for (FieldMap fieldMap : (List)fieldItem.getValue()) {
                    list.add((FieldMap)fieldMap.clone());
                }
                newMap.setFieldItem(key, new FieldItem(list, fieldItem.isChecked(), fieldItem.getFileNo(), (HtmlCtrlParts)fieldItem.getCtrl().clone(), fieldItem.getFormat(), fieldItem.getLoopDeepLevel()));
                continue;
            }
            newMap.setFieldItem(key, new FieldItem(fieldItem.getValue(), fieldItem.isChecked(), fieldItem.getFileNo(), (HtmlCtrlParts)fieldItem.getCtrl().clone(), fieldItem.getFormat(), fieldItem.getLoopDeepLevel()));
        }
        return newMap;
    }

    @Deprecated
    public boolean containsKey(String fieldName) {
        return this.fieldMap.containsKey(fieldName);
    }

    @Deprecated
    public String[] getFieldNames() {
        return this.fieldMap.keySet().toArray(new String[0]);
    }

    @Deprecated
    public void setFieldItem(String fieldName, FieldItem fieldItem) {
        this.fieldMap.put(fieldName, fieldItem);
    }

    @Deprecated
    public FieldItem getFieldItem(String fieldName) {
        return this.fieldMap.get(fieldName);
    }

    @Deprecated
    Map<String, FieldItem> getMap() {
        return this.fieldMap;
    }

    private static Map<String, String> createGroupMap(FieldMap fieldMap) {
        HashMap<String, String> groupMap = new HashMap<String, String>();
        FieldMap.createGroupMapMain(groupMap, fieldMap, 0);
        return groupMap;
    }

    private static void createGroupMapMain(Map<String, String> groupMap, FieldMap fieldMap, int groupLevel) {
        String[] fieldNames;
        String[] stringArray = fieldNames = fieldMap.getFieldNames();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String fieldName = stringArray[n];
            FieldItem fieldItem = fieldMap.getFieldItem(fieldName);
            CtrlProcesser cp = fieldItem.getCtrl().getCtrlProcesser();
            if (cp.isGroupItem() && fieldItem.getCtrl().getGroupLevel() == groupLevel) {
                groupMap.put(fieldItem.getCtrl().getBaseName(), fieldItem.getCtrl().getBaseName());
            }
            if (cp.isLoop()) {
                List list = (List)fieldItem.getValue();
                for (FieldMap childFieldMap : list) {
                    FieldMap.createGroupMapMain(groupMap, childFieldMap, groupLevel + 1);
                }
            }
            ++n;
        }
    }

    private void checkFieldName(String fieldName) {
        if (!this.fieldMap.containsKey(fieldName)) {
            throw new RuntimeException("\u7121\u52b9\u306a\u30d5\u30a3\u30fc\u30eb\u30c9\u540d\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f " + fieldName);
        }
    }
}

