/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.util.check;

import java.io.Serializable;
import jp.oarts.pirka.core.util.check.Checker;
import jp.oarts.pirka.core.util.check.PirkaCheckException;
import jp.oarts.pirka.core.util.format.PirkaFormatUtil;

public class PirkaChecker
implements Serializable {
    public static final Checker required = new Checker(){

        public void check(String value) throws PirkaCheckException {
            if (value == null || value.length() <= 0) {
                throw new PirkaCheckException("\u672a\u5165\u529b\u3067\u3059");
            }
        }
    };
    public static final Checker intValue = new Checker(){

        public void check(String value) throws PirkaCheckException {
            if (value.length() > 0 && PirkaFormatUtil.parseInteger(value) == null) {
                throw new PirkaCheckException("\u5165\u529b\u3055\u308c\u305f\u5024\u306f\u6570\u5024\u4ee5\u5916\u3082\u3057\u304f\u306f\u6841\u6570\u30aa\u30fc\u30d0\u30fc\u3067\u3059");
            }
        }
    };
    public static final Checker longValue = new Checker(){

        public void check(String value) throws PirkaCheckException {
            if (value.length() > 0 && PirkaFormatUtil.parseLong(value) == null) {
                throw new PirkaCheckException("\u5165\u529b\u3055\u308c\u305f\u5024\u306f\u6570\u5024\u4ee5\u5916\u3082\u3057\u304f\u306f\u6841\u6570\u30aa\u30fc\u30d0\u30fc\u3067\u3059");
            }
        }
    };
    public static final Checker numeric = new Checker(){

        public void check(String value) throws PirkaCheckException {
            if (value.length() > 0 && PirkaFormatUtil.parseBigDecimal(value) == null) {
                throw new PirkaCheckException("\u5165\u529b\u3055\u308c\u305f\u5024\u306f\u6570\u5024\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
            }
        }
    };
    public static final Checker date = new Checker(){

        public void check(String value) throws PirkaCheckException {
            if (value.length() > 0 && PirkaFormatUtil.parseDate(value) == null) {
                throw new PirkaCheckException("\u5165\u529b\u3055\u308c\u305f\u65e5\u4ed8\u306e\u66f8\u5f0f\u306b\u3042\u3084\u307e\u308a\u304c\u3042\u308a\u307e\u3059");
            }
        }
    };
    public static final Checker time = new Checker(){

        public void check(String value) throws PirkaCheckException {
            if (value.length() > 0 && PirkaFormatUtil.parseTime(value) == null) {
                throw new PirkaCheckException("\u5165\u529b\u3055\u308c\u305f\u6642\u523b\u306e\u66f8\u5f0f\u306b\u3042\u3084\u307e\u308a\u304c\u3042\u308a\u307e\u3059");
            }
        }
    };
    public static final Checker datetime = new Checker(){

        public void check(String value) throws PirkaCheckException {
            if (value.length() > 0 && PirkaFormatUtil.parseTimestamp(value) == null) {
                throw new PirkaCheckException("\u5165\u529b\u3055\u308c\u305f\u65e5\u4ed8\u6642\u523b\u306e\u66f8\u5f0f\u306b\u3042\u3084\u307e\u308a\u304c\u3042\u308a\u307e\u3059");
            }
        }
    };

    public static boolean checkString(String string, String ... existStrings) {
        int length = string.length();
        int i = 0;
        while (i < length) {
            char c = string.charAt(i);
            boolean flg = false;
            String[] stringArray = existStrings;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String existString = stringArray[n];
                if (existString.indexOf(c) >= 0) {
                    flg = true;
                    break;
                }
                ++n;
            }
            if (!flg) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNumber(String string) {
        return PirkaChecker.checkString(string, "0123456789");
    }
}

