package jp.oarts.pirka.core.analyzer.html;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.util.field.FieldItem;

public class HtmlLoopFieldMapAnalyzer  implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = -4281583591449109572L;

	/**
	 * tB[h}bv胋[vRg[̃tB[h}bv擾
	 * 
	 * @param fieldMap
	 *            tB[h}bv
	 * @return [vRg[EtB[h}bv
	 */
	public static void getLoopFieldMap(FieldMap fieldMap, Map<String, FieldMap> loopFieldMap, Map<String, FieldItem> defaultFieldMap, Map<String, String> groupFieldMap) {

		getLoopFieldMapMain(fieldMap, loopFieldMap, defaultFieldMap, groupFieldMap);
	}

	/**
	 * tB[h}bv胋[vRg[̃tB[h}bv擾
	 * 
	 * @param fieldMap
	 *            tB[h}bv
	 * @param loopFieldMap
	 *            [vRg[EtB[h}bv
	 */
	public static void getLoopFieldMapMain(FieldMap fieldMap, Map<String, FieldMap> loopFieldMap, Map<String, FieldItem> defaultFieldMap, Map<String, String> groupFieldMap) {

		String[] fieldNames = fieldMap.getFieldNames();
		for (String fieldName : fieldNames) {

			int suffixIndex = fieldName.indexOf('$');
			if (suffixIndex >= 0) {
				String groupName = fieldName.substring(0, suffixIndex);
				groupFieldMap.put(groupName, groupName);
			}

			FieldItem fieldItem = fieldMap.getFieldItem(fieldName);
			if (!defaultFieldMap.containsKey(fieldName)) {
				defaultFieldMap.put(fieldName, fieldItem);
			}

			if (fieldItem.getCtrl().getCtrlProcesser().isLoop()) {
				Object object = fieldItem.getValue();
				if (object != null && object instanceof List && ((List) object).size() > 0) {
					List<FieldMap> list = (List<FieldMap>) object;
					FieldMap loopMap = list.get(0);
					list.clear();
					loopFieldMap.put(fieldName, (FieldMap) loopMap);
					getLoopFieldMapMain(loopMap, loopFieldMap, defaultFieldMap, groupFieldMap);
				}
			}

		}
	}

}
