/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.ctrl.proc;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.ctrl.proc.UnknownProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.AProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.ButtonSubmitProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.DivLoopProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.DivSwitchProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.FormProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.ImageProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.ImgProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.InputCheckboxProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.InputFileProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.InputHiddenProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.InputImageProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.InputPasswordProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.InputRadioProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.InputSubmitProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.InputTextProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.LabelProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.ScriptProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.SelectProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.SpanProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.TextareaProcesser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CtrlProcesserManager
implements Serializable {
    private static Map<String, CtrlProcesser> defaultCtrlProcesserMap;
    private static CtrlProcesser unknownProcesser;
    static /* synthetic */ Class class$0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<CtrlProcesserManager> clazz = CtrlProcesserManager.class;
        synchronized (CtrlProcesserManager.class) {
            defaultCtrlProcesserMap = new HashMap<String, CtrlProcesser>();
            defaultCtrlProcesserMap.put("a", new AProcesser());
            defaultCtrlProcesserMap.put("button#submit", new ButtonSubmitProcesser());
            defaultCtrlProcesserMap.put("div#loop", new DivLoopProcesser());
            defaultCtrlProcesserMap.put("div#switch", new DivSwitchProcesser());
            defaultCtrlProcesserMap.put("form", new FormProcesser());
            defaultCtrlProcesserMap.put("img", new ImgProcesser());
            defaultCtrlProcesserMap.put("image", new ImageProcesser());
            defaultCtrlProcesserMap.put("input#checkbox", new InputCheckboxProcesser());
            defaultCtrlProcesserMap.put("input#file", new InputFileProcesser());
            defaultCtrlProcesserMap.put("input#hidden", new InputHiddenProcesser());
            defaultCtrlProcesserMap.put("input#image", new InputImageProcesser());
            defaultCtrlProcesserMap.put("input#password", new InputPasswordProcesser());
            defaultCtrlProcesserMap.put("input#radio", new InputRadioProcesser());
            defaultCtrlProcesserMap.put("input#submit", new InputSubmitProcesser());
            defaultCtrlProcesserMap.put("input#text", new InputTextProcesser());
            defaultCtrlProcesserMap.put("label", new LabelProcesser());
            defaultCtrlProcesserMap.put("script", new ScriptProcesser());
            defaultCtrlProcesserMap.put("select", new SelectProcesser());
            defaultCtrlProcesserMap.put("span", new SpanProcesser());
            defaultCtrlProcesserMap.put("textarea", new TextareaProcesser());
            unknownProcesser = new UnknownProcesser();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static CtrlProcesser getDefaultCtrlProcesser(String name) {
        return defaultCtrlProcesserMap.get(name);
    }

    public static CtrlProcesser getUnknownProcesser() {
        return unknownProcesser;
    }

    public static CtrlProcesser getCtrlProseccer(String processerName, Map<String, CtrlProcesser> ctrlProcesserMap) {
        CtrlProcesser ctrlProcesser = null;
        String processerTagName = null;
        if (ctrlProcesserMap != null) {
            ctrlProcesser = ctrlProcesserMap.get(processerName);
            if (ctrlProcesser != null) {
                return ctrlProcesser;
            }
            processerTagName = CtrlProcesserManager.getProcesserTagName(processerName);
            if (processerTagName != null && processerTagName.length() > 0 && (ctrlProcesser = ctrlProcesserMap.get(processerTagName)) != null) {
                return ctrlProcesser;
            }
        }
        if ((ctrlProcesser = CtrlProcesserManager.getDefaultCtrlProcesser(processerName)) != null) {
            return ctrlProcesser;
        }
        if (processerTagName == null) {
            processerTagName = CtrlProcesserManager.getProcesserTagName(processerName);
        }
        if (processerTagName != null && processerTagName.length() > 0 && (ctrlProcesser = CtrlProcesserManager.getDefaultCtrlProcesser(processerTagName)) != null) {
            return ctrlProcesser;
        }
        return CtrlProcesserManager.getUnknownProcesser();
    }

    private static String getProcesserTagName(String processerName) {
        int index = processerName.indexOf(35);
        if (index <= 0) {
            return "";
        }
        return processerName.substring(0, index);
    }
}

