/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.util.check;

import jp.oarts.pirka.core.util.check.Checker;
import jp.oarts.pirka.core.util.check.PirkaCheckException;

public class PirkaCheckerLength
implements Checker {
    public static final MODE JUST = MODE.JUST;
    public static final MODE RANGE = MODE.RANGE;
    private MODE mode;
    private int[] lengths;

    public PirkaCheckerLength(MODE mode, int ... lengths) {
        if (lengths.length <= 0) {
            throw new RuntimeException("\u6841\u6570\u30c1\u30a7\u30c3\u30af\u306e\u6841\u6570\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (mode == RANGE && lengths.length % 2 == 1) {
            throw new RuntimeException("\u6841\u6570\u30c1\u30a7\u30c3\u30af\u3067\u7bc4\u56f2\u6307\u5b9a(RANGE)\u306e\u3068\u304d\u306b\u6307\u5b9a\u3067\u304d\u308b\u6841\u6570\u306f\u5076\u6570\u3067\u306a\u3051\u308c\u3070\u3070\u308a\u307e\u305b\u3093");
        }
        this.mode = mode;
        this.lengths = lengths;
    }

    public void check(String value) throws PirkaCheckException {
        int valueLength = value.length();
        if (valueLength <= 0) {
            return;
        }
        if (this.mode == JUST) {
            int[] nArray = this.lengths;
            int n = 0;
            int n2 = nArray.length;
            while (n < n2) {
                int length = nArray[n];
                if (valueLength == length) {
                    return;
                }
                ++n;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("\u6841\u6570\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059 \u5165\u529b\u53ef\u80fd\u306a\u6841\u6570\u306f");
            boolean first = true;
            int[] nArray2 = this.lengths;
            int n3 = 0;
            int n4 = nArray2.length;
            while (n3 < n4) {
                int length = nArray2[n3];
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append(length);
                ++n3;
            }
            sb.append("\u6841\u3067\u3059");
            throw new PirkaCheckException(sb.toString());
        }
        int i = 0;
        while (i < this.lengths.length) {
            if (this.lengths[i] <= valueLength && valueLength <= this.lengths[i + 1]) {
                return;
            }
            i += 2;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\u6841\u6570\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059 \u5165\u529b\u53ef\u80fd\u306a\u6841\u6570\u306f");
        int i2 = 0;
        while (i2 < this.lengths.length) {
            if (i2 > 0) {
                sb.append(", ");
            }
            sb.append(this.lengths[i2]);
            sb.append("\uff5e");
            sb.append(this.lengths[i2 + 1]);
            i2 += 2;
        }
        sb.append("\u6841\u3067\u3059");
        throw new PirkaCheckException(sb.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MODE {
        JUST,
        RANGE;

    }
}

