/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.kernel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.oarts.pirka.core.app.EntryPointIF;
import jp.oarts.pirka.core.kernel.PirkaThreadMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PirkaUploadManager
implements Serializable {
    private static long fileNo = 0L;
    private static Map<Long, InputStream> inputStreamMap = new HashMap<Long, InputStream>();

    public static synchronized long getFileNo() {
        return ++fileNo;
    }

    public static synchronized OutputStream getOutputStream(long fileNo) throws IOException {
        EntryPointIF entryPoint = PirkaThreadMap.getEntryPointObjct();
        OutputStream os = entryPoint.getTempFileManager().getOutputStream(fileNo);
        return os;
    }

    public static synchronized InputStream getInputStream(long fileNo) throws IOException {
        if (inputStreamMap.containsKey(fileNo)) {
            throw new IOException("\u65e2\u306b\u53d6\u5f97\u6e08\u307f\u3067\u3059");
        }
        EntryPointIF entryPoint = PirkaThreadMap.getEntryPointObjct();
        InputStream fis = entryPoint.getTempFileManager().getInputStream(fileNo);
        inputStreamMap.put(fileNo, fis);
        return fis;
    }

    private static synchronized void deleteFile(long fileNo) throws IOException {
        if (inputStreamMap.containsKey(fileNo)) {
            InputStream is = inputStreamMap.get(fileNo);
            inputStreamMap.remove(fileNo);
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        EntryPointIF entryPoint = PirkaThreadMap.getEntryPointObjct();
        entryPoint.getTempFileManager().delete(fileNo);
    }

    public static synchronized void deleteFile(List<Long> deleteFineNoList) throws IOException {
        Long[] deleteFileNos;
        Long[] longArray = deleteFileNos = deleteFineNoList.toArray(new Long[0]);
        int n = 0;
        int n2 = longArray.length;
        while (n < n2) {
            Long fileNo = longArray[n];
            PirkaUploadManager.deleteFile(fileNo);
            ++n;
        }
    }
}

