package jp.oarts.pirka.sample.instruction.is102400;

import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.util.check.PirkaChecker;
import jp.oarts.pirka.core.util.check.PirkaCheckerString;
import jp.oarts.pirka.core.util.check.PirkaCheckerStringChars;
import jp.oarts.pirka.core.win.PirkaWindow;
import jp.oarts.pirka.sample.instruction.is102200.AutoCheckOkSample;

/**
 * pirkatTv `FbN𐏎Ăяo@
 */
public class CallCheckSample extends PirkaWindow {

	/**
	 * RXgN^
	 */
	public CallCheckSample() {

		//  ȍږi{ꖼj̐ݒ
		FieldMap field = getFieldMap();
		field.setOfficialFieldName("text01", "01");
		field.setOfficialFieldName("text02", "02");

		//  `FbJ[̃Zbg
		addCheck("text01", PirkaChecker.required);
		addCheck("text02", new PirkaCheckerString(PirkaCheckerStringChars.WIDE));
		addErrorCheckReturner();

		// si`FbNĂяoj{^͎`FbNsȂw
		field.setAutoCheck("exec2Button", false);
	}

	/**
	 * s{^
	 * 
	 * @return	EChE
	 */
	public PirkaWindow execButton() {
		return new AutoCheckOkSample();
	}

	/**
	 * si`FbNĂяoj{^
	 * 
	 * @return	EChE
	 */
	public PirkaWindow exec2Button() {
		// `FbNƓ̃`FbNs
		check();
		return new AutoCheckOkSample();
	}

	/**
	 * ߂郊N
	 * 
	 * @return
	 */
	public PirkaWindow returnWindow() {
		return null;
	}

}
