/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.app;

import java.io.UnsupportedEncodingException;
import jp.oarts.pirka.core.util.converter.ReqCharacterConverter;

public class DefaultReqCharacterConverter
implements ReqCharacterConverter {
    private static final long serialVersionUID = 1L;
    private static final DefaultReqCharacterConverter object = new DefaultReqCharacterConverter();

    public static ReqCharacterConverter getInstance() {
        return object;
    }

    public String convertKanji(String value) {
        try {
            return this.MSKanjiConv(value.getBytes("8859_1"));
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    public String convertKanji(byte[] value) {
        try {
            return this.MSKanjiConv(value);
        }
        catch (UnsupportedEncodingException e) {
            try {
                return new String(value, "8859_1");
            }
            catch (UnsupportedEncodingException e2) {
                return new String(value);
            }
        }
    }

    public String MSKanjiConv(byte[] bytes) throws UnsupportedEncodingException {
        boolean jisFlg = false;
        int i = 0;
        while (i < bytes.length) {
            if (i + 2 < bytes.length && bytes[i] == 27 && bytes[i + 1] == 36) {
                jisFlg = true;
                break;
            }
            ++i;
        }
        if (jisFlg) {
            return new String(this.jis2SJis(bytes), "MS932");
        }
        String euc = "";
        try {
            euc = new String(bytes, "EUC_JP");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String JISAutoDetect = "";
        try {
            JISAutoDetect = new String(bytes, "JISAutoDetect");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String ms932 = "";
        try {
            ms932 = new String(this.jis2SJis(bytes), "MS932");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (!euc.equals(JISAutoDetect)) {
            return ms932;
        }
        if (this.charCount(ms932, '?') <= this.charCount(euc, '?')) {
            return ms932;
        }
        return euc;
    }

    private int charCount(String str, char chr) {
        int count = 0;
        if (str != null) {
            int length = str.length();
            int i = 0;
            while (i < length) {
                if (str.charAt(i) == chr) {
                    ++count;
                }
                ++i;
            }
        }
        return count;
    }

    private byte[] jis2SJis(byte[] buff) {
        int op = 0;
        int mode = 1;
        int i = 0;
        while (i < buff.length) {
            if (buff[i] == 27) {
                if (i + 2 < buff.length) {
                    if (buff[i + 1] == 40) {
                        mode = 1;
                    } else if (buff[i + 1] == 36) {
                        mode = 2;
                    }
                }
                i += 2;
            } else if (mode == 1) {
                buff[op++] = buff[i];
            } else {
                if (i + 1 < buff.length) {
                    int c1 = buff[i] >= 0 ? buff[i] : 256 + buff[i];
                    int c2 = buff[i + 1] >= 0 ? buff[i + 1] : 256 + buff[i + 1];
                    if (c1 % 2 != 0) {
                        c1 = (c1 + 1) / 2 + 112;
                        c2 += 31;
                    } else {
                        c1 = c1 / 2 + 112;
                        c2 += 125;
                    }
                    if (c1 >= 160) {
                        c1 += 64;
                    }
                    if (c2 >= 127) {
                        ++c2;
                    }
                    buff[op++] = c1 > 127 ? (byte)(c1 - 256) : (byte)c1;
                    buff[op++] = c2 > 127 ? (byte)(c2 - 256) : (byte)c2;
                }
                ++i;
            }
            ++i;
        }
        byte[] rtn = new byte[op];
        System.arraycopy(buff, 0, rtn, 0, op);
        return rtn;
    }
}

