/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.util.check;

import java.math.BigDecimal;
import jp.oarts.pirka.core.util.check.Checker;
import jp.oarts.pirka.core.util.check.PirkaCheckException;
import jp.oarts.pirka.core.util.format.PirkaFormatUtil;

public class PirkaCheckerNumericRange
implements Checker {
    private static final long serialVersionUID = -1879615178277880975L;
    private MODE mode;
    private long minLong;
    private long maxLong;
    private BigDecimal minBigDecimal;
    private BigDecimal maxBigDecimal;

    public PirkaCheckerNumericRange(int minInt, int maxInt) {
        this.mode = MODE.longVal;
        this.minLong = minInt;
        this.maxLong = maxInt;
    }

    public PirkaCheckerNumericRange(long minLong, long maxLong) {
        this.mode = MODE.longVal;
        this.minLong = minLong;
        this.maxLong = maxLong;
    }

    public PirkaCheckerNumericRange(BigDecimal minBigDecimal, BigDecimal maxBigDecimal) {
        this.mode = MODE.realVal;
        this.minBigDecimal = minBigDecimal;
        this.maxBigDecimal = maxBigDecimal;
    }

    public void check(String value) throws PirkaCheckException {
        if (value.length() <= 0) {
            return;
        }
        if (this.mode == MODE.longVal) {
            Long num = PirkaFormatUtil.parseLong(value);
            if (num == null) {
                throw new PirkaCheckException("\u6570\u5024\u4ee5\u5916\u304c\u5165\u529b\u3055\u308c\u307e\u3057\u305f");
            }
            if (num < this.minLong || this.maxLong < num) {
                throw new PirkaCheckException("\u7bc4\u56f2\u5916\u306e\u6570\u5024\u304c\u5165\u529b\u3055\u308c\u307e\u3057\u305f " + this.minLong + "\uff5e" + this.maxLong + "\u306e\u7bc4\u56f2\u3067\u5165\u529b\u53ef\u80fd\u3067\u3059");
            }
        } else {
            BigDecimal num = PirkaFormatUtil.parseBigDecimal(value);
            if (num == null) {
                throw new PirkaCheckException("\u6570\u5024\u4ee5\u5916\u304c\u5165\u529b\u3055\u308c\u307e\u3057\u305f");
            }
            if (this.minBigDecimal.compareTo(num) > 0 || this.maxBigDecimal.compareTo(num) < 0) {
                throw new PirkaCheckException("\u7bc4\u56f2\u5916\u306e\u6570\u5024\u304c\u5165\u529b\u3055\u308c\u307e\u3057\u305f " + this.minBigDecimal.toString() + "\uff5e" + this.maxBigDecimal.toString() + "\u306e\u7bc4\u56f2\u3067\u5165\u529b\u53ef\u80fd\u3067\u3059");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MODE {
        longVal,
        realVal;

    }
}

