package jp.oarts.pirka.sample;

import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.util.check.PirkaChecker;
import jp.oarts.pirka.core.win.PirkaWindow;

public class ReverseLookup extends PirkaWindow {

	private static final int MAX_GROUP_LINE = 4;

	public ReverseLookup() {
		addCheck("selectNo", PirkaChecker.numeric);
		addErrorCheckReturner();

		FieldMap field = getFieldMap();
		field.clearFieldMap("loop1");

		int lineNo = 0;
		FieldMap loop1Field = null;
		for (int no : InstructionData.getInstructionDataKeySet()) {
			InstructionData data = InstructionData.getInstructionData(no);
			if ((lineNo % MAX_GROUP_LINE) == 0) {
				loop1Field = createLoopFieldMap("loop1");
				field.addFieldMap("loop1", loop1Field);
			}
			lineNo++;

			FieldMap loop2Field = createLoopFieldMap("loop2");
			loop1Field.addFieldMap("loop2", loop2Field);
			loop2Field.setOption("itemLink", "onClick", "select(" + no + ");");
			loop2Field.setValue("linkTitle", data.getSampleName());
		}

	}

	public PirkaWindow onElse() {

		check();

		FieldMap field = getFieldMap();

		int selectNo = field.getValueInt("selectNo");
		InstructionData instructionData = InstructionData.getInstructionData(selectNo);
		if (instructionData == null) {
			return this;
		}
		return new Instruction(selectNo, instructionData);
	}
}
