package jp.oarts.pirka.sample.instruction.is103300;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.util.check.PirkaChecker;
import jp.oarts.pirka.core.util.format.NumericFieldFormat;
import jp.oarts.pirka.core.win.PirkaWindow;

/**
 * pirkatTv [ṽtB[h̏l̐ݒ@
 */
public class LoopDefault extends PirkaWindow {

	List<ListData> list;

	/**
	 * RXgN^
	 */
	public LoopDefault() {
		// f[^
		list = new LinkedList<ListData>();
		list.add(new ListData("`R[g", 1500, 0, 0));
		list.add(new ListData("̂ǃA", 100, 0, 0));
		list.add(new ListData("ׂ", 200, 0, 0));
		list.add(new ListData("ACXN[", 250, 0, 0));

		// `FbJ[o^
		addCheck("amount", PirkaChecker.intValue);
		addErrorCheckReturner();

		FieldMap field = getFieldMap();
		field.setFormat("totalAmount", new NumericFieldFormat("\\#,##0"));

		// [ṽtB[h̏l̐ݒ
		FieldMap loopField = getDefaultLoopFieldMap("loopItem");
		loopField.setOfficialFieldName("amount", "");
		loopField.setFormat("unitPrice", new NumericFieldFormat("@#,##0"));
		loopField.setFormat("amount", new NumericFieldFormat("#,##0"));
		loopField.setFormat("amountOfMoney", new NumericFieldFormat("\\#,##0"));
		loopField.setOption("amountOfMoneyTD", "style", "background-color: #c0ffc0");

		calc();
	}

	/**
	 * ČvZ{^
	 */
	public void calcButton() {
		FieldMap field = getFieldMap();
		// ꗗf[^̈ꊇ擾
		getBeanList(list, field, "loopItem");
		calc();
	}

	/**
	 * ߂郊N
	 * 
	 * @return
	 */
	public PirkaWindow returnWindow() {
		return null;
	}

	/**
	 * vZ
	 */
	private void calc() {

		FieldMap field = getFieldMap();

		//	vZ
		long total = 0;
		int no = 0;
		for (ListData data : list) {
			data.setNo(++no);
			data.setAmountOfMoney(((long) data.getUnitPrice()) * data.getAmount());
			total += data.getAmountOfMoney();
		}

		// ꗗf[^̈ꊇݒ
		setBeanList(list, field, "loopItem");

		// vݒ
		field.setValue("totalAmount", total);
	}

	/**
	 * Xgf[^NX
	 */
	public class ListData implements Serializable {

		private int no;

		private String name;

		private int unitPrice;

		private int amount;

		private long amountOfMoney;

		public ListData(String name, int unitPrice, int amount, long amountOfMoney) {
			this.no = 0;
			this.name = name;
			this.unitPrice = unitPrice;
			this.amount = amount;
			this.amountOfMoney = amountOfMoney;
		}

		/**
		 * @return no ߂܂B
		 */
		public int getNo() {
			return no;
		}

		/**
		 * @param no ݒ肷 noB
		 */
		public void setNo(int no) {
			this.no = no;
		}

		/**
		 * @return amount ߂܂B
		 */
		public int getAmount() {
			return amount;
		}

		/**
		 * @param amount ݒ肷 amountB
		 */
		public void setAmount(int amount) {
			this.amount = amount;
		}

		/**
		 * @return amountOfMoney ߂܂B
		 */
		public long getAmountOfMoney() {
			return amountOfMoney;
		}

		/**
		 * @param amountOfMoney ݒ肷 amountOfMoneyB
		 */
		public void setAmountOfMoney(long amountOfMoney) {
			this.amountOfMoney = amountOfMoney;
		}

		/**
		 * @return name ߂܂B
		 */
		public String getName() {
			return name;
		}

		/**
		 * @param name ݒ肷 nameB
		 */
		public void setName(String name) {
			this.name = name;
		}

		/**
		 * @return unitPrice ߂܂B
		 */
		public int getUnitPrice() {
			return unitPrice;
		}

		/**
		 * @param unitPrice ݒ肷 unitPriceB
		 */
		public void setUnitPrice(int unitPrice) {
			this.unitPrice = unitPrice;
		}

	}

}
