#!/bin/sh
if [ ! -e $4 ]; then
  echo "File $4 is not exists"
fi
base_dir=${0%/*}
if [ $base_dir = $0 ]; then
    base_dir="./"
fi
echo "gzip -cd $4 > ${4%.gz}"
gzip -cd $4 > ${4%.gz}
if [[ $1 -eq 0 ]]; then
    python $base_dir/import_logs.py -dd --dry-run --replay-tracking --url=$PIWIK_TRACK_URL --token-auth=$PIWIK_TRACK_TOKEN_AUTH --log-format-name=apache_fluentd --config=$PIWIK_TRACK_INSTALL_DIR/config/config.ini.php --recorders=4 --recorder-max-payload-size=200 --import-time-start=$2 --import-time-end=$3 ${4%.gz} 2>&1 | tee ${4%.gz}.archive
else
    python $base_dir/import_logs.py -dd --dry-run --idsite=$1 --url=$PIWIK_URL --token-auth=$PIWIK_TOKEN_AUTH --config=$PIWIK_INSTALL_DIR/config/config.ini.php --recorders=4 --recorder-max-payload-size=200 --enable-bot --log-format-name=apache_fluentd --static-extensions-include=jpe,json --static-extensions-exclude=xml --download-extensions-include=img,iso --download-extensions-exclude=asx,xml,pdf,xls,xlsx,doc,docx,ppt,pptx --exclude-path-from=$base_dir/../exclude/exclude_idsite${1}.txt --import-time-start=$2 --import-time-end=$3 ${4%.gz} 2>&1 | tee ${4%.gz}.archive
fi
if [ $PIWIK_DONT_ARCHIVE -ne 1 ]; then
    $PIWIK_INSTALL_DIR/console core:archive --url=$PIWIK_URL 2>&1 | tee -a ${4%.gz}.archive
    if [[ $PIWIK_TRACK_SERVER_DIVIDED -eq 1 ]]; then
        $PIWIK_TRACK_INSTALL_DIR/console core:archive --url=$PIWIK_TRACK_URL 2>&1 | tee -a ${4%.gz}.archive
    fi
fi
echo "/bin/rm -rf ${4%.gz}"
/bin/rm -rf ${4%.gz}
