<?php
require_once 'Plugg/FormController.php';

abstract class Plugg_ModelEntityController extends Plugg_FormController
{
    /**
     * @var string
     * @access protected
     */
    protected $_entityName;
    /**
     * @var array
     * @access protected
     */
    protected $_options = array();

    /**
     * Constructor
     *
     * @param string $entityName
     * @param array $options
     * @return Plugg_ModelEntityController
     */
    protected function __construct($entityName, array $options = array())
    {
        $this->_entityName = $entityName;
        $this->_options = array_merge(array(
            'viewName'   => null,
            'successUrl' => null,
            'errorUrl'   => null
        ), $options);
    }

    protected function _getErrorUrl(Sabai_Application_Context $context)
    {
        if (empty($this->_options['errorUrl'])) {
            return $this->url->getScriptUrl();
        }

        if (is_array($this->_options['errorUrl'])) {
            return $this->url->create($this->_options['errorrl']);
        }

        return $this->_options['errorUrl'];
    }

    protected function _getSuccessUrl(Sabai_Application_Context $context)
    {
        if (empty($this->_options['successUrl'])) {
            return $this->url->getScriptUrl();
        }

        if (is_array($this->_options['successUrl'])) {
            return $this->url->create($this->_options['successUrl']);
        }

        return $this->_options['successUrl'];
    }

    protected function _getOption($name)
    {
        return $this->_options[$name];
    }

    protected function _setOption($name, $value)
    {
        $this->_options[$name] = $value;
    }
}