<?php
require_once 'Plugg/PluginFront.php';

class Plugg_PluginAdmin extends Plugg_PluginFront
{
    public function __construct($controller_prefix, $controller_dir, $defaultController = 'Index')
    {
        parent::__construct($defaultController, $controller_prefix, $controller_dir);
        $this->addFilters(array('isAuthenticated', 'isAdmin'));
    }

    protected function _frontBeforeFilter(Sabai_Application_Context $context)
    {
        parent::_frontBeforeFilter($context);

        // Init page info
        $context->response
            ->clearPageInfo()
            ->setPageInfo($this->gettext->_('Home'), array('base' => '/'))
            ->setPageInfo($this->gettext->_('Plugins'), array('base' => '/system/plugin'));
        if ($this->_setPageInfo) {
            $context->response->setPageInfo($context->plugin->getNicename(), array(
                'base' => '/' . $context->plugin->getName()
            ));
            $this->_setPageInfo = false;
        }
    }
}