<?php
class Plugg_User_Admin_Role_Member extends Plugg_RoutingController
{
    function Plugg_User_Admin_Role_Member()
    {
        parent::__construct('List', 'Plugg_User_Admin_Role_Member_', dirname(__FILE__) . '/Member');
        $this->addControllerFilter(array('Delete'), 'isValidMemberRequested');
    }

    function _doGetRoutes(Sabai_Application_Context $context)
    {
        return array(
            'list' => array('controller' => 'List'),
            'submit' => array('controller' => 'Submit'),
            'add' => array('controller' => 'Create'),
            ':member_id/remove' => array(
                'controller' => 'Delete',
                'requirements' => array(':member_id' => '\d+')
            )
        );
    }

    function isValidMemberRequestedBeforeFilter(Sabai_Application_Context $context)
    {
        $this->_parent->isValidEntityRequested($context, 'Member');
    }

    function isValidMemberRequestedAfterFilter(Sabai_Application_Context $context){}
}