<?php
/*
This file has been generated by the Sabai scaffold script. Do not edit this file directly.
If you need to customize the class, use the following file:
pluginsy/User/Model/MemberGateway.php
*/
abstract class Plugg_User_Model_Base_MemberGateway extends Sabai_Model_Gateway
{
    public function getName()
    {
        return 'member';
    }

    public function getFields()
    {
        return array('member_id' => Sabai_Model::KEY_TYPE_INT, 'member_created' => Sabai_Model::KEY_TYPE_INT, 'member_updated' => Sabai_Model::KEY_TYPE_INT, 'member_role_id' => Sabai_Model::KEY_TYPE_INT_NULL, 'member_userid' => Sabai_Model::KEY_TYPE_VARCHAR);
    }

    protected function _getSelectByIdQuery($id, array $fields)
    {
        $fields = empty($fields) ? '*' : implode(', t.', $fields);
        return sprintf('SELECT t.%s FROM %smember t WHERE member_id = %d', $fields, $this->_db->getResourcePrefix(), $id);
    }

    protected function _getSelectByCriteriaQuery($criteriaStr, array $fields)
    {
        $fields = empty($fields) ? '*' : implode(', t.', $fields);
        return sprintf('SELECT t.%1$s FROM %2$smember t WHERE %3$s', $fields, $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _getInsertQuery(array $values)
    {
        $values['member_created'] = time();
        $values['member_updated'] = 0;
        $values['member_role_id'] = !empty($values['member_role_id']) ? intval($values['member_role_id']) : 'NULL';
        return sprintf("INSERT INTO %smember(member_created, member_updated, member_role_id, member_userid) VALUES(%d, %d, %s, %s)", $this->_db->getResourcePrefix(), $values['member_created'], $values['member_updated'], $values['member_role_id'], $this->_db->escapeString($values['member_userid']));
    }

    protected function _getUpdateQuery($id, array $values)
    {
        $values['member_role_id'] = !empty($values['member_role_id']) ? intval($values['member_role_id']) : 'NULL';
        $last_update = $values['member_updated'];
        $values['member_updated'] = time();
        return sprintf("UPDATE %smember SET member_updated = %d, member_role_id = %s, member_userid = %s WHERE member_id = %d AND member_updated = %d", $this->_db->getResourcePrefix(), $values['member_updated'], $values['member_role_id'], $this->_db->escapeString($values['member_userid']), $id, $last_update);
    }

    protected function _getDeleteQuery($id)
    {
        return sprintf('DELETE FROM %1$smember WHERE member_id = %2$d', $this->_db->getResourcePrefix(), $id);
    }

    protected function _getUpdateByCriteriaQuery($criteriaStr, array $sets)
    {
        $sets['member_updated'] = 'member_updated=' . time();
        return sprintf('UPDATE %smember SET %s WHERE %s', $this->_db->getResourcePrefix(), implode(',', $sets), $criteriaStr);
    }

    protected function _getDeleteByCriteriaQuery($criteriaStr)
    {
        return sprintf('DELETE FROM %1$smember WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _getCountByCriteriaQuery($criteriaStr)
    {
        return sprintf('SELECT COUNT(*) FROM %1$smember WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _afterInsertTrigger1($id, array $new)
    {
        if (!empty($new['member_role_id'])) {
            $this->_db->exec(sprintf('UPDATE %srole SET role_member_count = role_member_count + 1, role_member_last = %d, role_member_lasttime = %d WHERE role_id = %d', $this->_db->getResourcePrefix(), $id, $new['member_created'], $new['member_role_id']));
        }
    }

    protected function _afterDeleteTrigger1($id, array $old)
    {
        if (!empty($old['member_role_id'])) {
            $sql = sprintf('SELECT member_id, member_created FROM %smember WHERE member_role_id = %d ORDER BY member_created DESC', $this->_db->getResourcePrefix(), $old['member_role_id']);
            if (($rs = $this->_db->query($sql, 1, 0)) && ($rs->rowCount() > 0)) {
                $row = $rs->fetchAssoc();
                $this->_db->exec(sprintf('UPDATE %srole SET role_member_count = role_member_count - 1, role_member_last = %d, role_member_lasttime = %d WHERE role_id = %d', $this->_db->getResourcePrefix(), $row['member_id'], $row['member_created'], $old['member_role_id']));
            } else {
                $this->_db->exec(sprintf('UPDATE %srole SET role_member_count = role_member_count - 1, role_member_last = 0, role_member_lasttime = role_created WHERE role_id = %d', $this->_db->getResourcePrefix(), $old['member_role_id']));
            }
        }
    }

    protected function _afterUpdateTrigger1($id, array $new, array $old)
    {
        if (empty($old['member_role_id']) && !empty($new['member_role_id'])) {
            $this->_db->exec(sprintf('UPDATE %srole SET role_member_count = role_member_count + 1, role_member_last = %d, role_member_lasttime = %d WHERE role_id = %d', $this->_db->getResourcePrefix(), $id, $new['member_created'], $new['member_role_id']));
        } elseif (!empty($old['member_role_id']) && empty($new['member_role_id'])) {
            $sql = sprintf('SELECT member_id, member_created FROM %smember WHERE member_role_id = %d ORDER BY member_created DESC', $this->_db->getResourcePrefix(), $old['member_role_id']);
            if (($rs = $this->_db->query($sql, 1, 0)) && ($rs->rowCount() > 0)) {
                $row = $rs->fetchAssoc();
                $this->_db->exec(sprintf('UPDATE %srole SET role_member_count = role_member_count - 1, role_member_last = %d, role_member_lasttime = %d WHERE role_id = %d', $this->_db->getResourcePrefix(), $row['member_id'], $row['member_created'], $old['member_role_id']));
            } else {
                $this->_db->exec(sprintf('UPDATE %srole SET role_member_count = role_member_count - 1, role_member_last = 0, role_member_lasttime = role_created WHERE role_id = %d', $this->_db->getResourcePrefix(), $old['member_role_id']));
            }
        } elseif ($old['member_role_id'] != $new['member_role_id']) {
            $sql = sprintf('SELECT member_id, member_created FROM %smember WHERE member_role_id = %d ORDER BY member_created DESC', $this->_db->getResourcePrefix(), $old['member_role_id']);
            if (($rs = $this->_db->query($sql, 1, 0)) && ($rs->rowCount() > 0)) {
                $row = $rs->fetchAssoc();
                $this->_db->exec(sprintf('UPDATE %srole SET role_member_count = role_member_count - 1, role_member_last = %d, role_member_lasttime = %d WHERE role_id = %d', $this->_db->getResourcePrefix(), $row['member_id'], $row['member_created'], $old['member_role_id']));
            } else {
                $this->_db->exec(sprintf('UPDATE %srole SET role_member_count = role_member_count - 1, role_member_last = 0, role_member_lasttime = role_created WHERE role_id = %d', $this->_db->getResourcePrefix(), $old['member_role_id']));
            }
            $this->_db->exec(sprintf('UPDATE %srole SET role_member_count = role_member_count + 1, role_member_last = %d, role_member_lasttime = %d WHERE role_id = %d', $this->_db->getResourcePrefix(), $id, $new['member_created'], $new['member_role_id']));
        }
    }

    protected function _afterInsertTrigger($id, array $new)
    {
        $this->_afterInsertTrigger1($id, $new);
    }

    protected function _afterUpdateTrigger($id, array $new, array $old)
    {
        $this->_afterUpdateTrigger1($id, $new, $old);
    }

    protected function _afterDeleteTrigger($id, array $old)
    {
        $this->_afterDeleteTrigger1($id, $old);
    }
}