<?php
class Plugg_Message_User_Main_Identity_Message extends Plugg_RoutingController
{   
    public function __construct()
    {
        parent::__construct('View', 'Plugg_Message_User_Main_Identity_Message_', dirname(__FILE__) . '/Message');
        $this->addFilters(array('_isValidMessageRequested'));
        $this->addControllerFilter('Reply', 'isValidOwnerAccess');
    }
    
    protected function _isValidMessageRequestedBeforeFilter(Sabai_Application_Context $context)
    {
        // Make sure the requested message exists and belongs to the user
        $identity = $this->getRequestedUserIdentity($context);
        if ((!$message = $this->getRequestedMessage($context)) ||
            !$message->isOwnedBy($identity)
        ) {
            $context->response->setError($context->plugin->_('Invalid request'));
            $context->response->send($this->_application);
        }
    }
    
    protected function _isValidMessageRequestedAfterFilter(Sabai_Application_Context $context){}

    protected function _doGetRoutes(Sabai_Application_Context $context)
    {
        return array(
            'reply'   => array(
                'controller' => 'Reply',
            ),
            'submit'   => array(
                'controller' => 'Submit',
            ),
        );
    }

    public function getRequestedMessage(Sabai_Application_Context $context, $clearCache = false)
    {
        if ($message_id = $context->request->getAsInt('message_id')) {
            if ($message = $context->plugin->getModel()->Message->fetchById($message_id, $clearCache)) {
                $message->cache();
                return $message;
            }
        }
        return false;
    }
}