<?php
class Plugg_Message_User_Main_Identity_Message_View extends Sabai_Application_Controller
{
    protected function _doExecute(Sabai_Application_Context $context)
    {
        $message = $this->_parent->getRequestedMessage($context);
 
        // Mark message as read if still unread
        if (!$message->isRead()) {
            $message->markRead();
            $message->commit();
            
            // Clear inbox user menu in session
            $this->pluginManager->getPlugin('user')->clearMenuInSession($context->plugin->getName(), 'inbox');
        }
       
        $context->response->setPageInfo($message->get('title'));
        $context->response->setPageTitle('');
        $context->response->setVars(array(
            'message' => $message,
            'message_from_to_user' => $this->locator->getService('UserIdentityFetcher')->fetchUserIdentity($message->get('from_to'), true),
            'tab_id' => $context->request->getAsInt('tab_id'),
        ));
    }
}