<?php
require_once 'Plugg/FormController.php';

class Plugg_Xigg_Main_DeleteCommentForm extends Plugg_FormController
{
    private $_comment;
    
    protected function _init(Sabai_Application_Context $context)
    {
        $this->_confirmable = false;
        
        if (!$comment_id = $context->request->getAsInt('comment_id')) {
            return false;
        }
        if (!$this->_comment = $context->plugin->getModel()->Comment->fetchById($comment_id)) {
            return false;
        }
        if (!$context->user->hasPermission('xigg comment delete any')) {
            if (!$this->_comment->isOwnedBy($context->user) ||
                !$context->user->hasPermission('xigg comment delete own')
            ) {
                $context->response->setError($context->plugin->_('Permission denied'), array(
                    'path' => '/comment/' . $this->_comment->getId()
                ));
                return false;
            }
        }
        
        return true;
    }
    
    protected function _submitForm(Sabai_Application_Context $context, Sabai_HTMLQuickForm $form)
    {
        $this->_comment->markRemoved();
        $return_url = array('path' => '/' . $this->_comment->getVar('node_id'));
        if ($context->plugin->getModel()->commit()) {
            $context->response->setSuccess(sprintf($context->plugin->_('Comment #%d deleted successfully'), $this->_comment->getId()), $return_url);
            $this->pluginManager->dispatch('XiggDeleteCommentSuccess', array($context, $this->_comment));
            return true;
        }
        
        $error = $context->plugin->_('Comment #%d could not be deleted. There was either an error while commit or the comment has one or more child comments.');
        $context->response->setError(sprintf($error, $this->_comment->getId()), $return_url);
        
        return false;
    }
    
    protected function _viewForm(Sabai_Application_Context $context, Sabai_HTMLQuickForm $form)
    {
        $context->response->setPageInfo($this->_comment->Node->title, array(
            'path' => '/' . $this->_comment->Node->getId()
        ));
        $context->response->setPageInfo($context->plugin->_('Delete comment'));
    }

    protected function _getForm(Sabai_Application_Context $context)
    {
        $form = $this->_comment->toHTMLQuickForm();
        $form->removeElementsAll();
        return $form;
    }
}