<?php
require_once 'Plugg/FormController.php';

class Plugg_Xigg_Main_Node_DeleteNodeForm extends Plugg_FormController
{
    private $_node;
        
    protected function _init(Sabai_Application_Context $context)
    {
        $this->_confirmable = false;
        
        if ((!$this->_node = $this->_parent->getNodeById($context, 'node_id')) ||
            !$this->_node->isReadable($context->user)
        ) {
            return false;
        }
        if ($this->_node->isPublished()) {
            if (!$context->user->hasPermission('xigg delete any published')) {
                if (!$this->_node->isOwnedBy($context->user) || !$context->user->hasPermission('xigg delete own published')) {
                    $context->response->setError($context->plugin->_('Permission denied'), array('path' => '/' . $this->_node->getId()));
                    return false;
                }
            }
        } else {
            if (!$context->user->hasPermission('xigg delete any unpublished')) {
                if (!$this->_node->isOwnedBy($context->user) || !$context->user->hasPermission('xigg delete own unpublished')) {
                    $context->response->setError($context->plugin->_('Permission denied'), array('path' => '/' . $this->_node->getId()));
                    return false;
                }
            }
        }
        
        return true;
    }
    
    protected function _confirmForm(Sabai_Application_Context $context, Sabai_HTMLQuickForm $form)
    {
        $this->_node->applyForm($form);
        $this->_node->assignUser($context->user);
    }
    
    protected function _submitForm(Sabai_Application_Context $context, Sabai_HTMLQuickForm $form)
    {
        $this->_node->markRemoved();
        if ($this->_node->commit()) {
            $context->response->setSuccess($context->plugin->_('News article deleted successfully'));
            $this->pluginManager->dispatch('XiggDeleteNodeSuccess', array($context, $this->_node));
            return true;
        }
        
        return false;
    }
    
    protected function _viewForm(Sabai_Application_Context $context, Sabai_HTMLQuickForm $form)
    {
        $context->response->setPageInfo($this->_node->title, array('path' => '/' . $this->_node->getId()));
        $context->response->setPageInfo($context->plugin->_('Delete article'));
    }

    protected function _getForm(Sabai_Application_Context $context)
    {
        $form = $this->_node->toHTMLQuickForm();
        $form->removeElementsAll();
        return $form;
    }
}