<?php
class Plugg_Message_User_Main_Identity extends Plugg_RoutingController
{   
    public function __construct()
    {
        parent::__construct('Inbox', 'Plugg_Message_User_Main_Identity_', dirname(__FILE__) . '/Identity');
        $this->addFilter('_isValidUserAccess');
        $this->addControllerFilter('NewMessage', 'isValidOwnerAccess');
    }
    
    protected function _doGetRoutes(Sabai_Application_Context $context)
    {
        return array(
            'new' => array(
                'controller' => 'NewMessage',
            ),
            'submit' => array(
                'controller' => 'Submit',
            ),
            ':message_id' => array(
                'controller' => 'Message',
                'requirements' => array(':message_id' => '\d+')
            ),
        );
    }
    
    protected function _isValidUserAccessBeforeFilter($context)
    {
        // Check permission if trying to access other user's messages
        $identity = $this->getRequestedUserIdentity($context);
        if ($identity->getId() != $context->user->getId()) {
            if (!$context->user->hasPermission('message view any')) {
                $context->response->setError($context->plugin->_('Permission denied'));
                $context->response->send($this->_application);
            }
        }
    }
    
    protected function _isValidUserAccessAfterFilter($context){}
    
    public function isValidOwnerAccessBeforeFilter($context)
    {
        // Make sure only the user profile owner can access
        $identity = $this->getRequestedUserIdentity($context);
        if ($identity->getId() != $context->user->getId()) {
            $context->response->setError($context->plugin->_('Permission denied'));
            $context->response->send($this->_application);
        }
    }
    
    public function isValidOwnerAccessAfterFilter($context){}
}