<?php
class Plugg_Xigg_Admin_Category extends Plugg_RoutingController
{
    public function __construct()
    {
        parent::__construct('List', 'Plugg_Xigg_Admin_Category_', dirname(__FILE__) . '/Category');
        $this->addControllerFilter(array('Update', 'Delete', 'Details'), '_isValidCategoryRequested');
    }

    protected function _doGetRoutes(Sabai_Application_Context $context)
    {
        $context->response->setCurrentTab('category');
        $context->response->setPageInfo($context->plugin->_('Category administration'), array(
            'path' => '/category'
        ));
        return array(
            'list' => array(
                'controller' => 'List'
            ),
            'add' => array(
                'controller' => 'Create'
            ),
            ':category_id/edit' => array(
                'controller' => 'Update',
                'requirements' => array(
                    ':category_id' => '\d+'
                )
            ),
            ':category_id/delete' => array(
                'controller' => 'Delete',
                'requirements' => array(
                    ':category_id' => '\d+'
                )
            ),
            ':category_id' => array(
                'controller' => 'Details',
                'requirements' => array(
                    ':category_id' => '\d+'
                )
            )
        );
    }

    protected function _isValidCategoryRequestedBeforeFilter(Sabai_Application_Context $context)
    {
        $category = $this->_parent->isValidEntityRequested($context, 'Category', 'category_id');
        foreach ($category->parents() as $parent) {
            $context->response->setPageInfo($parent->name, array(
                'path' => '/category/' . $parent->getId()
            ));
        }
        $context->response->setPageInfo($category->name, array(
            'path' => '/category/' . $category->getId()
        ));
    }

    protected function _isValidCategoryRequestedAfterFilter(Sabai_Application_Context $context){}

    public function getRequestedCategory(Sabai_Application_Context $context, $entityIdVar = null, $noCache = false)
    {
        return $this->_parent->getRequestedEntity($context, 'Category', $entityIdVar, $noCache);
    }
}