<?php
require_once 'Plugg/FormController.php';

class Plugg_Xigg_Main_EditTrackbackForm extends Plugg_FormController
{
    private $_trackback;
    
    protected function _init(Sabai_Application_Context $context)
    {
        if (!$trackback_id = $context->request->getAsInt('trackback_id')) {
            return false;
        }
        if (!$this->_trackback = $context->plugin->getModel()->Trackback->fetchById($trackback_id)) {
            return false;
        }
        if (!$context->user->hasPermission('xigg trackback edit')) {
            $context->response->setError($context->plugin->_('Permission denied'), array('path' => '/trackback/' . $trackback_id));
            return false;
        }
        
        return true;
    }
    
    protected function _confirmForm(Sabai_Application_Context $context, Sabai_HTMLQuickForm $form)
    {
        $this->_trackback->applyForm($form);
    }
    
    protected function _submitForm(Sabai_Application_Context $context, Sabai_HTMLQuickForm $form)
    {
        $this->pluginManager->dispatch('XiggSubmitEditTrackbackForm', array($context, $form));
        $this->_trackback->applyForm($form);
        $this->pluginManager->dispatch('XiggEditTrackback', array($context, $this->_trackback));
        if ($this->_trackback->commit()) {
            $context->response->setSuccess($context->plugin->_('Trackback updated successfully'), array(
                'path' => '/' . $this->_trackback->Node->getId(),
                'params' => array('trackback_id' => $this->_trackback->getId()),
                'fragment' => 'trackback' . $this->_trackback->getId()
            ));
            $this->pluginManager->dispatch('XiggEditTrackbackSuccess', array($context, $this->_trackback));
            return true;
        }
        
        return false;
    }
    
    protected function _viewForm(Sabai_Application_Context $context, Sabai_HTMLQuickForm $form)
    {
        $this->pluginManager->dispatch('XiggShowEditTrackbackForm', array($context, $form));
        $context->response->setPageInfo($this->_trackback->Node->title, array(
            'path' => '/' . $this->_trackback->Node->getId()
        ));
        $context->response->setPageInfo($context->plugin->_('Edit trackback'));
    }

    protected function _getForm(Sabai_Application_Context $context)
    {
        return $this->_trackback->toHTMLQuickForm();
    }
}