<?php
require_once 'Plugg/FormController.php';

class Plugg_Xigg_Main_MoveCommentForm extends Plugg_FormController 
{
    private $_comment;
    
    protected function _init(Sabai_Application_Context $context)
    {
        $this->_confirmable = false;
        
        if (!$comment_id = $context->request->getAsInt('comment_id')) {
            return false;
        }
        if (!$this->_comment = $context->plugin->getModel()->Comment->fetchById($comment_id)) {
            return false;
        }
        if (!$context->user->hasPermission('xigg comment move any')) {
            if (!$this->_comment->isOwnedBy($context->user) ||
                !$context->user->hasPermission('xigg comment move own')
            ) {
                $context->response->setError($context->plugin->_('Permission denied'), array(
                    'path' => '/comment/' . $this->_comment->getId()
                ));
                return false;
            }
        }
        
        return true;
    }
    
    protected function _submitForm(Sabai_Application_Context $context, Sabai_HTMLQuickForm $form)
    {
        $this->_comment->setVar('parent', $form->getSubmitValue('move_to'));
        if ($this->_comment->commit()) {
            $context->response->setSuccess($context->plugin->_('Comment moved successfully'), array(
                'path' => '/comment/' . $this->_comment->getId(),
                'fragment' => 'comment' . $this->_comment->getId()
            ));

            return true;
        }
        
        return false;
    }
    
    protected function _viewForm(Sabai_Application_Context $context, Sabai_HTMLQuickForm $form)
    {
        $context->response->setPageInfo($this->_comment->Node->title, array(
            'path' => '/' . $this->_comment->Node->getId()
        ));
        $context->response->setPageInfo($context->plugin->_('Move comment'));
    }

    protected function _getForm(Sabai_Application_Context $context)
    {
        require_once 'Sabai/HTMLQuickForm.php';
        $form = new Sabai_HTMLQuickForm();
        $form->addElement('text', 'move_to', array($context->plugin->_('New parent comment ID'), $context->plugin->_('Enter the new parent comment ID, or 0 to move the comment to the top level.')), array('size' => 5, 'maxlength' => 10));
        return $form;
    }
}