/*
 * Copyright (C) 2002-2003 chik, hiranaka
 * For license terms, see the file COPYING in this directory.
 */

// MainAddressBookDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "pochy.h"
#include "MainAddressBookDlg.h"
#include "MainAddressBookAddDlg.h"
#include "MainAddressBookEditDlg.h"
#include "Csv.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainAddressBookDlg _CAO


CMainAddressBookDlg::CMainAddressBookDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMainAddressBookDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMainAddressBookDlg)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_INIT

	CPochyApp *app = (CPochyApp*)AfxGetApp();
	m_csv = new CCsv(app->m_app_path+"\\address.csv");
}

CMainAddressBookDlg::~CMainAddressBookDlg()
{
	delete m_csv;
}

void CMainAddressBookDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMainAddressBookDlg)
	DDX_Control(pDX, IDC_MAINFRAME_ADDRESSBOOK_EDIT, m_button_edit);
	DDX_Control(pDX, IDC_MAINFRAME_ADDRESSBOOK_DEL, m_button_del);
	DDX_Control(pDX, IDC_MAINFRAME_ADDRESS_LIST, m_lc);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMainAddressBookDlg, CDialog)
	//{{AFX_MSG_MAP(CMainAddressBookDlg)
	ON_BN_CLICKED(IDC_MAINFRAME_ADDRESSBOOK_DEL, OnDel)
	ON_BN_CLICKED(IDC_MAINFRAME_ADDRESSBOOK_ADD, OnAdd)
	ON_BN_CLICKED(IDC_MAINFRAME_ADDRESSBOOK_EDIT, OnEdit)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_MAINFRAME_ADDRESS_LIST, OnItemchanged)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainAddressBookDlg bZ[W nh

BOOL CMainAddressBookDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	CPochyApp *app = (CPochyApp*)AfxGetApp();

	this->m_button_del.EnableWindow(FALSE);
	this->m_button_edit.EnableWindow(FALSE);

	int n, i;
	int column_width[] = { 100, 200, 170 };
	char* column[] = { "O", "[AhX", "l" };
	LV_COLUMN lvc;
	lvc.mask = LVCF_FMT|LVCF_TEXT|LVCF_WIDTH|LVCF_SUBITEM;
	lvc.fmt = LVCFMT_LEFT;
	for(n=0; n<3; n++){
		lvc.pszText = column[n];
		lvc.cx = column_width[n];
		m_lc.InsertColumn(n, &lvc);
	}
	m_lc.SetExtendedStyle(LVS_EX_FULLROWSELECT);
	m_lc.ModifyStyle(0, LVS_SHOWSELALWAYS);

	int max1 = m_csv->GetRowSize();
	int max2;
	for(n=0; n<max1; n++){
		m_lc.InsertItem(n, m_csv->GetValue(n, 0));
		m_lc.SetItemData(n, 0);
		
		max2 = m_csv->GetColumnSize(n);
		for(i=1; i<max2; i++){
			if(i > 2) break;
			m_lc.SetItemText(n, i, m_csv->GetValue(n, i));
		}
	}

	return FALSE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CMainAddressBookDlg::OnDel() 
{
	CString address;
	CString name;
	CString buf;
	int item;
	int i;

	POSITION pos = m_lc.GetFirstSelectedItemPosition();
	while(pos){
		item = m_lc.GetNextSelectedItem(pos);
		m_lc.SetItemData(item, 1);
	}
	for(i=m_lc.GetItemCount()-1; i>=0; i--){
		if(m_lc.GetItemData(i) == 1){
			m_lc.DeleteItem(i);
			m_csv->RemoveRow(i);
		}
	}
}

void CMainAddressBookDlg::OnOK() 
{
	CPochyApp *app = (CPochyApp*)AfxGetApp();

/*	CString data;
	CCsv csv(NULL);
	csv.RemoveAll();
	CStringArray row;
	row.RemoveAll();
	for(int i=0; i<m_lc.GetItemCount(); i++){
		for(int j=0; j<3; j++){
			row.Add(m_lc.GetItemText(i, j));
		}
		csv.AddRow(&row);
		row.RemoveAll();
	}
	csv.Save(app->m_app_path+"\\address.csv");*/
	m_csv->Save(app->m_app_path+"\\address.csv");

	CDialog::OnOK();
}

void CMainAddressBookDlg::OnAdd() 
{
	CMainAddressBookAddDlg ad;
	ad.DoModal();
}

void CMainAddressBookDlg::OnEdit() 
{
	CMainAddressBookEditDlg ad;
	ad.DoModal();
}

void CMainAddressBookDlg::OnItemchanged(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	if(0 < this->m_lc.GetSelectedCount()){
		if(!this->m_button_del.IsWindowEnabled()){
			this->m_button_del.EnableWindow();
		}
		if(!this->m_button_edit.IsWindowEnabled()){
			this->m_button_edit.EnableWindow();
		}
	}else{
		this->m_button_del.EnableWindow(FALSE);
		this->m_button_edit.EnableWindow(FALSE);
	}
	*pResult = 0;
}
