/*
 * Copyright (C) 2002-2003 chik, hiranaka
 * For license terms, see the file COPYING in this directory.
 */

#include "stdafx.h"
#include "Pochy.h"
#include "MainFrm.h"
#include "fetchmail.h"
#include "Filter.h"
#include "PassPhraseDlg.h"
#include "lib.h"
#include "AccountView.h"
#include "mmsystem.h"
#include "direct.h"			// _mkdir


UINT FetchMail(LPVOID pParam)
{
	CPochyApp *app = (CPochyApp *)AfxGetApp();
	CMainFrame *mf = (CMainFrame *)app->m_pMainWnd;
	CSummaryView *sv = mf->m_pListV;
	CAccountView *av = mf->m_pAcntV;
	CHeaderInfo hi;
	CPop pop;
	CStringArray uidl_array;
	CStringArray mail;
	CString account = (char *)pParam;
	CString user;
	CString pass;
	CString addr;
	CString port;
	CString buf;
	CString uid;
	CString last_uid;
	CString message;
	CString tmp;
	CString log_path = app->m_app_path+"\\pop_debug_log.txt";
	CString log_buf;
	int how_many_mail	= 0;
	int mail_size		= 0;
	int size			= 0;
	int get_size		= 0;
	int whole_size		= 0;
	int start			= 1;
	int i, j;
	int delete_mail;
	BOOL fetched = FALSE;
	CUIntArray ia;
	int cnt;
	FILE *file;
	int point;
	int max;
	CString temp;
	CArray<UIDL_STRUCT,UIDL_STRUCT> mailList;

	// wheather or not log
	int log = app->GetProfileInt("Log", "Pop", 0);

	// set fetch status
	av->SetFetchStatus(account, TRUE);

	// invalidate mainframe button
	mf->UpdateButton1(FALSE, account);

	// prepare for filter
	CFilter filter(app->m_app_path+"\\"+account);

	// path to account.ini
	CString path = app->m_app_path+"\\"+account+"\\account.ini";

	// decide whether or not deleting mail.
	delete_mail = GetPrivateProfileInt("pop", "delete_mail", 0, path);

	// start tasktray animation
	mf->StartTaskTrayAnimation();

	try{
		// get user name from ini file.
		GetPrivateProfileString("pop", "user", "", user.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
		user.ReleaseBuffer();

		// get password from ini file.
		GetPrivateProfileString("pop", "pass", "", pass.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
		pass.ReleaseBuffer();

		CString isSecreted;
		GetPrivateProfileString("secreted", "pass_secreted", "", isSecreted.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
		isSecreted.ReleaseBuffer();
		//if pass_secreted equals "yes" then pass decode.
		if(!isSecreted.IsEmpty()) {	
			if(isSecreted.Compare("yes") == 0) {
				pass = g_simple_decode(pass);
			}
		}

		if(pass.IsEmpty() && !mf->m_pAcntV->GetPopPass(account).IsEmpty())
			pass = mf->m_pAcntV->GetPopPass(account);
		else if(pass.IsEmpty() && mf->m_pAcntV->GetPopPass(account).IsEmpty()){
			// if getting no password from ini file, then show dialog for input password.
			CPassPhraseDlg passDlg;
			if(IDOK == passDlg.DoModal()){
				pass = passDlg.GetPass();
				mf->m_pAcntV->SetPopPass(account, pass);
			}else{
				buf.Empty();
				throw buf;
			}
		}

		// getting pop server address from ini file.
		GetPrivateProfileString("pop", "server_addr", "", addr.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
		addr.ReleaseBuffer();
		// getting pop port num from ini file.
		GetPrivateProfileString("pop", "port", "", port.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
		port.ReleaseBuffer();

		// start session
		if(log) g_log("start pop session\r\n", log_path);
		av->SetStatusBarText("start session", account);
		if(!pop.StartSession(addr, port, buf)){
			throw buf;
		}
		if(log) g_log(buf, log_path);
		av->SetStatusBarText(buf, account);

		message = buf; // keep return message for apop
		if(GetPrivateProfileInt("pop", "apop", 0, path)){
			// if using apop, below is done.
			if(log) g_log("apop\r\n", log_path);
			av->SetStatusBarText("apop", account);
			if(!pop.Apop(user, pass, message, buf)){
				throw buf;
			}
			if(log) g_log(buf, log_path);
			av->SetStatusBarText(buf, account);
		}else{
			// below is normal authentification using user and pass command.
			// user
			if(log) g_log("user\r\n", log_path);
			av->SetStatusBarText("user", account);
			if(!pop.User(user, buf)){
				throw buf;
			}
			if(log) g_log(buf, log_path);
			av->SetStatusBarText(buf, account);
			// pass
			if(log) g_log("pass\r\n", log_path);
			av->SetStatusBarText("pass", account);
			if(!pop.Pass(pass, buf)){
				pass.Empty();
				mf->m_pAcntV->SetPopPass(account, pass);
				throw buf;
			}
			if(log) g_log(buf, log_path);
			av->SetStatusBarText(buf, account);
		}

		// stat
		if(log) g_log("stat\r\n", log_path);
		av->SetStatusBarText("stat", account);
		if(!pop.Stat(how_many_mail, whole_size, buf)){
			throw buf;
		}
		if(log) g_log(buf, log_path);
		av->SetStatusBarText(buf, account);

		// get uid list
		if(log) g_log("uidl\r\n", log_path);
		if(!pop.GetUidl(uidl_array, buf)){
			throw buf;
		}

		max = uidl_array.GetSize();

		//M@iuidlmFjύX̂
		GetPrivateProfileString("pop", "last_uid", "", last_uid.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
		if(last_uid.GetLength()!=0){
			if(!g_is_there(app->m_app_path + "\\" + account + "\\uidl")){		
				file = fopen(app->m_app_path + "\\" + account + "\\uidl","wt");
				// uidlłƂėXg̉Ԗڂlast_uid邩mF				
				for(i=0; i<max; i++){
					tmp = uidl_array.GetAt(i);
					if (tmp.Find(last_uid) == -1){
						point = 0;
						point = tmp.Find(" ",1); //The right side is acquired at the blank. 
						if (point==0){
							temp = tmp;	
						}else{
							temp=tmp.Mid(point+1);		
						}
						fputs(temp + "\n",file);	
					} else {
						break;
					}
				}
				fclose(file);
			}
		}

		if(log) g_log(buf, log_path);
		if (!UidCompare(account,uidl_array,mailList,delete_mail,pop,buf)){
			throw buf;
		}

//2005/04/13 Mod mooogV End
		// below is loop for getting mail
//2005/04/13 Mod mooogV Start
//		for(i=start; i<=how_many_mail; i++){
		for(cnt=0;cnt<mailList.GetSize();cnt++){
			i=mailList.GetAt(cnt).mail_no;
//2005/04/13 Mod mooogV End
			fetched = TRUE;
			// getting size of mail
			if(!pop.GetMailSize(i, mail_size, buf)){
				throw buf;
			}
			// retr
			if(log){
				log_buf.Format("retr %d\r\n", i);
				g_log(log_buf, log_path);
			}
			if(!pop.Retr(i, buf)){
				throw buf;
			}
			if(log) g_log(buf, log_path);
			// retrieving mail
			get_size = 0;
			BOOL is_header = TRUE;
			while(1){
				if((size = pop.ReadLine(buf)) == -1){
					buf = "while retrieving mail, accident is occured !";
					throw buf;
				}
				get_size += size-1; // "size-1" mean pop server's stat command return size that not include "\r"
				buf.TrimRight("\n");
				buf.TrimRight("\r");
				buf += "\r\n";
				if(buf == ".\r\n") break; // if".\r\n" show up, break loop.
				if(buf == "\r\n" && is_header){
					hi.DoIt(mail);
					// display some info about current fetching mail on statusbar.
					message.Format("%d/%d %d/%d %s", i, how_many_mail, get_size, mail_size, hi.GetSubject());
					av->SetStatusBarText(message, account);
					is_header = FALSE;
					mail.Add(buf);
					continue;
				}
				if(buf.Find(".") == 0){
					buf.Delete(0, 1);
				}
				mail.Add(buf);
				message.Format("%d/%d %d/%d %s", i, how_many_mail, get_size, mail_size, hi.GetSubject());
				av->SetStatusBarText(message, account);
			}

			// get progressbar progress
			av->SetStatusBarProgress(i-start+1, how_many_mail-start+1, account);

			// filter and save mail
			message += " ------>";
			CString folder_path;
			CString mail_path;
			CStringArray folder_path_array;
			filter.GetPath(hi, folder_path_array);
			for(j=0; j<folder_path_array.GetSize(); j++){

				folder_path = folder_path_array[j];

				// call prefilter plugin
				if (app->m_pluginManager.HasPreFilterPlugin())
				{
					// tB^[Ɏg RawMail  Plugin ɓn
					// pXobt@[ɃtB^[tH_[i[Ă
					CString rawMail;
					g_cstringarray2cstring(mail, rawMail);
					TCHAR tcMailSavePathBuffer[POCHY_PLUGIN_PATH_BUFFER_SIZE];
					::ZeroMemory(tcMailSavePathBuffer, POCHY_PLUGIN_PATH_BUFFER_SIZE);
					::lstrcpyn(tcMailSavePathBuffer, folder_path, folder_path.GetLength() + 1);
					app->m_pluginManager.OnPreFilter(rawMail, tcMailSavePathBuffer);
					tcMailSavePathBuffer[POCHY_PLUGIN_PATH_BUFFER_SIZE - 1] = _T('\0');
					mail_path = tcMailSavePathBuffer;
				}

				// display path where mail is saved
				if(folder_path.IsEmpty()){
					folder_path = app->m_app_path+"\\"+account+"\\inbox";
					message += " \\inbox";
					av->SetStatusBarText(message, account);
				}else{
					message += " "+folder_path.Mid(folder_path.ReverseFind('\\'));
					av->SetStatusBarText(message, account);
				}

				// if foler not exist, create
				if(!g_is_there(folder_path)){
					_mkdir(folder_path);
					g_file_create(folder_path + "\\list");
				}

				// save mail
				sv->SaveMail(folder_path, mail, SMRY_STATUS_NEW, SMRY_COLUMN_FROM, mail_path/*for later referece*/);
//				sv->MakeShortCut(mailFilename, "c:\\cygwin\\home\\sabory\\mail\\hotmail\\inbox", SMRY_STATUS_NONE, SMRY_COLUMN_FROM);
				
				AddUidToUidl(account,mailList.GetAt(cnt).uid);
				// call postfilter plugin
				app->m_pluginManager.OnPostFilter(mail_path);
			}
			message.Empty();
			mail.RemoveAll();

			// save last uid to ini
			if(!delete_mail){
				if(log){
					log_buf.Format("uid %d\r\n", i);
					g_log(log_buf, log_path);
				}
				if(!pop.GetUid(i, uid, buf)){
					throw buf;
				}
				if(log) g_log(buf, log_path);
				WritePrivateProfileString("pop", "last_uid", "", path); //0.3.0g܂
			}else{
				// delete mail
				if(log){
					log_buf.Format("dele %d\r\n", i);
					g_log(log_buf, log_path);
				}
				if(!pop.Dele(i, buf)){
					throw buf;
				}
				if(log) g_log(buf, log_path);
			}
		}

		// set progressbar zero
		av->SetStatusBarProgress(0, 100, account);
		// quit
		if(log) g_log("normal quit\r\n", log_path);
		av->SetStatusBarText("quit", account);
		pop.Quit(buf);
		if(log) g_log(buf, log_path);
		av->SetStatusBarText(buf, account);
		// close socket
		pop.EndSession();
 
		// skin.ini for playing sound
 		CString successEffectSoundFilePath;
 		if(app->m_skin.getSuccessEffectSound() == "") {
 			successEffectSoundFilePath = app->m_app_path+"\\success.wav";
 		} else {
 			successEffectSoundFilePath = app->m_skin.getSkinIniPath() + "\\" + app->m_skin.getSuccessEffectSound();
 		}
 		if(fetched && g_is_there(successEffectSoundFilePath))
 			PlaySound(successEffectSoundFilePath, NULL, SND_FILENAME);
	}
	catch(CString &errorstr){
		// quit
		if(log) g_log(errorstr, log_path);
		if(log) g_log("error quit\r\n", log_path);
		pop.Quit(buf);
		if(log) g_log(buf, log_path);
		// close socket
		pop.EndSession();
		if(!errorstr.IsEmpty()){
			mf->MessageBox(errorstr, account+" - pop error");
		}
		mf->UpdateButton1(TRUE, account);
		av->SetStatusBarProgress(0, 100, account);
		av->SetStatusBarText("", account);
		av->SetFetchStatus(account, FALSE);
		mf->StopTaskTrayAnimation();
		return FALSE;
	}

	mf->UpdateButton1(TRUE, account); 	// validate mainframe button
	av->SetStatusBarText("", account);
	av->SetStatusBarProgress(0, 100, account);
	av->SetFetchStatus(account, FALSE);
	mf->StopTaskTrayAnimation();

	// call plugin
	app->m_pluginManager.OnFetchFinished(account, how_many_mail-start+1);
//2005/04/13 Add mooogV Start
	if (mailList.GetSize() > 0){
		int newmail_msgbox = GetPrivateProfileInt("pop", "newmail_msgbox", 0,path);
		if (newmail_msgbox > 0){
			AfxMessageBox("AJEgF" + account + "\nVbZ[W܂B",MB_ICONINFORMATION);
		}
	}
//2005/04/13 Add mooogV End
	return TRUE;
}

BOOL UidCompare(CString account,CStringArray &sa,CArray<UIDL_STRUCT,UIDL_STRUCT> &mailList,
																int delete_mail,CPop &pop,CString &ret)
{
	FILE *file;
	char buff[128];
	CStringArray uidl;
	int i;
	int j,max;
	CString left,temp,wrk;
	CString path;
	int point;
	
	path = GetUidlPath(account);

	//uidl file To memory
	file=fopen(path,"r");	
	if (file!=NULL){
		ret = fgets( buff, 0L, file );
		while ((fgets(buff, sizeof(buff)-1, file)) != NULL) {
			uidl.Add(buff);
		}
		fclose(file);
	}	
	
	//target uid to ia(CUIntArray)
	mailList.RemoveAll();

	//ia.RemoveAll();
	max = uidl.GetSize();
	for(i=0;i<sa.GetSize();++i){
		wrk = sa.GetAt(i);
		point = 0;
		point = wrk.Find(" ",1); //The right side is acquired at the blank. 
		if (point==0){
			left = wrk;	
		}else{
			left=wrk.Mid(point+1);		
		}
		for(j=0;j<max;++j){
			temp =uidl.GetAt(j);
			if (strcmp(left,temp.Left(temp.GetLength()-1))==0){
				break;
			}
		}
		if (j==max){
			UIDL_STRUCT mail;
			mail.mail_no=i+1;
			mail.uid=left;
			mailList.Add(mail);
		}
	}
	//no mail is retrn true
	if (mailList.GetSize()==0) return TRUE;
	
	if (!delete_mail) return TRUE;

	// rŁA[폜悤ɂꍇȂ
	// ܂ł̃[폜
	for (i=0;i<sa.GetSize();i++){
		for(j=0;j<mailList.GetSize();j++){				
			if ((i+1)==mailList.GetAt(j).mail_no) {
				break;
			}
		}
		if (j==mailList.GetSize()) {
			if (!pop.Dele(i+1,ret)) {
				return FALSE;
			}
		}

	}
	
	return TRUE;
}

// uidļق߽擾
CString GetUidlPath(CString account)
{
	CPochyApp *app = (CPochyApp *)AfxGetApp();
	CString path;
	path = app->m_app_path + "\\" + account + "\\uidl";
	
	return path;
}

//uiduidļقɒǉ
void AddUidToUidl(CString account,CString uid)
{
	FILE *file;
	CString path;
	
	path = GetUidlPath(account);
	
	file = fopen(path,"a");
	fputs(uid + "\n",file);
	fclose(file);
}
