/*
 * Copyright (C) 2002-2003 chik, hiranaka
 * 2003-10-26 Some modification is done for task tray icon and the animation by minamina.
 * 2003-11-05 Some modification is done for rearrangeable summary column by minamina.
 * For license terms, see the file COPYING in this directory.
 */

// MainFrm.cpp : CMainFrame NX̓̒`s܂B

#include "stdafx.h"
#include "Pochy.h"
#include "MainFrm.h"
#include "FolderView.h"
#include "AccountView.h"
#include "TextView.h"
#include "HeaderView.h"
#include "Sock.h"
#include "CodeConvert.h"
#include "FetchMail.h"
#include "Retrieve.h"
#include "SettingAccountDlg.h"
#include "lib.h"
#include "MimeEncode.h"
#include "Gpg.h"
#include "PassPhraseDlg.h"
#include "direct.h"			// _mkdir
#include "GpgDlg.h"
#include "MainAddressBookDlg.h"
#include "SettingGeneralDlg.h"
#include "Template.h"
#include "MainAddressCheckDlg.h"
//2005/05/01 Add mooogV Start
#include "Filter.h"
//2005/05/01 Add mooogV End
#include "quoted-printable.h"
#include "base64.h"

#pragma warning (push, 1)
#include <algorithm>
#pragma warning (pop)

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_MESSAGE(WM_USER_NOTIFYICON, OnNotifyIcon)
	ON_WM_CREATE()
	ON_COMMAND(ID_FETCH_MAIL, OnFetchmail)
//2005/06/10 Add moogV Start
	ON_COMMAND(ID_ALLFETCH_MAIL, OnAllFetchmail)
//2005/06/10 Add moogV End
	ON_UPDATE_COMMAND_UI(ID_FETCH_MAIL, OnUpdateFetchmail)
	ON_UPDATE_COMMAND_UI(ID_RETRIEVE, OnUpdateRetrieve)
	ON_COMMAND(ID_TRANSFER, OnTransfer)
	ON_WM_SIZE()
	ON_UPDATE_COMMAND_UI(ID_REPLY, OnUpdateReply)
	ON_COMMAND(ID_GPG_DEC, OnGpgDec)
	ON_COMMAND(ID_GPG, OnGpg)
	ON_UPDATE_COMMAND_UI(ID_GPG_DEC, OnUpdateGpgDec)
	ON_UPDATE_COMMAND_UI(ID_GPG, OnUpdateGpg)
	ON_COMMAND(ID_RETRIEVE, OnRetrieve)
	ON_COMMAND(ID_RETRIEVE_NEXT, OnRetrieveNext)
	ON_WM_DESTROY()
	ON_COMMAND(ID_SETTING, OnSetting)
	ON_COMMAND(ID_REPLY, OnReply)
	ON_COMMAND(ID_DRAFT, OnDraft)
	ON_COMMAND(ID_ADDRESS, OnAddress)
	ON_UPDATE_COMMAND_UI(ID_TRANSFER, OnUpdateTransfer)
	ON_COMMAND(ID_INFO, OnInfo)
	ON_UPDATE_COMMAND_UI(ID_INFO, OnUpdateInfo)
	ON_UPDATE_COMMAND_UI(ID_SETTING, OnUpdateSetting)
	ON_NOTIFY(TBN_DROPDOWN, AFX_IDW_TOOLBAR, OnToolbarDropDown)
	ON_WM_TIMER()
	ON_COMMAND(ID_SETTING_GENERAL, OnSettingGeneral)
	ON_COMMAND(ID_SETTING_ACCOUNT, OnSettingAccount)
	ON_COMMAND(ID_DISPLAY_HEADER, OnDisplayHeader)
	ON_COMMAND(ID_DISPLAY_RAW_MAIL, OnDisplayRawMail)
	ON_COMMAND(ID_SETTING_FILTER, OnSettingFilter)
	ON_COMMAND(ID_SETTING_NEW_ACCOUNT, OnSettingNewAccount)
	ON_COMMAND(ID_TRANSFER_QUOTATION, OnTransferQuotation)
	ON_COMMAND(ID_GPG_MAIN_KEY_MANAGEMENT, OnGpgKeyManagement)
	ON_COMMAND(ID_SWITCH_VIEW, OnSwitchView)
	ON_COMMAND(ID_SCROLL_MAIL, OnScrollMail)
	ON_COMMAND(ID_SHOW_PLUGIN_LIST, OnShowPluginList)
	ON_WM_CLOSE()
	ON_WM_COPYDATA()
	ON_WM_SYSCOMMAND()
	ON_WM_ACTIVATE()
	ON_UPDATE_COMMAND_UI(ID_GPG_MAIN_KEY_MANAGEMENT, OnUpdateGpg)
	ON_COMMAND(ID_DRAFT_DEFAULT, OnDraft)
	ON_UPDATE_COMMAND_UI(ID_DISPLAY_HEADER, OnUpdateInfo)
	ON_UPDATE_COMMAND_UI(ID_DISPLAY_RAW_MAIL, OnUpdateInfo)
	ON_COMMAND(ID_REPLY_DEFAULT, OnReply)
//2005/05/01 Add moogV Start
	ON_COMMAND(ID_SETTING_REFILTER, OnSettingReFilter)
//2005/05/01 Add moogV End
	//}}AFX_MSG_MAP
	ON_COMMAND(WM_PROGCREATE, OnProgCreate)
END_MESSAGE_MAP()

static UINT indicators[] = { ID_INDICATOR_TEXT, ID_INDICATOR_PROGRESS, ID_INDICATOR_FOLDER, };
/*
{
	ID_SEPARATOR,           // Xe[^X C CWP[^
	ID_INDICATOR_KANA,
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};*/

/////////////////////////////////////////////////////////////////////////////
// CMainFrame NX̍\z/

CMainFrame::CMainFrame() : m_hRichEdit20(NULL)
{
	m_flag = FALSE;
	m_multipart_hide = FALSE;
	m_button_reply = FALSE;
	m_button_transfer = FALSE;
	m_button_gpg_dec = FALSE;
	m_button_info = FALSE;
	m_tasktray_animation_num = 0;
	m_hRichEdit20 = ::LoadLibraryA("RichEd20.dll");
	// for dynamic drop down menu
	this->m_bAutoMenuEnable = FALSE;
}

CMainFrame::~CMainFrame()
{
	if (m_hRichEdit20 != NULL)
	{
		::FreeLibrary(m_hRichEdit20);
		m_hRichEdit20 = NULL;
	}
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;		// 쐬Ɏs

/*	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME)){
		TRACE0("Failed to create toolbar\n");
		return -1;      // 쐬Ɏs
	}*/

	// toolbar̍쐬
	if(!CreateToolbar())
		return -1;

	// statusbar̍쐬
	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT))){
		TRACE0("Failed to create status bar\n");
		return -1;      // 쐬Ɏs
	}
	if (m_wndStatusBar.GetSafeHwnd()){
		m_wndStatusBar.SetPaneInfo(0, ID_INDICATOR_TEXT, SBPS_STRETCH /*| SBPS_POPOUT | SBPS_NOBORDERS*/, NULL);
		m_wndStatusBar.SetPaneInfo(1, ID_INDICATOR_PROGRESS, NULL, 200);
		m_wndStatusBar.SetPaneInfo(2, ID_INDICATOR_FOLDER, NULL, 150);
	}

	// init@CÕEBhEʒu擾
	CPochyApp *app = (CPochyApp *)AfxGetApp();
	CRect rc;

	// ÕEBhEʒu𕜌
	rc.left = app->GetProfileInt("wndPlace", "Left", 0);
	rc.top = app->GetProfileInt("wndPlace", "Top", 0);
	rc.right = app->GetProfileInt("wndPlace", "Right", 700);
	rc.bottom = app->GetProfileInt("wndPlace", "Bottom", 520);

	RECT rc2;
	if(!::IsRectEmpty(&rc)){
		SystemParametersInfo(SPI_GETWORKAREA, 0, &rc2, 0);
		rc.left = rc.left+rc2.left;
		rc.top = rc.top+rc2.top;
		rc.right = rc.right+rc2.left;
		rc.bottom = rc.bottom+rc2.top;
		MoveWindow(rc);
	}

	// resurrect status of bar
	this->m_wndToolBar.ShowWindow(app->GetProfileInt("ToolBar", "IsVisible", SW_SHOW));
	this->m_wndStatusBar.ShowWindow(app->GetProfileInt("StatusBar", "IsVisible", SW_SHOW));

	// MĂяoiontimersj
	int minute = app->GetProfileInt("AutoFetch", "minute", 0);
	if(minute >= 1){
		SetTimer(1, minute*60000, NULL);
	}

	// ^XNgCACRݒ肷
//	CString strTaskTrayIconFilePath = app->m_app_path + TASKTRAY_ICON_FILENAME;
	// skin.ini
	CPochyApp *pApp =(CPochyApp*)::AfxGetApp();
	CString strTaskTrayIconFilePath;
	if(pApp->m_skin.getTasktrayIcon() == ""){
		strTaskTrayIconFilePath = app->m_app_path + TASKTRAY_ICON_FILENAME;
	}else{
		strTaskTrayIconFilePath = pApp->m_skin.getSkinIniPath() + "\\" + pApp->m_skin.getTasktrayIcon();
	}
	m_notifyIcon.Initialize(app->m_hInstance, GetSafeHwnd(), WM_USER_NOTIFYICON);
	if (!m_notifyIcon.SetIcon(strTaskTrayIconFilePath))
	{
		m_notifyIcon.SetIcon(IDR_MAINFRAME);
	}
	m_notifyIcon.SetTip(AFX_IDS_APP_TITLE);
	int nUseTaskTray = app->GetProfileInt(_T("TaskTray"), _T("UseTaskTray"), 0);
	if (nUseTaskTray == 1)
	{
		m_notifyIcon.Add();
	}
	// ^XNgCAj[Vݒ肷
//	CString strTaskTrayAnimationFilePath = app->m_app_path + TASKTRAY_ANIMATION_FILENAME;
 	// skin.ini
	CString strTaskTrayAnimationFilePath;
	if(pApp->m_skin.getTasktrayAnimeIcon() == ""){
		strTaskTrayAnimationFilePath = app->m_app_path + TASKTRAY_ANIMATION_FILENAME;
	}else{
		strTaskTrayAnimationFilePath = pApp->m_skin.getSkinIniPath() + "\\" + pApp->m_skin.getTasktrayAnimeIcon();
	}
	m_notifyIcon.SetAnimation(strTaskTrayAnimationFilePath, 100, true,
		RGB(255, 255, 255), TASKTRAY_ANIMATION_TIMER_ID);

	// ǐ\ݒǂݍ
	int nShowUnreadCount = app->GetProfileInt(_T("FolderView"), _T("ShowUnreadCount"), 1);
	m_pTreeV->SetShowUnreadCount(nShowUnreadCount == 1);

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
    // EBhENXo^
    // EBhE₷Ȃ邩HOOG
	if (cs.lpszName){
		WNDCLASS wc;
		::GetClassInfo(AfxGetInstanceHandle(), cs.lpszClass, &wc);
		// _T()ň͂ĂȂdebug[hŎsiHj
		wc.lpszClassName = _T("_PochyClass"); // DȖOݒ
		AfxRegisterClass(&wc);
		cs.lpszClass = wc.lpszClassName;
	}
	if(!CFrameWnd::PreCreateWindow(cs))
		return FALSE;
	// TODO: ̈ʒu CREATESTRUCT cs CāAWindow NXX^CCĂB
    cs.style ^= FWS_ADDTOTITLE;
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame NX̐ff

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame bZ[W nh


BOOL CMainFrame::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	CPochyApp *app = (CPochyApp *)AfxGetApp();
	int x, y;

	// create each pane
	m_split_left_right.CreateStatic(this,1,2);
	m_split_multi_others.CreateStatic(&m_split_left_right,2,1,WS_CHILD|WS_VISIBLE,m_split_left_right.IdFromRowCol(0,1));
	m_split_summary_others.CreateStatic(&m_split_multi_others,2,1,WS_CHILD|WS_VISIBLE,m_split_multi_others.IdFromRowCol(0,0));
	m_split_header_text.CreateStatic(&m_split_summary_others,2,1,WS_CHILD|WS_VISIBLE,m_split_summary_others.IdFromRowCol(1,0));
	m_split_account_folder.CreateStatic(&m_split_left_right,2,1,WS_CHILD|WS_VISIBLE,m_split_left_right.IdFromRowCol(0,0));
	m_split_account_folder.CreateView(0,0,RUNTIME_CLASS(CAccountView),CSize(0, 0),pContext);
	m_split_account_folder.CreateView(1,0,RUNTIME_CLASS(CFolderView),CSize(0, 0),pContext);
	m_split_account_folder.NoBorder();
	m_split_account_folder.SetStaticBorder(TRUE);
	m_split_multi_others.CreateView(1,0,RUNTIME_CLASS(CMultiPartView),CSize(0, 0),pContext);
	m_split_summary_others.CreateView(0,0,RUNTIME_CLASS(CSummaryView),CSize(0, 0),pContext);
	m_split_header_text.CreateView(0,0,RUNTIME_CLASS(CHeaderView),CSize(0, 0),pContext);
	m_split_header_text.CreateView(1,0,RUNTIME_CLASS(CTextView),CSize(0, 0),pContext);
	m_split_header_text.NoBorder();

	// save pointer of each pane
	m_pAcntV = (CAccountView*)m_split_account_folder.GetPane(0, 0);
	m_pTreeV = (CFolderView*)m_split_account_folder.GetPane(1, 0);
	m_pListV = (CSummaryView*)m_split_summary_others.GetPane(0, 0);
	m_pHeadV = (CHeaderView*)m_split_header_text.GetPane(0, 0);
	m_pTextV = (CTextView*)m_split_header_text.GetPane(1, 0);
	m_pMultiV = (CMultiPartView*)m_split_multi_others.GetPane(1, 0);

	// adjust each pane size
	x = app->GetProfileInt("SplitWnd", "LeftPaneWidth", 180);
	m_split_left_right.SetColumnInfo(0, x, 10);
	m_split_account_folder.SetRowInfo(0, 20, 10);

	y = app->GetProfileInt("SplitWnd", "SummaryViewHeight", 300);
	m_split_summary_others.SetRowInfo(0, y, 10);

	y = app->GetProfileInt("SplitWnd", "HeaderViewHeight", DEF_HEADER_HEIGHT);
	m_split_header_text.SetRowInfo(0, y, 10);

	// hide each view
	this->HideMultiPartView(TRUE);
	if(!app->GetProfileInt("Customize", "HeaderView", 1)){
		this->HideHeaderView(TRUE);
	}
	if (app->GetProfileInt(_T("Customize"), _T("AccountViewHide"), 0))
	{
		HideAccountView(TRUE);
	}

	m_flag = TRUE;
	return TRUE;
}

void CMainFrame::OnProgCreate()
{
	CRect rect;
	m_wndStatusBar.GetItemRect(1, &rect);
	m_progress.Create(WS_CHILD|WS_VISIBLE|PBS_SMOOTH, rect, &m_wndStatusBar, -1); //PBS_SMOOTH
}

void CMainFrame::SetStatusBarText(int pane, LPCSTR buf)
{
	// cannot use PostMessage, as the panel type is not set correctly
	::SendMessage(m_wndStatusBar, SB_SETTEXT, (WPARAM)pane | 0, (LPARAM)(LPSTR)buf);
}

void CMainFrame::OnFetchmail()
{
	if(!m_pAcntV->IsFetching(m_pAcntV->GetCurrentAccountName()))
	{
		this->m_pAcntV->SetFetchStatus(this->m_pAcntV->GetCurrentAccountName(), TRUE);
		AfxBeginThread(FetchMail, this->m_pAcntV->GetCurrentAccountName());
	}
}

static UINT BeginAllFetchmail(LPVOID pParam)
{
	int i,max;
	int ret;
	CPochyApp *app = (CPochyApp *)AfxGetApp();
	CMainFrame *mf = (CMainFrame *)app->m_pMainWnd;
	
	max = mf->m_pAcntV->m_data.GetSize();	
	for(i=0; i<max; i++){
		CString account = mf->m_pAcntV->m_data[i].account_name;
		ret = GetPrivateProfileInt("pop", "no_all_fetch", 0, app->m_app_path+"\\" + account + "\\account.ini");
		if((!mf->m_pAcntV->IsFetching(account)) && (ret==0)) {
			mf->SetStatusBarText(0,account + "Mł...");
			FetchMail((char *)account.GetBuffer(sizeof(account)));
			mf->SetStatusBarText(0,"");
		}
	}
	return TRUE;
}

void CMainFrame::OnAllFetchmail()
{
	int now_idx;
	
	now_idx=m_pAcntV->GetAccountNum(m_pAcntV->GetCurrentAccountName());
	//AfxBeginThread(FetchMail, this->m_pAcntV->GetCurrentAccountName());
	AfxBeginThread(BeginAllFetchmail,(LPVOID)this);
	m_pAcntV->SelectAccount(now_idx);
}

void CMainFrame::OnUpdateFetchmail(CCmdUI* pCmdUI)
{
	int index = m_pAcntV->GetAccountNum(m_pAcntV->GetCurrentAccountName());
	pCmdUI->Enable(m_pAcntV->m_data[index].button_fetchmail);
}

void CMainFrame::OnUpdateRetrieve(CCmdUI* pCmdUI)
{
	int index = m_pAcntV->GetAccountNum(m_pAcntV->GetCurrentAccountName());
	pCmdUI->Enable(m_pAcntV->m_data[index].button_retrieve);
}

void CMainFrame::OnTransfer()
{
	this->OnTransferQuotation();
}

void CMainFrame::OnSize(UINT nType, int cx, int cy)
{
	CFrameWnd::OnSize(nType, cx, cy);

	if(m_flag)
		ReArrangeSplit();

	CRect rect;
	if(m_wndStatusBar.m_hWnd != NULL)
		m_wndStatusBar.GetItemRect(1, rect);
	if(m_progress.m_hWnd != NULL)
		m_progress.MoveWindow(rect);
}

void CMainFrame::OnUpdateReply(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(this->m_button_reply);
}

void CMainFrame::OnGpgDec()
{
	CGpg gpg;
	CString buf;
	CString header;
	CString body;
	CString tmp;

	// input pass phrase
	CPochyApp* app = (CPochyApp*)AfxGetApp();
	if(app->m_gpg_passphrase.IsEmpty()){
		CPassPhraseDlg pf;
		if(pf.DoModal() == IDOK){
			app->m_gpg_passphrase = pf.GetPass();
		}else{
			return;
		}
	}
	CString pass = app->m_gpg_passphrase;

	// decoding
	buf = gpg.Decode(m_pTextV->GetCurrentPath(), pass);
	if(buf.IsEmpty()){
		app->m_gpg_passphrase.Empty();
		return;
	}

	CStringArray old_header;
	m_pTextV->m_md.m_hi.GetAllUnDecoded(old_header);
	m_pTextV->m_md.m_hi.RemoveFoldingWhiteSpace(&old_header);

	if(m_pTextV->IsPgpMime()){ // in case of pgp/mime
		CMimeDecode md;
		md.DoIt2(buf);
		CStringArray new_header;
		md.m_hi.GetAllUnDecoded(new_header);
		md.m_hi.RemoveFoldingWhiteSpace(&new_header);

		CString content_type;
		CString content_transfer_encoding;
		CString content_disposition;

		// rearrange for connonical mime in pgp/mime
		int i;
		int max = new_header.GetSize();
		for(i=0; i<max; i++){
			tmp = new_header.GetAt(i);
			tmp.MakeLower();
			if(0 == tmp.Find("content-type"))
				content_type = new_header.GetAt(i);
			if(0 == tmp.Find("content-transfer-encoding"))
				content_transfer_encoding = new_header.GetAt(i);
			if(0 == tmp.Find("content-disposition"))
				content_disposition = new_header.GetAt(i);
		}

		max = old_header.GetSize();
		for(i=0; i<max; i++){
			tmp = old_header.GetAt(i);
			tmp.MakeLower();
			if(0 == tmp.Find("content-type")){
				if(content_type.IsEmpty())
					old_header.SetAt(i, "Content-Type: text/plain; charset=ISO-2022-JP\r\n");
				else
					old_header.SetAt(i, content_type);
			}
		}

		for(i=0; i<max; i++){
			tmp = old_header.GetAt(i);
			tmp.MakeLower();
			if(0 == tmp.Find("content-transfer-encoding")){
				if(content_transfer_encoding.IsEmpty())
					old_header.SetAt(i, "Content-Transfer-Encoding: 7bit\r\n");
				else
					old_header.SetAt(i, content_transfer_encoding);
			}
		}

		for(i=0; i<max; i++){
			tmp = old_header.GetAt(i);
			tmp.MakeLower();
			if(0 == tmp.Find("content-disposition"))
				if(content_disposition.IsEmpty())
					old_header.RemoveAt(i);
				else
					old_header.SetAt(i, content_disposition);
		}

		body = buf.Mid(buf.Find("\r\n\r\n")+4);
	}else{
		body = buf; // in case of none pgp/mime, may be encoded word is directly put into mail body
	}
	g_cstringarray2cstring(old_header, header);
	header.TrimRight();
	header += "\r\n";
	m_pTextV->Update2(header+"\r\n"+body);
	this->UpdateButton2(TRUE);
}

void CMainFrame::OnUpdateGpgDec(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(this->m_button_gpg_dec);
}

void CMainFrame::OnUpdateGpg(CCmdUI* pCmdUI)
{
	CPochyApp *app = (CPochyApp*)AfxGetApp();
	pCmdUI->Enable(app->m_gpg_enable);
}

void CMainFrame::OnRetrieve()
{
	CRetrieve Retrieve;
	CPochyApp *app = (CPochyApp *)AfxGetApp();
	CString path;

	path = app->m_app_path;
	path += m_pTreeV->GetItemPath(m_pTreeV->GetTreeCtrl().GetSelectedItem());
	Retrieve.GoRetrieve(path, FIRST);
}

void CMainFrame::OnRetrieveNext()
{
	CRetrieve Retrieve;
	Retrieve.GoRetrieve(m_pListV->m_path, CONTINUE);
}

void CMainFrame::OnDestroy()
{
	CPochyApp *app = (CPochyApp *)AfxGetApp();
	WINDOWPLACEMENT wndPlace;
	CString num;

	// getting placement of main window
	GetWindowPlacement(&wndPlace);

	// saving placemant of main window into ini file 
	app->WriteProfileInt("WndPlace", "Left", wndPlace.rcNormalPosition.left);
	app->WriteProfileInt("WndPlace", "Top", wndPlace.rcNormalPosition.top);
	app->WriteProfileInt("WndPlace", "Right", wndPlace.rcNormalPosition.right);
	app->WriteProfileInt("WndPlace", "Bottom", wndPlace.rcNormalPosition.bottom);

	// saving status of window into ini file (maximize, iconize, others)
	if(this->IsZoomed()) 
		app->WriteProfileInt("WndPlace", "Zoom", 1);
	else if(this->IsIconic()) 
		app->WriteProfileInt("WndPlace", "Zoom", 1);
	else
		app->WriteProfileInt("WndPlace", "Zoom", 0);

	// saving width of column in summaryview into ini file
	for(int i = 0; i < 5; i++){
		num.Format("%d", i);
		app->WriteProfileInt("SummaryViewColumn", num, m_pListV->GetListCtrl().GetColumnWidth(i));
	}

	// saving order of column in summaryview into ini file
	m_pListV->WriteIniColumnOrder();

	// saving width of column in multipartview into ini file
	for(i = 0; i < 3; i++){
		num.Format("%d", i);
		app->WriteProfileInt("MultiPartViewColumn", num, m_pMultiV->GetListCtrl().GetColumnWidth(i));
	}

	// saving size of each splited pane into ini file
	int current;
	int max;
	m_split_left_right.GetColumnInfo(0, current, max);
	app->WriteProfileInt("SplitWnd", "LeftPaneWidth", current);
	m_split_summary_others.GetRowInfo(0, current, max);
	app->WriteProfileInt("SplitWnd", "SummaryViewHeight", current);
	if(app->GetProfileInt("Customize", "HeaderView", 1)){
		m_split_header_text.GetRowInfo(0, current, max);
		app->WriteProfileInt("SplitWnd", "HeaderViewHeight", current);
	}
/*
typedef struct tagLOGFONT { // lf  
   LONG lfHeight; 
   LONG lfWidth; 
   LONG lfEscapement; 
   LONG lfOrientation; 
   LONG lfWeight; 
   BYTE lfItalic; 
   BYTE lfUnderline; 
   BYTE lfStrikeOut; 
   BYTE lfCharSet; 
   BYTE lfOutPrecision; 
   BYTE lfClipPrecision; 
   BYTE lfQuality; 
   BYTE lfPitchAndFamily; 
   TCHAR lfFaceName[LF_FACESIZE]; 
} LOGFONT;
*/

	for(i=0; i<app->m_draft_array.GetSize(); i++){
		app->m_draft_array[i]->ShowWindow(SW_SHOW);
		if(app->m_draft_array[i]->IsIconic())
			app->m_draft_array[i]->ShowWindow(SW_RESTORE);
		app->m_draft_array[i]->SetForegroundWindow();
		app->m_draft_array[i]->SaveToDraft(TRUE);
		app->m_draft_array[i]->DestroyWindow();
	}

	// clear temporary folder
	if(g_is_there(app->m_app_path+"\\temp")){
		g_empty_directory(app->m_app_path+"\\temp");
	}
	

	CFrameWnd::OnDestroy();
}

void CMainFrame::OnSetting()
{
	this->OnSettingAccount();
}

void CMainFrame::OnReply() 
{
	if(this->m_button_reply==FALSE)
	{
		return;
	}

	CPochyApp *app = (CPochyApp *)AfxGetApp();
	CStringArray array_to;
	CStringArray array_cc;
	CStringArray array_tmp;
	CTemplate tmpl;
	CString body_tmpl;
	CMainAddressCheckDlg ad;
	CString signature;
	CString tmpl_body;

	// initialyze
	app->m_me.Initialize();

	g_split_address(m_pTextV->GetCurrentTo(), array_tmp, FALSE, FALSE);

	if(!m_pTextV->GetCurrentCc().IsEmpty() || array_tmp.GetSize() > 1){
		// setting cc
		if(!m_pTextV->GetCurrentCc().IsEmpty()){
			g_split_address(m_pTextV->GetCurrentCc(), array_cc, FALSE, FALSE);
		}
		if(array_tmp.GetSize() > 1){
			array_cc.Append(array_tmp);
		}
		if(array_cc.GetSize() > 0){
			ad.SetCc(array_cc);
		}

		// setting to, if reply-to exist, use reply-to address as to address
		if(m_pTextV->GetCurrentReplyTo().IsEmpty()){
			g_split_address(m_pTextV->GetCurrentFrom(), array_to, FALSE, FALSE);
			ad.SetTo(array_to);
		}else{
			g_split_address(m_pTextV->GetCurrentReplyTo(), array_to, FALSE, FALSE);
			ad.SetTo(array_to);
		}

		if(ad.DoModal() == IDOK){
			app->m_me.SetTo(ad.GetTo());
			app->m_me.SetCc(ad.GetCc());
			app->m_me.SetBcc(ad.GetBcc());
		}else{
			return;
		}
	}else{
		// setting cc
		app->m_me.SetCc(m_pTextV->GetCurrentCc());

		// setting to
		if(m_pTextV->GetCurrentReplyTo().IsEmpty()){
			app->m_me.SetTo(m_pTextV->GetCurrentFrom());
		}else{
			app->m_me.SetTo(m_pTextV->GetCurrentReplyTo());
		}
	}

	// setting from
	CString path = app->m_app_path+"\\"+m_pAcntV->GetCurrentAccountName()+"\\account.ini";
	CString address;
	GetPrivateProfileString("mailbox", "address", "", address.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
	address.ReleaseBuffer();
	app->m_me.SetFrom(address);

	// setting subject
	if(m_pTextV->GetCurrentSubject().Find("Re:") == 0 || m_pTextV->GetCurrentSubject().Find("RE:") == 0){
		app->m_me.SetSubject(m_pTextV->GetCurrentSubject());
	}else{
		app->m_me.SetSubject("Re: "+m_pTextV->GetCurrentSubject());
	}

	// setting "cc" field
	CString cc;
	GetPrivateProfileString("def_address", "cc", "", cc.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
	cc.ReleaseBuffer();
	if(!cc.IsEmpty()){
		app->m_me.AddCc(cc);
	}

	// setting "bcc" field
	CString bcc;
	GetPrivateProfileString("def_address", "bcc", "", bcc.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
	bcc.ReleaseBuffer();
	if(!bcc.IsEmpty()){
		app->m_me.AddBcc(bcc);
	}

	// setting "reply-to" field
	CString reply_to;
	GetPrivateProfileString("def_address", "reply_to", "", reply_to.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
	reply_to.ReleaseBuffer();
	if(!reply_to.IsEmpty()){
		app->m_me.SetReplyTo(reply_to);
	}

	// message-id
	app->m_me.SetMessageID(g_gen_msgid(address));

	// In-reply-to
	app->m_me.SetInReplyTo(m_pTextV->GetCurrentMsgID());
	// setting references
	app->m_me.SetReferences(m_pTextV->GetCurrentMsgID());

	if(g_is_there(app->m_app_path+"\\template\\default.rtmpl")){
		g_file2cstring(app->m_app_path+"\\template\\default.rtmpl", body_tmpl);
	}else{
		body_tmpl = DEF_REPLY_TEMPLATE;
	}

	g_file2cstring(app->m_app_path+"\\"+m_pAcntV->GetCurrentAccountName()+"\\signature", signature);
	tmpl.SetSignature(signature);
	tmpl.SetBody(m_pTextV->GetCurrentBody());

	// setting mail body
	app->m_me.AddText(tmpl.GetString(&(m_pTextV->m_md), body_tmpl));

	// create draft frame
	app->CreateDraftFrame(this->m_pAcntV->GetCurrentAccountName());
}

void CMainFrame::OnDraft() 
{
	CPochyApp *app = (CPochyApp *)AfxGetApp();
	CString path = app->m_app_path+"\\"+m_pAcntV->GetCurrentAccountName()+"\\account.ini";

	// initializing
	app->m_me.Initialize();

	// setting "from" field
	CString from;
	GetPrivateProfileString("mailbox", "address", "", from.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
	from.ReleaseBuffer();
	app->m_me.SetFrom(from);

	// setting "cc" field
	CString cc;
	GetPrivateProfileString("def_address", "cc", "", cc.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
	cc.ReleaseBuffer();
	app->m_me.SetCc(cc);

	// setting "bcc" field
	CString bcc;
	GetPrivateProfileString("def_address", "bcc", "", bcc.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
	bcc.ReleaseBuffer();
	app->m_me.SetBcc(bcc);

	// setting "reply-to" field
	CString reply_to;
	GetPrivateProfileString("def_address", "reply_to", "", reply_to.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
	reply_to.ReleaseBuffer();
	app->m_me.SetReplyTo(reply_to);

	// setting "message-id" field
	app->m_me.SetMessageID(g_gen_msgid(from));

	// getitng signature
//	CString signature;
//	g_file2cstring(app->m_app_path+"\\"+m_pAcntV->GetCurrentAccountName()+"\\signature", signature);

	CTemplate tmpl;
	CString body_tmpl;
	if(g_is_there(app->m_app_path+"\\template\\default.dtmpl")){
		g_file2cstring(app->m_app_path+"\\template\\default.dtmpl", body_tmpl);
	}else{
		body_tmpl = DEF_DRAFT_TEMPLATE;
	}

	CString signature;
	g_file2cstring(app->m_app_path+"\\"+m_pAcntV->GetCurrentAccountName()+"\\signature", signature);
	tmpl.SetSignature(signature);
//	tmpl.SetBody(m_pTextV->GetCurrentBody());

	// setting mail body
//	app->m_me.AddText("\r\n"+signature);
	app->m_me.AddText(tmpl.GetString(NULL, body_tmpl));

	// create window
	app->CreateDraftFrame(this->m_pAcntV->GetCurrentAccountName());
}

void CMainFrame::OnAddress() 
{
	CMainAddressBookDlg ad;
	ad.DoModal();
}

void CMainFrame::OnUpdateTransfer(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(this->m_button_transfer);
}

void CMainFrame::OnInfo() 
{
	this->OnDisplayHeader();
}

void CMainFrame::OnSwitchView()
{
	bool bAccountViewActive = m_split_account_folder.GetRowCount() == 2;

	CWnd* wnd = GetFocus();
	if(wnd == m_pTreeV)
		m_pListV->SetFocus();
	else if(wnd == m_pListV)
		m_pTextV->SetFocus();
	else if(wnd == m_pTextV && !m_multipart_hide)
		m_pMultiV->SetFocus();
	else if(wnd == m_pTextV && m_multipart_hide && bAccountViewActive)
		m_pAcntV->SetFocus();
	else if(wnd == m_pMultiV && bAccountViewActive)
		m_pAcntV->SetFocus();
	else
		m_pTreeV->SetFocus();
}

void CMainFrame::OnUpdateInfo(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(this->m_button_info);
}

void CMainFrame::OnUpdateSetting(CCmdUI* pCmdUI)
{
	int index = m_pAcntV->GetAccountNum(m_pAcntV->GetCurrentAccountName());
	pCmdUI->Enable(m_pAcntV->m_data[index].button_setting);
}

BOOL CMainFrame::CreateToolbar()
{
	DWORD dwTBStyle, dwStyle;

	dwTBStyle = TBSTYLE_FLAT; // ̕ӂ̃X^C͓K
	dwStyle = WS_CHILD | WS_VISIBLE | CBRS_TOP | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC;
	if(!m_wndToolBar.CreateEx(this, dwTBStyle, dwStyle)){
		TRACE0("Failed to create toolbar\n");
		return FALSE;    // fail to create
	}

	CImageList img;
	HINSTANCE hInst = AfxFindResourceHandle((LPCTSTR)IDR_TEST, RT_BITMAP);
	ASSERT(hInst != NULL);

	int nIconWidth = WIDTH_ICON_MAIN;
	int nIconHeight = HEIGHT_ICON_MAIN;
	LPCTSTR lpBitmap = (LPCTSTR)IDR_MAINFRAME;
	UINT uFlags = LR_CREATEDIBSECTION;

//	CString strToolbarFilePath = ((CPochyApp*)::AfxGetApp())->m_app_path + TOOLBAR_MAIN_FILENAME;
 	// skin.ini
	CPochyApp *pApp =(CPochyApp*)::AfxGetApp();
	CString strToolbarFilePath;
	if(pApp->m_skin.getToolbarMainIcons() == ""){
		strToolbarFilePath = ((CPochyApp*)::AfxGetApp())->m_app_path + TOOLBAR_MAIN_FILENAME;
	}else{
		strToolbarFilePath = pApp->m_skin.getSkinIniPath() + "\\" + pApp->m_skin.getToolbarMainIcons();
	}
	HBITMAP hBitmap = (HBITMAP)::LoadImage(hInst, strToolbarFilePath, IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE);
	if (hBitmap != NULL)
	{
		BITMAP bitmap;
		if (::GetObject(hBitmap, sizeof(bitmap), &bitmap) > 0)
		{
			nIconWidth = bitmap.bmWidth / NUMBER_OF_TOOLBAR_MAIN_ICON;
			nIconHeight = bitmap.bmHeight;
			lpBitmap = strToolbarFilePath;
			uFlags |= LR_LOADFROMFILE;
		}
		::DeleteObject(hBitmap);
	}

	img.Attach(ImageList_LoadImage(hInst, lpBitmap, nIconWidth, 0, /*CLR_NONE*/RGB(255, 255, 255), IMAGE_BITMAP, uFlags));
	m_wndToolBar.GetToolBarCtrl().SetImageList(&img);
	img.Detach();

	m_wndToolBar.SetSizes(CSize(nIconWidth + 7, nIconHeight + 6), CSize(nIconWidth, nIconHeight));
	m_wndToolBar.SetButtons(NULL, 9);

	m_wndToolBar.SetButtonInfo( 0, ID_DRAFT, TBSTYLE_BUTTON, 0);
	m_wndToolBar.SetButtonInfo( 1, ID_FETCH_MAIL, TBSTYLE_BUTTON, 1);
	m_wndToolBar.SetButtonInfo( 2, ID_REPLY, TBSTYLE_BUTTON, 2);
	m_wndToolBar.SetButtonInfo( 3, ID_TRANSFER, TBSTYLE_BUTTON, 3);
	m_wndToolBar.SetButtonInfo( 4, ID_ADDRESS, TBSTYLE_BUTTON, 4);
	m_wndToolBar.SetButtonInfo( 5, ID_GPG, TBSTYLE_BUTTON, 5);
	m_wndToolBar.SetButtonInfo( 6, ID_RETRIEVE, TBSTYLE_BUTTON, 6);
	m_wndToolBar.SetButtonInfo( 7, ID_SETTING, TBSTYLE_BUTTON, 7);
	m_wndToolBar.SetButtonInfo( 8, ID_INFO, TBSTYLE_BUTTON, 8);

	//m_wndToolBar.SetButtonInfo(2, 0, TBSTYLE_SEP, 6);

	// dropdown menu
	m_wndToolBar.GetToolBarCtrl().SetExtendedStyle(TBSTYLE_EX_DRAWDDARROWS);
	// draft
	DWORD style = m_wndToolBar.GetButtonStyle(m_wndToolBar.CommandToIndex(ID_DRAFT));
	style |= TBSTYLE_DROPDOWN;
	m_wndToolBar.SetButtonStyle(m_wndToolBar.CommandToIndex(ID_DRAFT), style);
	// reply
	style = m_wndToolBar.GetButtonStyle(m_wndToolBar.CommandToIndex(ID_REPLY));
	style |= TBSTYLE_DROPDOWN;
	m_wndToolBar.SetButtonStyle(m_wndToolBar.CommandToIndex(ID_REPLY), style);
	// transfer
	style = m_wndToolBar.GetButtonStyle(m_wndToolBar.CommandToIndex(ID_TRANSFER));
	style |= TBSTYLE_DROPDOWN;
	m_wndToolBar.SetButtonStyle(m_wndToolBar.CommandToIndex(ID_TRANSFER), style);
	// gpg
	style = m_wndToolBar.GetButtonStyle(m_wndToolBar.CommandToIndex(ID_GPG));
	style |= TBSTYLE_DROPDOWN;
	m_wndToolBar.SetButtonStyle(m_wndToolBar.CommandToIndex(ID_GPG), style);
	// information
	style = m_wndToolBar.GetButtonStyle(m_wndToolBar.CommandToIndex(ID_INFO));
	style |= TBSTYLE_DROPDOWN;
	m_wndToolBar.SetButtonStyle(m_wndToolBar.CommandToIndex(ID_INFO), style);
	// setting
	style = m_wndToolBar.GetButtonStyle(m_wndToolBar.CommandToIndex(ID_SETTING));
	style |= TBSTYLE_DROPDOWN;
	m_wndToolBar.SetButtonStyle(m_wndToolBar.CommandToIndex(ID_SETTING), style);

	return TRUE;
}

void CMainFrame::OnToolbarDropDown(NMHDR* pNMHDR, LRESULT *plr)
{
	CPochyApp* app = (CPochyApp*)AfxGetApp();
	CFileFind ff;
	CWnd *wnd = &m_wndToolBar;
	UINT id;

	NMTOOLBARA *pnmtb = (NMTOOLBARA *)pNMHDR;

	// Switch on button command id's
	switch (pnmtb->iItem){
	case ID_DRAFT:
		id = IDR_MAINFRAME_POPUP_DRAFT;
		break;
	case ID_REPLY:
		id = IDR_MAINFRAME_POPUP_REPLY;
		break;
	case ID_TRANSFER:
		id = IDR_MAINFRAME_POPUP_TRANSFER;
		break;
	case ID_GPG:
		id = IDR_MAINFRAME_POPUP_GPG;
		break;
	case ID_INFO:
		id = IDR_MAINFRAME_POPUP_INFO;
		break;
	case ID_SETTING:
		id = IDR_MAINFRAME_POPUP_SETTING;
		break;
	default:
		return;
	}
	
	// load and display popup menu
	CMenu menu;
	menu.LoadMenu(id);
	CMenu* pPopup = menu.GetSubMenu(0);
	ASSERT(pPopup);

	int i;
	BOOL b;
	switch(pnmtb->iItem){
	case ID_DRAFT:
		this->m_template_array.RemoveAll();
		b = ff.FindFile(app->m_app_path+"\\template\\*.*");
		while(b){
			b = ff.FindNextFile();
			if(!ff.IsDirectory() && !ff.IsDots()){
				if(ff.GetFileName().Mid(ff.GetFileName().Find(".")+1) == "dtmpl"){
					if(ff.GetFileName() != "default.dtmpl"){
						this->m_template_array.Add(ff.GetFileName());
					}
				}
			}
		}
		for(i=0; i<m_template_array.GetSize(); i++){
			pPopup->AppendMenu(MF_STRING|MF_ENABLED, ID_DYNAMIC_DROP_DOWN_MENU_START+i, m_template_array.GetAt(i));
		}
		break;
	case ID_REPLY:
		this->m_template_array.RemoveAll();
		b = ff.FindFile(app->m_app_path+"\\template\\*.*");
		while(b){
			b = ff.FindNextFile();
			if(!ff.IsDirectory() && !ff.IsDots()){
				if(ff.GetFileName().Mid(ff.GetFileName().Find(".")+1) == "rtmpl"){
					if(ff.GetFileName() != "default.rtmpl"){
						this->m_template_array.Add(ff.GetFileName());
					}
				}
			}
		}
		for(i=0; i<m_template_array.GetSize(); i++){
			pPopup->AppendMenu(MF_STRING|MF_ENABLED, ID_DYNAMIC_DROP_DOWN_MENU_START+i, m_template_array.GetAt(i));
		}
		break;
	case ID_TRANSFER:
		this->m_template_array.RemoveAll();
		b = ff.FindFile(app->m_app_path+"\\template\\*.*");
		while(b){
			b = ff.FindNextFile();
			if(!ff.IsDirectory() && !ff.IsDots()){
				if(ff.GetFileName().Mid(ff.GetFileName().Find(".")+1) == "ftmpl"){
					if(ff.GetFileName() != "default.ftmpl"){
						this->m_template_array.Add(ff.GetFileName());
					}
				}
			}
		}
		for(i=0; i<m_template_array.GetSize(); i++){
			pPopup->AppendMenu(MF_STRING|MF_ENABLED, ID_DYNAMIC_DROP_DOWN_MENU_START+i, m_template_array.GetAt(i));
		}
		break;
	default:
		break;
	}
	
	CRect rc;
	wnd->SendMessage(TB_GETRECT, pnmtb->iItem, (LPARAM)&rc);
	wnd->ClientToScreen(&rc);
	
	pPopup->TrackPopupMenu( TPM_LEFTALIGN | TPM_LEFTBUTTON | TPM_VERTICAL, rc.left, rc.bottom, this, &rc);

	return;
}

void CMainFrame::OnGpg()
{
	this->OnGpgKeyManagement();
}

void CMainFrame::ReArrangeSplit()
{
	CRect rect;
	int bar_horizonal = 0; // Ƃ肠0ɂƂ̂ŁAmulti_heightbar̕l^Kv

	// summaryview textview multipartview 킹
	m_split_left_right.GetPane(0,1)->GetClientRect(&rect);
	rect.NormalizeRect();
	int height = rect.Height();
	rect.SetRectEmpty();

	// multipartview̍DEF_MULTI_HEIGHTɂȂ悤ɐݒ
	m_split_multi_others.SetRowInfo(0, height-(DEF_MULTI_HEIGHT+bar_horizonal), 0);
	m_split_multi_others.SetRowInfo(1, DEF_MULTI_HEIGHT, 0);
	m_split_multi_others.RecalcLayout();
}

void CMainFrame::HideMultiPartView(BOOL b)
{
	CWnd* pFocusWnd = GetFocus();
	if(b && m_multipart_hide == FALSE){
		m_split_multi_others.HideRow(1);
		m_multipart_hide = TRUE;
	}else if(!b && m_multipart_hide == TRUE){
		m_split_multi_others.ShowRow();
		m_multipart_hide = FALSE;
	}
	if (pFocusWnd == m_pTextV || pFocusWnd == m_pMultiV)
	{
		// HideRow ŃtH[JXt[ɈڂĂ܂ߖ߂
		m_pTextV->SetFocus();
	}
}

void CMainFrame::OnTimer(UINT nIDEvent) 
{
	if(!m_pAcntV->IsFetching(m_pAcntV->GetCurrentAccountName())){
		OnFetchmail();
	}
	CFrameWnd::OnTimer(nIDEvent);
}

void CMainFrame::UpdateButton1(BOOL b, CString account)
{
	int index = m_pAcntV->GetAccountNum(account);
	m_pAcntV->m_data[index].button_fetchmail = b;
	m_pAcntV->m_data[index].button_setting = b;
	m_pAcntV->m_data[index].button_retrieve = b;
	Invalidate(TRUE);
	UpdateWindow();
}

void CMainFrame::UpdateButton2(BOOL b)
{
	if (m_pTextV->IsPgpMime()) {
		m_button_reply = FALSE;	
	}else{// each button(reply, transfer, header info) is invalidate
		m_button_reply = b;	
	}
	m_button_transfer = b;
	m_button_info = b;
}

void CMainFrame::SetStatusBarProgress(int current, int upper)
{
	if(m_progress.m_hWnd == NULL)
		SendMessage(WM_COMMAND, WM_PROGCREATE, NULL);
	// prepare for progress bar.
	m_progress.SetRange32(0, upper);
	m_progress.SetPos(current);
}

CString CMainFrame::GetStatusBarText()
{
	return m_wndStatusBar.GetPaneText(0);
}

void CMainFrame::GetStatusBarProgress(int &current, int &upper)
{
	int low;
	m_progress.GetRange(low, upper);
	current = m_progress.GetPos();
}

void CMainFrame::OnSettingGeneral() 
{
	CSettingGeneralDlg sd;
	if (sd.DoModal() == IDOK)
	{
		// ^XNgCACR̐ݒ𔽉f
		int nUseTaskTray = AfxGetApp()->GetProfileInt(_T("TaskTray"), _T("UseTaskTray"), 0);
		if (nUseTaskTray == 1)
		{
			m_notifyIcon.Add();
		}
		else
		{
//			m_notifyIcon.Delete();
			if (m_notifyIcon.IsActive()) m_notifyIcon.Delete();
		}

		// ǐ\ݒ𔽉f
		m_pTreeV->Invalidate(TRUE);
		m_pTreeV->UpdateWindow();
	}
}

void CMainFrame::OnSettingAccount() 
{
	CSettingAccountDlg sd;
	sd.DoModal();
}

void CMainFrame::OnDisplayHeader() 
{
	CPochyApp *app = (CPochyApp *)AfxGetApp();
	CString msg_id = g_ma(m_pTextV->GetCurrentMsgID());
	msg_id.Remove('.');
	msg_id.Remove('/');
	msg_id.Remove(':');
	msg_id.Remove('*');
	msg_id.Remove('?');
	msg_id.Remove('\"');
	msg_id.Remove('|');
	CString file_name = msg_id+"_header.txt";

	if(!g_is_there(app->m_app_path+"\\temp")) // if attached folder does not exist, create.
		_mkdir(app->m_app_path+"\\temp");
	CString file_path = app->m_app_path+"\\temp\\"+file_name;

	FILE* file = fopen(file_path, "wb");
	fwrite(m_pTextV->GetCurrentRawHeader(), sizeof(char), m_pTextV->GetCurrentRawHeader().GetLength(), file);
	fclose(file);

	CString editor_path = app->GetProfileString("Editor", "Path", "notepad");
	if(editor_path.IsEmpty())
		editor_path = "notepad";
	file_path = "\""+file_path+"\"";
	// open file with editor designated in setting.ini.
	ShellExecute(NULL,NULL, editor_path, file_path, NULL, SW_NORMAL);	
}

void CMainFrame::OnDisplayRawMail() 
{
	CPochyApp *app = (CPochyApp *)AfxGetApp();
	CString editor_path = app->GetProfileString("Editor", "Path", "notepad");
	if(editor_path.IsEmpty())
		editor_path = "notepad";
	// open file with editor designated in setting.ini.
	ShellExecute(NULL,NULL, editor_path, "\""+m_pTextV->GetCurrentPath()+"\"", NULL, SW_NORMAL);
}

void CMainFrame::OnSettingFilter() 
{
	CPochyApp *app = (CPochyApp *)AfxGetApp();
	CString file = app->m_app_path+"\\"+m_pAcntV->GetCurrentAccountName()+"\\"+"filter";
	// if filter file does not exist, create.
	if(!g_is_there(file)){
		g_string2file(FILTER_INSTRUCTION, file);
	}
	CString path = app->GetProfileString("Editor", "Path", "notepad");
	if(path.IsEmpty())
		path = "notepad";
	file = "\""+file+"\"";
	// open file with editor designated in setting.ini.
	ShellExecute(NULL,NULL, path, file, NULL, SW_SHOWNORMAL);
}

void CMainFrame::OnSettingNewAccount() 
{
	CPochyApp* app = (CPochyApp*)AfxGetApp();
	CString name;
	for(int i=0;;i++){
		name.Format("NewAccount%d", i);
		if(g_is_there(app->m_app_path+"\\"+name)){
			continue;
		}else{
			break;
		}
	}

	this->m_pAcntV->CreateNewAccount(name);
	this->m_pTreeV->ConstructTree(name);
	m_pTreeV->SelectInbox(name);

	// if multipartview is on display, hide
	this->m_pListV->Clear();
	this->m_pHeadV->Clear();
	this->m_pTextV->Clear();
}

void CMainFrame::OnTransferQuotation() 
{
	if(this->m_button_transfer == FALSE)
	{
		return;
	}

	CPochyApp *app = (CPochyApp *)AfxGetApp();
	CTemplate tmpl;
	CString body_tmpl;
	CString signature;
	int partCnt,i;

	// initialyze
	app->m_me.Initialize();

	// from
	CString path = app->m_app_path+"\\"+m_pAcntV->GetCurrentAccountName()+"\\account.ini";
	CString address;
	GetPrivateProfileString("mailbox", "address", "", address.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
	address.ReleaseBuffer();
	app->m_me.SetFrom(address);

	// setting "cc"
	CString cc;
	GetPrivateProfileString("def_address", "cc", "", cc.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
	cc.ReleaseBuffer();
	app->m_me.SetCc(cc);

	// setting "bcc" field
	CString bcc;
	GetPrivateProfileString("def_address", "bcc", "", bcc.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
	bcc.ReleaseBuffer();
	app->m_me.SetBcc(bcc);

	// setting "reply-to" field
	CString reply_to;
	GetPrivateProfileString("def_address", "reply_to", "", reply_to.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
	reply_to.ReleaseBuffer();
	app->m_me.SetReplyTo(reply_to);

	// message-id
	app->m_me.SetMessageID(g_gen_msgid(address));

	// subject
	app->m_me.SetSubject("Fw: "+m_pTextV->GetCurrentSubject());

	if(g_is_there(app->m_app_path+"\\template\\default.ftmpl")){
		g_file2cstring(app->m_app_path+"\\template\\default.ftmpl", body_tmpl);
	}else{
		body_tmpl = DEF_FORWARD_TEMPLATE;
	}

	g_file2cstring(app->m_app_path+"\\"+m_pAcntV->GetCurrentAccountName()+"\\signature", signature);
	tmpl.SetSignature(signature);
	tmpl.SetBody(m_pTextV->GetCurrentBody());
	tmpl.SetAddress(address);

	// setting mail body
	if (!m_pTextV->m_md.IsPgpMime()) {
		app->m_me.AddText(tmpl.GetString(&(m_pTextV->m_md), body_tmpl));
	}else{
		app->m_me.SetMode(m_pTextV->m_md.IsPgpMime());
	}
	
	partCnt = m_pTextV->m_md.HowManyPart();
	int mainPart = m_pTextV->m_md.GetMainTextPartNo();
// 2005.11.29 moogv mod start
//	for (i=1;i<partCnt;++i) {
	for (i=0;i<partCnt;++i) {
		if (i==mainPart)
			continue;
		
// 2005.11.29 moogv mod end
//		CString file_name;
		MULTIPART_STRUCT2 data;
		CStringArray body;		
		CString extension;
		data.m_file_name = m_pTextV->m_md.GetFileName(i);
//2005.11.29 moogv add
		//data.m_content_type = m_pTextV->m_md.GetContentType(i);	
		if (m_pTextV->m_md.IsPgpMime()) {
			data.m_content_type.Format("Content-Type: %s", 
				m_pTextV->m_md.GetContentType(i));
		}else{
			data.m_content_type.Format("Content-Type: %s; name=\"%s\"", 
				m_pTextV->m_md.GetContentType(i), data.m_file_name);
		}
//2005.11.29 moogv end
		data.m_content_transfer_encoding=m_pTextV->m_md.GetRawCTE(i);
		data.m_content_disposition = m_pTextV->m_md.GetRawCD(i);
		m_pTextV->m_md.GetBody(i, body);			
		g_cstringarray2cstring(body, data.m_body);
		data.m_encoding_type = m_pTextV->m_md.GetEncodingTypeStr(i);
		
		if (data.m_file_name=="") {
			extension = m_pTextV->m_md.GetExtension(m_pTextV->m_md.GetContentType(i));
			data.m_file_name.Format("Atache(%d).%s",i,extension);
		}
		data.m_type = m_pTextV->m_md.GetContentType(i);
		app->m_me.AddMultipart(data);
	}

	app->CreateDraftFrame(this->m_pAcntV->GetCurrentAccountName());	
}

void CMainFrame::OnGpgKeyManagement() 
{
	CGpgDlg gd;
	gd.DoModal();
}

void CMainFrame::OnClose() 
{
	CPochyApp *app = (CPochyApp *)AfxGetApp();

	if (app->m_pluginManager.OnClose() == PR_CLOSE_CANCEL)
	{
		return;
	}

	LONG lStyle = ::GetWindowLong(m_wndToolBar.GetSafeHwnd(), GWL_STYLE);
	if ((lStyle & WS_VISIBLE) == WS_VISIBLE){
		app->WriteProfileInt("ToolBar", "IsVisible", SW_SHOW);
	}else{
		app->WriteProfileInt("ToolBar", "IsVisible", SW_HIDE);
	}

	lStyle = ::GetWindowLong(m_wndStatusBar.GetSafeHwnd(), GWL_STYLE);
	if ((lStyle & WS_VISIBLE) == WS_VISIBLE){
		app->WriteProfileInt("StatusBar", "IsVisible", SW_SHOW);
	}else{
		app->WriteProfileInt("StatusBar", "IsVisible", SW_HIDE);
	}

	CFrameWnd::OnClose();
}

BOOL CMainFrame::OnCopyData(CWnd* pWnd, COPYDATASTRUCT* pCopyDataStruct) 
{
	CString opt;
	if(pCopyDataStruct->dwData == WM_MAILTO){ 
		opt = (char *)pCopyDataStruct->lpData;
		if(!opt.IsEmpty() && opt.Find("mailto:") == 0){
			CPochyApp *app = (CPochyApp *)AfxGetApp();

			// getting default account name
			CString def_account = app->GetProfileString("DefaultMailBox", "BoxName");

			app->m_me.Initialize();

			// setting To
			if(opt.Find("?", 7) != -1){ // mailto:hoge@hoge.com?subject=PGP%20Key&Body=Please%20send%20keyƂ
					// subject, body is not implemented.
				app->m_me.SetTo(opt.Mid(7, opt.Find("?", 7)-7));
			}else{
				app->m_me.SetTo(opt.Mid(7));
			}

			if(!def_account.IsEmpty()){
				// setting From
				CString path = app->m_app_path+"\\"+def_account+"\\account.ini";
				CString address;
				GetPrivateProfileString("mailbox", "address", "", address.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
				address.ReleaseBuffer();
				app->m_me.SetFrom(address);

				// setting "cc" field
				CString cc;
				GetPrivateProfileString("def_address", "cc", "", cc.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
				cc.ReleaseBuffer();
				app->m_me.SetCc(cc);

				// setting "bcc" field
				CString bcc;
				GetPrivateProfileString("def_address", "bcc", "", bcc.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
				bcc.ReleaseBuffer();
				app->m_me.SetBcc(bcc);

				// setting "reply-to" field
				CString reply_to;
				GetPrivateProfileString("def_address", "reply_to", "", reply_to.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
				reply_to.ReleaseBuffer();
				app->m_me.SetReplyTo(reply_to);

				// setting message-id
				app->m_me.SetMessageID(g_gen_msgid(address));

				// getting signature.
				CString signature;
				g_file2cstring(app->m_app_path+"\\"+def_account+"\\signature", signature);
				// set main text.
				app->m_me.AddText(signature);
				// draftframe
				app->CreateDraftFrame(def_account);
			}else{
				CString hostname;
				char *tmp = hostname.GetBuffer(255);
				DWORD size=255;
				::GetUserName(tmp, &size);
				hostname.ReleaseBuffer();
				app->m_me.SetFrom("");
				app->m_me.AddText("");
				app->m_me.SetMessageID(g_gen_msgid(hostname));
				// draftframe
				app->CreateDraftFrame(this->m_pAcntV->GetFirstAccountName());
			}
		}else if(!opt.IsEmpty() && opt.Find("reply_q:") == 0){

		}else if(!opt.IsEmpty() && opt.Find("reply_nq:") == 0){

		}else if(!opt.IsEmpty() && opt.Find("forward:") == 0){

		}
	}
	return CFrameWnd::OnCopyData(pWnd, pCopyDataStruct);
}

LRESULT CMainFrame::OnNotifyIcon(WPARAM wParam, LPARAM lParam)
{
	if (wParam == m_notifyIcon.GetID())
	{
		switch (lParam)
		{
		case WM_RBUTTONDOWN:
			{
				GetLastActivePopup()->SetForegroundWindow();
				POINT point;
				if (::GetCursorPos(&point) != 0)
				{
					CMenu menu;
					if (menu.CreatePopupMenu())
					{
						CMenu* pSystemMenu = GetSystemMenu(FALSE);
						if (pSystemMenu != NULL)
						{
							CString menuString;
							if (IsIconic())
							{
								pSystemMenu->GetMenuString(SC_RESTORE, menuString, MF_BYCOMMAND);
								menu.AppendMenu(MF_STRING, SC_RESTORE, menuString);
								menu.AppendMenu(MF_SEPARATOR);
							}
							pSystemMenu->GetMenuString(SC_CLOSE, menuString, MF_BYCOMMAND);
							menu.AppendMenu(MF_STRING, SC_CLOSE, menuString);
							CPochyApp* pPochyApp = (CPochyApp*)::AfxGetApp();
							if (pPochyApp != NULL)
							{
								pPochyApp->m_pluginManager.OnInitMenu(menu.GetSafeHmenu(), POCHY_MENU_TASKTRAY);
							}
							UINT uItem = menu.TrackPopupMenu(
								TPM_RIGHTALIGN | TPM_LEFTBUTTON | TPM_RIGHTBUTTON | TPM_RETURNCMD,
								point.x, point.y, this);
							if (uItem == SC_CLOSE || uItem == SC_RESTORE)
							{
								PostMessage(WM_SYSCOMMAND, uItem, NULL);
							}
							else
							{
								CallPluginCallback(GetSafeHwnd(), uItem);
							}
						}
					}
				}
			}
			break;

		case WM_LBUTTONDOWN:
			{
				if (IsIconic())
				{
					ShowWindow(SW_RESTORE);
				}
				GetLastActivePopup()->SetForegroundWindow();
			}
			break;

		default:
			break;
		}
	}

	return 0;
}

LRESULT CMainFrame::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	if (message == m_notifyIcon.m_uTaskbarCreated)
	{
		m_notifyIcon.Add();
	}

	return CFrameWnd::WindowProc(message, wParam, lParam);
}

void CMainFrame::OnSysCommand(UINT nID, LPARAM lParam) 
{	
	CFrameWnd::OnSysCommand(nID, lParam);

	switch (nID)
	{
	case SC_MINIMIZE:
		{
			int nUseTaskTray = AfxGetApp()->GetProfileInt(_T("TaskTray"), _T("UseTaskTray"), 0);
			int nTaskTrayOnly = AfxGetApp()->GetProfileInt(_T("TaskTray"), _T("TaskTrayOnly"), 0);
			if (nUseTaskTray == 1 && nTaskTrayOnly == 1)
			{
				ShowWindow(SW_HIDE);
			}
		}
		break;
	default:
		break;
	}

	CallPluginCallback(this->GetSafeHwnd(), nID);
}

void CMainFrame::StartTaskTrayAnimation()
{
	if(this->m_notifyIcon.IsActive()){
		this->m_notifyIcon.StartAnimation();
		this->m_tasktray_animation_num++;
	}
}

void CMainFrame::StopTaskTrayAnimation()
{
	if(this->m_notifyIcon.IsActive()){
		this->m_tasktray_animation_num--;
		if(this->m_tasktray_animation_num == 0){
			this->m_notifyIcon.EndAnimation();
			this->m_notifyIcon.Modify();
		}
	}
}

void CMainFrame::HideHeaderView(BOOL b)
{
	if(b){
		m_split_header_text.HideRow(0);
	}else{
		m_split_header_text.ShowRow();
	}
}

void CMainFrame::HideAccountView(BOOL bHide)
{
	if (bHide)
	{
		m_split_account_folder.HideRow(0);
	}
	else
	{
		m_split_account_folder.ShowRow();
	}
}

BOOL CMainFrame::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo) 
{
	CPochyApp *app = (CPochyApp *)AfxGetApp();
	CStringArray array_to;
	CStringArray array_cc;
	CStringArray array_tmp;
	CString menu_item;
	CTemplate tmpl;
	CString body_tmpl;
	CMainAddressCheckDlg ad;

	// pHandlerInfo == NUUL means this message id is not assigned to any handler
	if(pHandlerInfo == NULL && ID_DYNAMIC_DROP_DOWN_MENU_START <= nID && nID <= ID_DYNAMIC_DROP_DOWN_MENU_END){
		if(nCode == CN_COMMAND){
			menu_item = this->m_template_array.GetAt(nID-ID_DYNAMIC_DROP_DOWN_MENU_START);
			if(menu_item.Mid(menu_item.Find(".")+1) == "dtmpl"){
				
				// initialyze
				app->m_me.Initialize();

				// setting from
				CString path = app->m_app_path+"\\"+m_pAcntV->GetCurrentAccountName()+"\\account.ini";
				CString address;
				GetPrivateProfileString("mailbox", "address", "", address.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
				address.ReleaseBuffer();
				app->m_me.SetFrom(address);

				// setting default "cc"
				CString cc;
				GetPrivateProfileString("def_address", "cc", "", cc.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
				cc.ReleaseBuffer();
				if(!cc.IsEmpty()){
					app->m_me.AddCc(cc);
				}

				// setting default "bcc"
				CString bcc;
				GetPrivateProfileString("def_address", "bcc", "", bcc.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
				bcc.ReleaseBuffer();
				if(!bcc.IsEmpty()){
					app->m_me.AddBcc(bcc);
				}

				// setting "reply-to"
				CString reply_to;
				GetPrivateProfileString("def_address", "reply_to", "", reply_to.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
				reply_to.ReleaseBuffer();
				if(!reply_to.IsEmpty()){
					app->m_me.SetReplyTo(reply_to);
				}

				// message-id
				app->m_me.SetMessageID(g_gen_msgid(address));

				// preparing for signature and body
				CString signature;
				g_file2cstring(app->m_app_path+"\\"+m_pAcntV->GetCurrentAccountName()+"\\signature", signature);
				tmpl.SetSignature(signature);
				g_file2cstring(app->m_app_path+"\\template\\"+menu_item, body_tmpl);
				// setting mail body
				app->m_me.AddText(tmpl.GetString(NULL, body_tmpl));

				// create draft frame
				app->CreateDraftFrame(this->m_pAcntV->GetCurrentAccountName());

		}else if(menu_item.Mid(menu_item.Find(".")+1) == "rtmpl"){
				
				// initialyze
				app->m_me.Initialize();

				g_split_address(m_pTextV->GetCurrentTo(), array_tmp, FALSE, FALSE);

				if(!m_pTextV->GetCurrentCc().IsEmpty() || array_tmp.GetSize() > 1){
					// setting cc
					if(!m_pTextV->GetCurrentCc().IsEmpty()){
						g_split_address(m_pTextV->GetCurrentCc(), array_cc, FALSE, FALSE);
					}
					if(array_tmp.GetSize() > 1){
						array_cc.Append(array_tmp);
					}
					if(array_cc.GetSize() > 0){
						ad.SetCc(array_cc);
					}

					// setting to, if reply-to exist, use reply-to address as to address
					if(m_pTextV->GetCurrentReplyTo().IsEmpty()){
						g_split_address(m_pTextV->GetCurrentFrom(), array_to, FALSE, FALSE);
						ad.SetTo(array_to);
					}else{
						g_split_address(m_pTextV->GetCurrentReplyTo(), array_to, FALSE, FALSE);
						ad.SetTo(array_to);
					}

					if(ad.DoModal() == IDOK){
						app->m_me.SetTo(ad.GetTo());
						app->m_me.SetCc(ad.GetCc());
						app->m_me.SetBcc(ad.GetBcc());
					}else{
						return TRUE;
					}
				}else{
					// setting cc
					app->m_me.SetCc(m_pTextV->GetCurrentCc());

					// setting to
					if(m_pTextV->GetCurrentReplyTo().IsEmpty()){
						app->m_me.SetTo(m_pTextV->GetCurrentFrom());
					}else{
						app->m_me.SetTo(m_pTextV->GetCurrentReplyTo());
					}
				}

				// setting from
				CString path = app->m_app_path+"\\"+m_pAcntV->GetCurrentAccountName()+"\\account.ini";
				CString address;
				GetPrivateProfileString("mailbox", "address", "", address.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
				address.ReleaseBuffer();
				app->m_me.SetFrom(address);

				// setting subject
				if(m_pTextV->GetCurrentSubject().Find("Re:") == 0 || m_pTextV->GetCurrentSubject().Find("RE:") == 0){
					app->m_me.SetSubject(m_pTextV->GetCurrentSubject());
				}else{
					app->m_me.SetSubject("Re: "+m_pTextV->GetCurrentSubject());
				}

				// setting "cc" field
				CString cc;
				GetPrivateProfileString("def_address", "cc", "", cc.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
				cc.ReleaseBuffer();
				if(!cc.IsEmpty()){
					app->m_me.AddCc(cc);
				}

				// setting "bcc" field
				CString bcc;
				GetPrivateProfileString("def_address", "bcc", "", bcc.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
				bcc.ReleaseBuffer();
				if(!bcc.IsEmpty()){
					app->m_me.AddBcc(bcc);
				}

				// setting "reply-to" field
				CString reply_to;
				GetPrivateProfileString("def_address", "reply_to", "", reply_to.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
				reply_to.ReleaseBuffer();
				if(!reply_to.IsEmpty()){
					app->m_me.SetReplyTo(reply_to);
				}

				// message-id
				app->m_me.SetMessageID(g_gen_msgid(address));

				// In-reply-to
				app->m_me.SetInReplyTo(m_pTextV->GetCurrentMsgID());
				
				// setting references
				app->m_me.SetReferences(m_pTextV->GetCurrentMsgID());

				// preparing for signature and body
				CString signature;
				g_file2cstring(app->m_app_path+"\\"+m_pAcntV->GetCurrentAccountName()+"\\signature", signature);
				tmpl.SetSignature(signature);
				tmpl.SetBody(m_pTextV->GetCurrentBody());
				g_file2cstring(app->m_app_path+"\\template\\"+menu_item, body_tmpl);
				// setting mail body
				app->m_me.AddText(tmpl.GetString(&(m_pTextV->m_md), body_tmpl));

				// create draft frame
				app->CreateDraftFrame(this->m_pAcntV->GetCurrentAccountName());

			}else if(menu_item.Mid(menu_item.Find(".")+1) == "ftmpl"){

				// initialyze
				app->m_me.Initialize();

				// from
				CString path = app->m_app_path+"\\"+m_pAcntV->GetCurrentAccountName()+"\\account.ini";
				CString address;
				GetPrivateProfileString("mailbox", "address", "", address.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
				address.ReleaseBuffer();
				app->m_me.SetFrom(address);
				tmpl.SetAddress(address);

				// setting "cc" field
				CString cc;
				GetPrivateProfileString("def_address", "cc", "", cc.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
				cc.ReleaseBuffer();
				app->m_me.SetCc(cc);

				// setting "bcc" field
				CString bcc;
				GetPrivateProfileString("def_address", "bcc", "", bcc.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
				bcc.ReleaseBuffer();
				app->m_me.SetBcc(bcc);

				// setting "reply-to" field
				CString reply_to;
				GetPrivateProfileString("def_address", "reply_to", "", reply_to.GetBuffer(BUF_LENGTH), BUF_LENGTH, path);
				reply_to.ReleaseBuffer();
				app->m_me.SetReplyTo(reply_to);

				// message-id
				app->m_me.SetMessageID(g_gen_msgid(address));

				// subject
				app->m_me.SetSubject("Fw: "+m_pTextV->GetCurrentSubject());

				// preparing for signature and body
				CString signature;
				g_file2cstring(app->m_app_path+"\\"+m_pAcntV->GetCurrentAccountName()+"\\signature", signature);
				tmpl.SetSignature(signature);
				tmpl.SetBody(m_pTextV->GetCurrentBody());
				g_file2cstring(app->m_app_path+"\\template\\"+menu_item, body_tmpl);

				// setting mail body
				app->m_me.AddText(tmpl.GetString(&(m_pTextV->m_md), body_tmpl));

				app->CreateDraftFrame(this->m_pAcntV->GetCurrentAccountName());	
			}
		}
		return TRUE;
	}
	return CFrameWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

void CMainFrame::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized) 
{
	CFrameWnd::OnActivate(nState, pWndOther, bMinimized);

	if (!bMinimized)
	{
		CPochyApp* pPochyApp = (CPochyApp*)::AfxGetApp();
		pPochyApp->m_pluginManager.OnActivate(nState);
	}
}

bool CMainFrame::CreateFolderList(const std::string& path, std::vector<std::string>& folderList)
{
	bool bResult = false;

	if (path.length() > 0)
	{
		WIN32_FIND_DATA findFileData;
		HANDLE hFindFile = ::FindFirstFile((path + _T("\\*.*")).c_str(), &findFileData);
		if (hFindFile != INVALID_HANDLE_VALUE)
		{
			while (::FindNextFile(hFindFile, &findFileData) != 0)
			{
				if ((findFileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) == FILE_ATTRIBUTE_DIRECTORY &&
					_tcscmp(findFileData.cFileName, _T("inbox")) != 0 &&
					_tcscmp(findFileData.cFileName, _T("outbox")) != 0 &&
					_tcscmp(findFileData.cFileName, _T("draft")) != 0 &&
					_tcscmp(findFileData.cFileName, _T("trash")) != 0 &&
					_tcscmp(findFileData.cFileName, _T(".")) != 0 &&
					_tcscmp(findFileData.cFileName, _T("..")) != 0)
				{
					std::string fullPath = path + _T("\\") + findFileData.cFileName;
					folderList.push_back(fullPath);
					CreateFolderList(fullPath, folderList);
				}
			}
			::FindClose(hFindFile);
		}
	}

	return bResult;
}

bool CMainFrame::SelectNextUnreadFolder()
{
	bool bResult = false;

	CPochyApp* pApp = (CPochyApp*)::AfxGetApp();
	CMainFrame* pMainFrame = (CMainFrame*)pApp->m_pMainWnd;
	CAccountView* pAccountView = (CAccountView*)pMainFrame->m_pAcntV;
	CFolderView* pFolderView = (CFolderView*)pMainFrame->m_pTreeV;

	HTREEITEM hTreeItem = pFolderView->GetTreeCtrl().GetSelectedItem();
	std::string selectedFolderPath = pFolderView->GetItemPath(hTreeItem);
	if (selectedFolderPath != _T(""))
	{
		// IĂtH_[̈ʒuL
		selectedFolderPath = (std::string)pApp->m_app_path + selectedFolderPath;
	}

	int nAccountCount = pAccountView->m_data.GetSize();
	int nAccount = pAccountView->m_index;
	if (nAccount < 0)
	{
		nAccount = 0;
	}
	if (nAccountCount > 0)
	{
		std::string unreadFolderPath;
		do // AJEg̐JԂ
		{
			// ǃtH_[OƂătH_[̃Xg
			std::vector<std::string> folderList;
			std::string path = pApp->m_app_path + _T("\\") + pAccountView->m_data[nAccount].account_name;

			// tH_[Xgǉ
			folderList.push_back(path + _T("\\") + _T("inbox"));
			CreateFolderList(path + _T("\\") + _T("inbox"), folderList);
			folderList.push_back(path + _T("\\") + _T("outbox"));
			CreateFolderList(path + _T("\\") + _T("outbox"), folderList);
			folderList.push_back(path + _T("\\") + _T("draft"));
			CreateFolderList(path + _T("\\") + _T("draft"), folderList);
			folderList.push_back(path + _T("\\") + _T("trash"));
			CreateFolderList(path + _T("\\") + _T("trash"), folderList);
			// ʃtH_[Xgǉ
			CreateFolderList(path, folderList);

			unreadFolderPath = FindUnreadFolderPath(folderList, selectedFolderPath);

			if (unreadFolderPath != _T(""))
			{
				break; // ǂtH_[甲
			}

			nAccount = (nAccount + 1) % nAccountCount;
		}
		while (nAccount != pAccountView->m_index);

		if (unreadFolderPath != _T(""))
		{
			if (nAccount != pAccountView->m_index)
			{
				// ǂAJEgɕύX
				pAccountView->SelectAccount(nAccount);
			}

			// ǂtH_[I
			// ĂJ
			pFolderView->SelectFolder(unreadFolderPath.c_str());

			bResult = true;
		}
	}

	return bResult;
}

// tH_[XgɖǂtH_[
// startFolderPath ꏄ
const std::string CMainFrame::FindUnreadFolderPath(const std::vector<std::string>& folderList, const std::string& startFolderPath)
{
	CPochyApp* pApp = (CPochyApp*)::AfxGetApp();
	CMainFrame* pMainFrame = (CMainFrame*)pApp->m_pMainWnd;
	CSummaryView* pSummaryView = (CSummaryView*)pMainFrame->m_pListV;

	std::vector<std::string>::const_iterator it,
		selected_it = std::find(folderList.begin(), folderList.end(), startFolderPath);

	for (it = selected_it; it != folderList.end(); ++it)
	{
		int nUnread = pSummaryView->GetUnreadCount(it->c_str());
		if (nUnread > 0)
		{
			return *it; // ǂtH_[甲
		}
	}

	for (it = folderList.begin(); it != selected_it; ++it)
	{
		int nUnread = pSummaryView->GetUnreadCount(it->c_str());
		if (nUnread > 0)
		{
			return *it; // ǂtH_[甲
		}
	}

	return _T("");
}

void CMainFrame::OnScrollMail()
{
	int sc;
	m_pTextV->SetFocus();// tH[JXȂƁANbNƂɖ肪N
	sc = m_pTextV->GetScrollPos(SB_VERT);
	if(sc >= m_pTextV->GetScrollLimit(SB_VERT))
		sc = -m_pTextV->GetRichEditCtrl().GetLineCount();
	else
		sc = 7;
	m_pTextV->GetRichEditCtrl().LineScroll(sc);
}

void CMainFrame::OnShowPluginList()
{
	CPluginListDialog dialog;
	dialog.DoModal();
}

void CMainFrame::AddMenuCallback(const int nID, POCHY_MENU_CALLBACK callback)
{
	m_menuCallbackMap.insert(MENU_CALLBACK_MAP::value_type(nID, callback));
}

BOOL CMainFrame::PreTranslateMessage(MSG* pMsg) 
{
	if (m_acceleratorTable.TranslateAccelerator(m_hWnd, pMsg))
	{
		return TRUE;
	}
	
	return CFrameWnd::PreTranslateMessage(pMsg);
}

BOOL CMainFrame::OnCommand(WPARAM wParam, LPARAM lParam) 
{
	switch (LOWORD(wParam))
	{
	case ID_CHECK_DELETE_MARK:
	case ID_UNCHECK_DELETE_MARK:
	case ID_EXECUTE_DELETE_MARK:
	case ID_SELECT_TOP_MAIL:
	case ID_SELECT_BOTTOM_MAIL:
	case ID_SUMMARYVIEW_REBUILD:
	case ID_NEXT_MAIL:
	case ID_PREV_MAIL:
	case ID_NEXT_UNREAD_MAIL:
		{
			// Summary View ̃CxgđM
			return ::SendMessage(m_pListV->GetSafeHwnd(), WM_COMMAND, wParam, lParam);
		}
		break;

	case ID_NEXT_FOLDER:
	case ID_PREV_FOLDER:
		{
			// Folder View ̃CxgđM
			return ::SendMessage(m_pTreeV->GetSafeHwnd(), WM_COMMAND, wParam, lParam);
		}
		break;

	case ID_NEXT_ACCOUNT:
	case ID_PREV_ACCOUNT:
		{
			// Account View ̃CxgđM
			return ::SendMessage(m_pAcntV->GetSafeHwnd(), WM_COMMAND, wParam, lParam);
		}
		break;

	case ID_PAGE_UP:
	case ID_PAGE_DOWN:
	case ID_SCROLL_AND_NEXT_UNREAD:
		{
			// Text View ̃CxgđM
			return ::SendMessage(m_pTextV->GetSafeHwnd(), WM_COMMAND, wParam, lParam);
		}
		break;
	}

	CallPluginCallback(this->GetSafeHwnd(), LOWORD(wParam));

	return CFrameWnd::OnCommand(wParam, lParam);
}

// vOCR[obNo^Ă郁bZ[WȂR[obNĂяo
void CMainFrame::CallPluginCallback(HWND hWnd, UINT nID)
{
	if (hWnd != NULL && ::IsWindow(hWnd))
	{
		MENU_CALLBACK_MAP::const_iterator it;
		it = m_menuCallbackMap.find(nID);
		if (it != m_menuCallbackMap.end())
		{
			it->second(hWnd, nID);
		}
	}
}

void CMainFrame::LoadAccelerator()
{
	CPochyApp *app = (CPochyApp*)AfxGetApp();
	std::string strKeyIniPath = app->m_app_path + _T("\\KeySetting.ini");
//	m_acceleratorTable.Save(strKeyIniPath, _T("MainFrameKey"));
	m_acceleratorTable.Load(strKeyIniPath, _T("MainFrameKey"));
	HMENU hMenu = ::GetMenu(m_hWnd);
	m_acceleratorTable.ModifyMenuCaption(hMenu);
}
/**
 * [̍ĐU蕪܂
 *
 * @author kondou
 */
void CMainFrame::OnSettingReFilter() 
{
	int i;
    CString path;
	CString message;
	CString file_name;
	CString dummy;
	CString current_account;
	CUIntArray ia;
	CStringArray header;
	CHeaderInfo hi;
	CPochyApp *app = (CPochyApp*)AfxGetApp();
	CMainFrame* pMainFrame = (CMainFrame*)app->m_pMainWnd;
	CSummaryView *sv = pMainFrame->m_pListV;
	CAccountView *av = pMainFrame->m_pAcntV;

	current_account= pMainFrame->m_pAcntV->GetCurrentAccountName();

	CFilter filter(app->m_app_path+"\\"+current_account);
	path = app->m_app_path + "\\" + current_account + "\\inbox\\";

	i = sv->GetStackNum() - 1;
	while(i >= 0){
		ia.RemoveAll();
		ia.Add(i);
		path = sv->m_path+"\\"+sv->m_array_list.GetAt(sv->GetStackNum()-ia.GetAt(ia.GetSize()-1)-1)->m_str5;
		header.RemoveAll();
		g_get_header(path , header);
		hi.DoIt(header);
		CString folder_path;
		CStringArray folder_path_array;
		filter.GetPath(hi, folder_path_array);
		for(int j=0; j<folder_path_array.GetSize(); j++){
			folder_path = folder_path_array[j];

			if(folder_path.IsEmpty()){
				ia.RemoveAt(ia.GetSize() - 1);
				message += " ";
				av->SetStatusBarText(message, current_account);
				continue;
			}else{
				message += " -->"+folder_path.Mid(folder_path.ReverseFind('\\'));
				av->SetStatusBarText(message, current_account);
			}
			if(!g_is_there(folder_path)){
				_mkdir(folder_path);
				g_file_create(folder_path + "\\list");
			}
			sv->MoveMail(ia,folder_path,SMRY_COLUMN_FROM);
			// call postfilter plugin
			app->m_pluginManager.OnPostFilter(path);
		}
		message.Empty();
		header.RemoveAll();
		i--;
	}

	AfxMessageBox("ĐU蕪܂B",MB_ICONINFORMATION);
}

void CMainFrame::SetAcceleratorTargetWindow()
{
//	m_acceleratorTable.AddTargetWindow(GetSafeHwnd());
	m_acceleratorTable.AddTargetWindow(m_pListV->GetSafeHwnd());
	m_acceleratorTable.AddTargetWindow(m_pAcntV->m_combo_account.GetSafeHwnd());
	m_acceleratorTable.AddTargetWindow(m_pTreeV->GetSafeHwnd());
	m_acceleratorTable.AddTargetWindow(m_pTextV->GetSafeHwnd());
	m_acceleratorTable.AddTargetWindow(m_pHeadV->GetSafeHwnd());
	m_acceleratorTable.AddTargetWindow(m_pMultiV->GetSafeHwnd());
	m_acceleratorTable.AddTargetWindow(m_pListV->GetParent()->GetSafeHwnd());
}

void CMainFrame::LoadDefaultAccelerator()
{
	m_acceleratorTable.DeleteAll();

	////////////////// MainFrame ////////////////////////////////////////////////////////////////////////////////////////
	// mail
	m_acceleratorTable.AddAccelerator(_T("Receive"),			ID_FETCH_MAIL,				_T("i"),		_T("M(&V)"));
	m_acceleratorTable.AddAccelerator(_T("ReplyMail"),			ID_REPLY,					_T("a"),		_T("ԐM(&R)..."));
//	m_acceleratorTable.AddAccelerator(_T("ReplyQuotation"),		ID_REPLY_QUOTATION,			_T("Shift+a"),	_T("pԐM...));
//	m_acceleratorTable.AddAccelerator(_T("ReplyNoQuotation"),	ID_REPLY_NO_QUOTATION,		_T("a"),		_T("pȂԐM..."));
	m_acceleratorTable.AddAccelerator(_T("Forward"),			ID_TRANSFER,				_T("f"),		_T("](&T)..."));
//	m_acceleratorTable.AddAccelerator(_T("ForwardMail"),		ID_TRANSFER_QUOTATION,		_T("f"),		_T("](&T)..."));
	m_acceleratorTable.AddAccelerator(_T("NewMail"),			ID_DRAFT,					_T("w"),		_T("M(&N)..."));
	m_acceleratorTable.AddAccelerator(_T("Find"),				ID_RETRIEVE,				_T("Ctrl+F"),	_T("(&F)..."));
	m_acceleratorTable.AddAccelerator(_T("FindNext"),			ID_RETRIEVE_NEXT,			_T("Tab"),		_T(""));
	m_acceleratorTable.AddAccelerator(_T("AllFetchmail"),		ID_ALLFETCH_MAIL,			_T(""),			_T("ꊇM"));

	// GPG
	m_acceleratorTable.AddAccelerator(_T("GPGKeyManagement"),	ID_GPG_MAIN_KEY_MANAGEMENT,	_T("Ctrl+G"),	_T("̊Ǘ(&G)"));
//	m_acceleratorTable.AddAccelerator(_T("GPG"),				ID_GPG,						_T("Ctrl+G"),	_T("̊Ǘ(&G)"));
	m_acceleratorTable.AddAccelerator(_T("GPGDecode"),			ID_GPG_DEC,					_T("Ctrl+D"),	_T("(&D)"));

	// setting
	m_acceleratorTable.AddAccelerator(_T("ShowCommonSetting"),	ID_SETTING_GENERAL,			_T("Ctrl+F9"),	_T("ʓIȐݒ(&V)..."));
	m_acceleratorTable.AddAccelerator(_T("ShowAccountSetting"),	ID_SETTING_ACCOUNT,			_T("Ctrl+F10"),	_T("AJEgݒ(&S)..."));
//	m_acceleratorTable.AddAccelerator(_T("ShowSetting"),		ID_SETTING,					_T(""),			_T("ݒEBhE\"));
	m_acceleratorTable.AddAccelerator(_T("ShowFilterSetting"),	ID_SETTING_FILTER,			_T("Ctrl+F11"),	_T("U蕪ݒ(&F)..."));
	m_acceleratorTable.AddAccelerator(_T("SettingReFilter"),	ID_SETTING_REFILTER,		_T(""),			_T("ĐU蕪(&R)..."));
	m_acceleratorTable.AddAccelerator(_T("CreateNewAccount"),	ID_SETTING_NEW_ACCOUNT,		_T(""),			_T("VKAJEg(&N)"));
	m_acceleratorTable.AddAccelerator(_T("ShowAddressBook"),	ID_ADDRESS,					_T("Ctrl+B"),	_T("AhX̒ǉƍ폜(&A)..."));

	// show info
//	m_acceleratorTable.AddAccelerator(_T("ShowInfo"),			ID_INFO,					_T("Ctrl+H"),	_T("\"));
	m_acceleratorTable.AddAccelerator(_T("ShowHeader"),			ID_DISPLAY_HEADER,			_T("Ctrl+H"),	_T("wb_[̕\(&H)..."));
	m_acceleratorTable.AddAccelerator(_T("ShowRowMail"),		ID_DISPLAY_RAW_MAIL,		_T("Ctrl+R"),	_T("Õ[\(&R)..."));

	// view
	m_acceleratorTable.AddAccelerator(_T("SwitchView"),			ID_SWITCH_VIEW,				_T("Ctrl+O"),	_T("r[̃tH[JX؂ւ"));
	m_acceleratorTable.AddAccelerator(_T("ScrollMail"),			ID_SCROLL_MAIL,				_T(""),			_T("[XN["));

	// plugin
	m_acceleratorTable.AddAccelerator(_T("PluginInfo"),			ID_PLUGIN_INFO,				_T(""),			_T("vOC\(&I)..."));

	////////////////// Summary View ////////////////////////////////////////////////////////////////////////////////////////
	m_acceleratorTable.AddAccelerator(_T("CheckDeleteMark"),	ID_CHECK_DELETE_MARK,		_T("d"),		_T("폜}[N"));
	m_acceleratorTable.AddAccelerator(_T("UncheckDeleteMark"),	ID_UNCHECK_DELETE_MARK,		_T("u"),		_T("폜}[N"));
	m_acceleratorTable.AddAccelerator(_T("ExecuteDeleteMark"),	ID_EXECUTE_DELETE_MARK,		_T("x"),		_T("폜}[Nt[폜"));
	m_acceleratorTable.AddAccelerator(_T("SelectTopMail"),		ID_SELECT_TOP_MAIL,			_T(""),			_T("ԏ̃[I"));
	m_acceleratorTable.AddAccelerator(_T("SelectBottomMail"),	ID_SELECT_BOTTOM_MAIL,		_T(""),			_T("ԉ̃[I"));
//	m_acceleratorTable.AddAccelerator(_T("RebuildSummary"),		ID_SUMMARYVIEW_REBUILD,		_T(""),			_T("T}[̍č\z"));
	m_acceleratorTable.AddAccelerator(_T("NextMail"),			ID_NEXT_MAIL,				_T("Ctrl+N"),	_T("̃[I"));
	m_acceleratorTable.AddAccelerator(_T("PrevMail"),			ID_PREV_MAIL,				_T("Ctrl+P"),	_T("Õ[I"));
	m_acceleratorTable.AddAccelerator(_T("NextUnreadMail"),		ID_NEXT_UNREAD_MAIL,		_T("n"),		_T("̖ǃ[I"));

	////////////////// Folder View ////////////////////////////////////////////////////////////////////////////////////////
	m_acceleratorTable.AddAccelerator(_T("NextFolder"),			ID_NEXT_FOLDER,				_T(""),			_T("̃tH_[\"));
	m_acceleratorTable.AddAccelerator(_T("PrevFolder"),			ID_PREV_FOLDER,				_T(""),			_T("ÕtH_[\"));

	////////////////// Account View ////////////////////////////////////////////////////////////////////////////////////////
	m_acceleratorTable.AddAccelerator(_T("NextAccount"),		ID_NEXT_ACCOUNT,			_T(""),			_T("̃AJEg\"));
	m_acceleratorTable.AddAccelerator(_T("PrevAccount"),		ID_PREV_ACCOUNT,			_T(""),			_T("ÕAJEg\"));

	////////////////// MultiPart View ////////////////////////////////////////////////////////////////////////////////////////
//		case VK_RETURN: // Ytt@C̏ꍇN			ExecuteFile();
//		case 'n':			SelectNext();
//		case 'p':			SelectPrev();

	////////////////// Text View ////////////////////////////////////////////////////////////////////////////////////////
	m_acceleratorTable.AddAccelerator(_T("PageUp"),				ID_PAGE_UP,					_T("b"),		_T("1y[WɃXN["));
	m_acceleratorTable.AddAccelerator(_T("PageDown"),			ID_PAGE_DOWN,				_T(""),			_T("1y[WɃXN["));
	m_acceleratorTable.AddAccelerator(_T("ScrollAndNextUnread"),ID_SCROLL_AND_NEXT_UNREAD,	_T("Space"),	_T("XN[ & ̖ǃ[I"));
//		case '<': // plan to implement
//		case '>': // plan to implement

	m_acceleratorTable.CreateAcceleratorTable();
}

CString CMainFrame::CreateAttachedFile(int partNo)
{	
	CString dir_path;
	CString path;
	CString body;
	CStringArray body_array;
	CString Outbuf;
	//CString file_name;
	char *pOutbuf;
	int len;
	FILE *file;
	CPochyApp *app = (CPochyApp *)AfxGetApp();


	//temp\Ė\̧ٔԍ\̧ٖ
	path = g_get_tmp_file();
	
	//path += "\\" + m_pTextV->m_md.GetFileName(partNo);
	
	file = fopen(path, "wb");
	m_pTextV->m_md.GetBody(partNo, body_array);
	g_cstringarray2cstring(body_array, body);
	// base64
	if(m_pTextV->GetCurrentCTE() == BASE64){
		body.Remove('\r');
		body.Remove('\n');
		pOutbuf = Outbuf.GetBuffer(body.GetLength());
		len = from64tobits(pOutbuf, body, body.GetLength());
		fwrite(pOutbuf, sizeof(char), len, file);
	}
	// quoted-printable
	else if(m_pTextV->GetCurrentCTE() == QUOTED_PRINTABLE){
		pOutbuf = Outbuf.GetBuffer(body.GetLength()+10);
		len = fromQPtobits(pOutbuf, body, body.GetLength());
		fwrite(pOutbuf, sizeof(char), len, file);
	}
	else{ // other case
		CCodeConvert cc(body);
		body = cc.ToSjis();
		fwrite(body, sizeof(char), body.GetLength(), file);
	}
	fclose(file);
	return path;
}