/*
 * Copyright (C) 2002-2003 chik, hiranaka
 * For license terms, see the file COPYING in this directory.
 */

// Sock.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "Sock.h"

#ifdef _IPV6_
#include "ws2tcpip.h"
#endif

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSock

CSock::CSock()
{
	WSADATA wsaData;
	WSAStartup(MAKEWORD(1,1), &wsaData);
}

CSock::~CSock()
{
}

// ClassWizard KvƂȉ̍sҏWȂłB
#if 0
BEGIN_MESSAGE_MAP(CSock, CSocket)
	//{{AFX_MSG_MAP(CSock)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
#endif	// 0

/////////////////////////////////////////////////////////////////////////////
// CSock o֐

void CSock::DisConnect()
{
	closesocket(m_sock);
	WSACleanup();
}

int CSock::ReadLine(CString& out)
{
	char buf[1024];
	LPSTR end;
	int n;
	out.Empty();

	do{
		if((n = recv(m_sock, buf, sizeof(buf)-1, MSG_PEEK)) <= 0)
			return -1;
		if((end = (char *)memchr(buf, '\n', n)) != NULL)
			n = end-buf+1;			
		if(SockRead(buf, n) == -1)
			return -1;
		out += buf;
	}while(!end);
	return out.GetLength();
}

#ifndef _IPV6_
int CSock::GetIP(LPCTSTR addr, LPSTR ip)
{
	unsigned long addr_32bit;	// ip address
	struct hostent *hostent;
	IN_ADDR in;

	addr_32bit = inet_addr(addr);
	if(addr_32bit == -1){
		hostent = gethostbyname(addr);
		if(hostent == NULL){
			return 0;
		}else{
			memcpy(&in, hostent->h_addr_list[0], 4);
			strcpy(ip, inet_ntoa(in));
			return strlen(ip);
		}
	}
	strcpy(ip, addr);
	return strlen(ip);
}
#endif

int CSock::Connect6(LPCTSTR server_name, LPCTSTR port)
{
	int result;
#ifdef _IPV6_
	ADDRINFO hints, *ai, *ai_tmp;

	memset(&hints, 0, sizeof(hints));
	hints.ai_family = PF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;

	if(getaddrinfo(server_name, port, &hints, &ai) != 0){
		return INVALID_SOCKET;
	}

	for(ai_tmp = ai; ai_tmp != NULL; ai_tmp = ai_tmp->ai_next){
		m_sock = socket(ai_tmp->ai_family, ai_tmp->ai_socktype, ai_tmp->ai_protocol);
/*		if(m_sock == INVALID_SOCKET){
			continue;
		}*/
		if((result = connect(m_sock, ai_tmp->ai_addr, ai_tmp->ai_addrlen)) < 0){
			closesocket(m_sock);
			continue;
		}
		break;
	}
	freeaddrinfo(ai);

/*	if(m_sock == INVALID_SOCKET)
		return INVALID_SOCKET;

	int result = connect(m_sock, ai_tmp->ai_addr, ai_tmp->ai_addrlen);
	if(SOCKET_ERROR == result){
		return INVALID_SOCKET;
	}*/

/*
	memset(&hints, 0, sizeof(hints));
	hints.ai_family = PF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;
	getaddrinfo("www.kame.net", "http", &hints, &res0);
	for (res = res0; res; res = res->ai_next) {
	   s = socket(res->ai_family, res->ai_socktype, res->ai_protocol);
	   if (connect(s, res->ai_addr, res->ai_addrlen) < 0) {
	      close(s);
	      continue;
	   }
	   break;
	}
	freeaddrinfo(res0);
*/
#else
	CString ip;
	int len;
	if((len = this->GetIP(server_name, ip.GetBuffer(20))) == 0)
		return INVALID_SOCKET;

	ip.ReleaseBuffer(len);

	SOCKADDR_IN sockad;
//	int result; // modified by disfolk, 2004/10/21

	m_sock = socket(AF_INET, SOCK_STREAM, 0);

	sockad.sin_family = AF_INET;
	sockad.sin_addr.s_addr = inet_addr(ip);
	sockad.sin_port = htons((u_short)atoi(port));

	result = connect(m_sock, (PSOCKADDR)&sockad, sizeof(sockad));
#endif

	return result;
}

int CSock::SockRead(char *buf, int len)
{
	int left, read;

	left = len;
	while(0 < left){
		read = recv(m_sock, buf, left, 0);
		if(read < 0)
			return(-1);
		else if(read == 0)
			break;

		left -= read;
		buf += read;
	}
	*buf = '\0';
	return len-left;
}

int CSock::SockWrite(LPCTSTR buf, int len)
{
	int left, write;

	left = len;
	while(0 < left){
		write = send(m_sock, buf, left, 0);
		if(write < 1)
			return -1;

		left -= write;
		buf += write;
	}
	return len-left;
}
