/*
 * Copyright (C) 2002-2003 chik, hiranaka
 * For license terms, see the file COPYING in this directory.
 */

// AccountView.cpp
//

#include "stdafx.h"
#include "pochy.h"
#include "AccountView.h"
#include "MainFrm.h"
#include "lib.h"
#include "direct.h" // for _mkdir
#include "SettingAccountDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAccountView

IMPLEMENT_DYNCREATE(CAccountView, CFormView)

CAccountView::CAccountView()
	: CFormView(CAccountView::IDD), m_index(0)
{
	//{{AFX_DATA_INIT(CAccountView)
		// : ClassWizard ͂̈ʒuɃȍǉ܂
	//}}AFX_DATA_INIT
}

CAccountView::~CAccountView()
{
}

void CAccountView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAccountView)
	DDX_Control(pDX, IDC_COMBO_ACCOUNT, m_combo_account);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAccountView, CFormView)
	//{{AFX_MSG_MAP(CAccountView)
	ON_WM_SIZE()
	ON_CBN_SELCHANGE(IDC_COMBO_ACCOUNT, OnSelchangeAccount)
	ON_COMMAND(ID_NEXT_ACCOUNT, OnNextAccount)
	ON_COMMAND(ID_PREV_ACCOUNT, OnPrevAccount)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAccountView ff

#ifdef _DEBUG
void CAccountView::AssertValid() const
{
	CFormView::AssertValid();
}

void CAccountView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CAccountView bZ[W nh

void CAccountView::OnSize(UINT nType, int cx, int cy) 
{
	CFormView::OnSize(nType, cx, cy);

	CRect rect1;
	this->GetWindowRect(rect1);
	ScreenToClient(&rect1);

	CRect rect2;
	CWnd *wnd;
	wnd = this->GetDlgItem(IDC_COMBO_ACCOUNT);
	if(wnd != NULL){
		// adjust size of accountview.
		wnd->MoveWindow(rect1);
	}
}

void CAccountView::OnInitialUpdate() 
{
	CFormView::OnInitialUpdate();

	CFileFind ff;
	CPochyApp* app = (CPochyApp*)AfxGetApp();
	BOOL b = ff.FindFile(app->m_app_path+"\\*.*");
	int index;
	CString message;
	ACCOUNT_STRUCT as;
	m_data.RemoveAll();

	while(b){
		b = ff.FindNextFile();
		if(ff.IsDirectory() && !ff.IsDots()){
			if(g_is_there(app->m_app_path + "\\" + ff.GetFileName() + "\\account.ini")){
				index = m_combo_account.AddString(ff.GetFileName());
				switch(index){
				case CB_ERR:
					message.Format("%s̏擾ɃG[܂", ff.GetFileName());
					AfxMessageBox(message);
					return;
				case CB_ERRSPACE:
					message.Format("%d̏擾ɃȂȂ܂", ff.GetFileName());
					AfxMessageBox(message);
					return;
				}
				if(m_combo_account.SetItemData(index, index) == CB_ERR){
					message.Format("%s̏擾ɃG[܂", ff.GetFileName());
					AfxMessageBox(message);
					return;
				}else{
					m_combo_account.SetItemData(index, index);
					as.account_name = ff.GetFileName();
					as.button_fetchmail = TRUE;
					as.button_setting = TRUE;
					as.button_retrieve = TRUE;
					as.status_pgbar_current = 0;
					as.status_pgbar_upper = 100;
					as.status_text = "";
					as.is_fetching = FALSE;
					m_data.Add(as);
				}
			}
		}
	}

	// if account does not exist, make new one.
	if(0 == m_combo_account.GetCount())
		CreateNewAccount("NewAccount0");

	// display default account.
	// need to clarify whether or not that account do exist.
	CString account = app->GetProfileString("DefaultMailBox", "BoxName");
	if(!account.IsEmpty() && g_is_there(app->m_app_path+"\\"+account+"\\account.ini")){
		index = m_combo_account.FindStringExact(-1, account);
		SelectAccount(index);
	}else{
		index = 0;
		SelectAccount(index);
	}
}

void CAccountView::OnSelchangeAccount()
{
	int index = m_combo_account.GetCurSel();
	CString account;
	m_combo_account.GetLBText(index, account);

 	if (m_account != account)
 	{
 		// ωƂ
 		m_account = account;
 		m_index = index;

 		CWaitCursor wait_cursor; // turn cursor into hourglass.
		CPochyApp* app = (CPochyApp*)AfxGetApp();
		CMainFrame *mf = (CMainFrame*)app->m_pMainWnd;

		CFolderView *fv = mf->m_pTreeV;
		CSummaryView *sv = mf->m_pListV;
		CTextView *tv = mf->m_pTextV;
		CHeaderView *hv = mf->m_pHeadV;

		// if selected account is under popping, current status of popping is displaied on statusbar.
		mf->SetStatusBarProgress(m_data[GetAccountNum(account)].status_pgbar_current, m_data[GetAccountNum(account)].status_pgbar_upper);
		mf->SetStatusBarText(0, m_data[GetAccountNum(account)].status_text);

		// replyAtransferAheader at toolbar is invalidated.
		mf->UpdateButton2(FALSE);

		// if multipartview is showing, hide.
		sv->Clear();
		tv->Clear();
		hv->Clear();

		// change document name to current mail box name
		CString title;
		title.Format("%s - %s", account, "pochy");
		AfxGetApp()->m_pMainWnd->SetWindowText(title);

		app->m_pluginManager.OnAccountChanged(account);

		if (fv->GetSelectedItemAccountName() != account)
		{
			fv->SelectInbox(account);
		}
 	}
}

BOOL CAccountView::PreCreateWindow(CREATESTRUCT& cs)
{
	cs.style &= ~(WS_VSCROLL | WS_HSCROLL);
	return CFormView::PreCreateWindow(cs);
}

void CAccountView::RenameAccount(LPCTSTR org, LPCTSTR dst)
{
	CPochyApp* app = (CPochyApp*)AfxGetApp();
	int index = m_combo_account.FindStringExact(-1, org);
	m_combo_account.DeleteString(index);
	m_combo_account.InsertString(index, dst); // after addstring adding something, data must be sorted.

	m_data[index].account_name = dst;
	m_data[index].button_fetchmail = TRUE;
	m_data[index].button_setting = TRUE;
	m_data[index].button_retrieve = TRUE;
	m_data[index].status_pgbar_current = 0;
	m_data[index].status_pgbar_upper = 100;
	m_data[index].status_text = "";
	m_data[index].is_fetching = FALSE;
	m_data[index].pop_pass = _T("");
	m_data[index].smtp_auth_pass = _T("");

	CMainFrame *mf = (CMainFrame*)app->m_pMainWnd;
	mf->m_pTreeV->RenameUser(org, dst);
	SelectAccount(index);
}

void CAccountView::CreateNewAccount(LPCTSTR name)
{
	CPochyApp *app = (CPochyApp*)AfxGetApp();

	_mkdir(app->m_app_path+"\\"+name);
	_mkdir(app->m_app_path+"\\"+name+"\\inbox");
	_mkdir(app->m_app_path+"\\"+name+"\\outbox");
	_mkdir(app->m_app_path+"\\"+name+"\\draft");
	_mkdir(app->m_app_path+"\\"+name+"\\trash");

	g_file_create(app->m_app_path+"\\"+name+"\\list");
	g_file_create(app->m_app_path+"\\"+name+"\\inbox\\list");
	g_file_create(app->m_app_path+"\\"+name+"\\outbox\\list");
	g_file_create(app->m_app_path+"\\"+name+"\\draft\\list");
	g_file_create(app->m_app_path+"\\"+name+"\\trash\\list");
	g_file_create(app->m_app_path+"\\"+name+"\\account.ini");

	CString message;
	ACCOUNT_STRUCT as;
	int index = m_combo_account.AddString(name);
	switch(index){
	case CB_ERR:
		message.Format("%s̏擾ɃG[܂", name);
		AfxMessageBox(message);
		return;
	case CB_ERRSPACE:
		message.Format("%d̏擾ɃȂȂ܂", name);
		AfxMessageBox(message);
		return;
	}
	if(m_combo_account.SetItemData(index, index) == CB_ERR){
		message.Format("%s̏擾ɃG[܂", name);
		AfxMessageBox(message);
		return;
	}else{
		as.account_name = name;
		as.button_fetchmail = TRUE;
		as.button_setting = TRUE;
		as.button_retrieve = TRUE;
		as.status_pgbar_current = 0;
		as.status_pgbar_upper = 100;
		as.status_text = "";
		as.is_fetching = FALSE;
		m_data.Add(as);
	}
	SelectAccount(index);
}

int CAccountView::GetAccountNum(LPCTSTR account)
{
	CString tmp = account;
	int max = m_data.GetSize();
	for(int i=0; i<max; i++){
		if(tmp == m_data[i].account_name)
			return i;
	}
	return -1;
}

void CAccountView::SetStatusBarProgress(int current, int upper, LPCTSTR account)
{
	CPochyApp* app = (CPochyApp*)AfxGetApp();
	CMainFrame *mf = (CMainFrame*)app->m_pMainWnd;
	CString tmp = account;

	if(m_account == tmp){
		mf->SetStatusBarProgress(current, upper);
	}
	m_data[GetAccountNum(account)].status_pgbar_current = current;
	m_data[GetAccountNum(account)].status_pgbar_upper = upper;
}

void CAccountView::SetStatusBarText(LPCSTR text, LPCTSTR account)
{
	CPochyApp* app = (CPochyApp*)AfxGetApp();
	CMainFrame *mf = (CMainFrame*)app->m_pMainWnd;
	CString tmp = account;

	if(m_account == tmp){
		mf->SetStatusBarText(0, text);
	}
	m_data[GetAccountNum(account)].status_text = text;
}

char* CAccountView::GetCurrentAccountName()
{
	if (m_index >= 0 && m_index < m_data.GetSize())
	{
		return m_data[m_index].account_name.GetBuffer(0);
	}
	return NULL;
}

BOOL CAccountView::IsFetching(LPCTSTR account_name)
{
	CString account = account_name;
	int index = GetAccountNum(account);
	return m_data[index].is_fetching;
}

void CAccountView::SetFetchStatus(LPCTSTR account_name, BOOL status)
{
	CString account = account_name;
	int index = GetAccountNum(account);
	m_data[index].is_fetching = status;
}

BOOL CAccountView::GetButtonStatus(LPCTSTR account, int id)
{
/*
	ID_DRAFT, TBSTYLE_BUTTON
	ID_FETCH_MAIL, TBSTYLE_BUTTON
	ID_REPLY, TBSTYLE_BUTTON
	ID_TRANSFER, TBSTYLE_BUTTON
	ID_ADDRESS, TBSTYLE_BUTTON
	ID_GPG, TBSTYLE_BUTTON
	ID_RETRIEVE, TBSTYLE_BUTTON
	ID_SETTING, TBSTYLE_BUTTON
	ID_ALL_HEADER, TBSTYLE_BUTTON
  */
	CString account_name = account;
	int index = this->GetAccountNum(account_name);
	switch(id){
	case ID_DRAFT:
		return TRUE;
	case ID_FETCH_MAIL:
		return m_data[index].button_fetchmail;
	case ID_REPLY:
		return TRUE;
	case ID_TRANSFER:
		return TRUE;
	case ID_ADDRESS:
		return TRUE;
	case ID_GPG:
		return TRUE;
	case ID_RETRIEVE:
		return m_data[index].button_retrieve;
	case ID_SETTING:
		return m_data[index].button_setting;
	case ID_INFO:
		return TRUE;
	default:
		return TRUE;
	}
}

void CAccountView::SetButtonStatus(LPCTSTR account, int id, BOOL status)
{
	CString account_name = account;
	int index = this->GetAccountNum(account_name);

	switch(id){
	case ID_DRAFT:
		break;
	case ID_FETCH_MAIL:
		m_data[index].button_fetchmail = status;
		break;
	case ID_REPLY:
		break;
	case ID_TRANSFER:
		break;
	case ID_ADDRESS:
		break;
	case ID_GPG:
		break;
	case ID_RETRIEVE:
		m_data[index].button_retrieve = status;
		break;
	case ID_SETTING:
		m_data[index].button_setting = status;
	case ID_INFO:
		break;
//	case ID_FILTER:
//		m_data[index].button_filter = status;
	default:
		break;
	}
}

CString CAccountView::GetFirstAccountName()
{
	CString account;
	m_combo_account.GetLBText(0, account);

	return account;
}

CString CAccountView::GetPopPass(LPCTSTR account)
{
	int index = GetAccountNum(account);
	return m_data[index].pop_pass;
}

CString CAccountView::GetSmtpAuthPass(LPCTSTR account)
{
	int index = GetAccountNum(account);
	return m_data[index].smtp_auth_pass;
}

void CAccountView::SetPopPass(LPCTSTR account, LPCTSTR pass)
{
	int index = GetAccountNum(account);
	m_data[index].pop_pass = pass;
}

void CAccountView::SetSmtpAuthPass(LPCTSTR account, LPCTSTR pass)
{
	int index = GetAccountNum(account);
	m_data[index].smtp_auth_pass = pass;
}

void CAccountView::OnNextAccount()
{
	int nAccountCount = m_combo_account.GetCount();
	int nCurSel = m_combo_account.GetCurSel();
	int nSelect = 0;

	if (nCurSel < nAccountCount - 1)
	{
		nSelect = nCurSel + 1;
	}

	if (nSelect != nCurSel)
	{
		SelectAccount(nSelect);
	}
}

void CAccountView::OnPrevAccount()
{
	int nAccountCount = m_combo_account.GetCount();
	int nCurSel = m_combo_account.GetCurSel();
	int nSelect = nAccountCount - 1;

	if (nCurSel > 0)
	{
		nSelect = nCurSel - 1;
	}

	if (nSelect != nCurSel)
	{
		SelectAccount(nSelect);
	}
}

void CAccountView::SelectAccount(const int &nIndex)
{
	if (0 <= nIndex && nIndex < m_combo_account.GetCount())
	{
		m_combo_account.SetCurSel(nIndex);
		OnSelchangeAccount();
	}
}

BOOL CAccountView::IsAnyAccountFetching()
{
	int max = m_data.GetSize();
	for(int i=0; i<max; i++){
		if(m_data[i].is_fetching)
			return TRUE;
	}
	return FALSE;
}
