#if !defined(AFX_MOOLISTVIEW_H__B0C245D6_42EA_11D5_B88C_00008659960F__INCLUDED_)
#define AFX_MOOLISTVIEW_H__B0C245D6_42EA_11D5_B88C_00008659960F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// SummaryView.h : wb_[ t@C
//
#include <afxcview.h>
#include <afxtempl.h>	// CArrayev[gNXɕKv
#include "ListStackStruct.h"
#include "BitmapListView.h"

#define SMRY_COLUMN_FROM (0)
#define SMRY_COLUMN_TO (1)
#define SMRY_STATUS_NEW (0)
#define SMRY_STATUS_NONE (1)

/////////////////////////////////////////////////////////////////////////////
// CSummaryView r[

class CSummaryView : public CBitmapListView
{
protected:
	CSummaryView();	// IɎgpveNg RXgN^
	DECLARE_DYNCREATE(CSummaryView)

// Agr[g
public:

	BOOL m_status_changed; // variavle of whether or not mail status is changed
	CString m_path; // path of currently selected mail
	CListStackList m_array_list; // array list for ListStack

private:
	int m_index;
	int m_stack_num;
	int m_unread;
	int SetStack(LPCTSTR path);

	CImageList m_IconImage;
	CFont m_cReadFont;
	CFont m_cUnreadFont;

	bool m_bIconUsed;

	int m_IconImageHeight;
	int m_IconImageWidth;
	int m_ReadFontHeight;
	int m_UnreadFontHeight;

	COLORREF m_colReadText;
	COLORREF m_colReadBk;
	COLORREF m_colUnreadText;
	COLORREF m_colUnreadBk;
	COLORREF m_colSelectText;
	COLORREF m_colSelectBk;

// Iy[V
public:
	void CSummaryView::GetSelectedMail(CUIntArray &index_array);
	void Clear();
	void MoveMail(CUIntArray &index_array, CString to, int what_kind_box);
	void ClearAllMail(LPCTSTR path);
	void ReBuildSummary(CString path, int mode);
	void SetColumnOrderStatus(int status);
	void QuickSort(int start, int end, int item_num, int order);
	void QuickSortSwapStack(int i, int j);
	int QuickSortPartition(int start, int end, int item_num, int order);
	BOOL SaveMail(LPCTSTR path, CStringArray &mail, int mail_status, int what_kind_box, CString &ret_path);
	BOOL SaveMail(LPCTSTR path, CString mail, int mail_staus, int what_kind_box);
	BOOL MakeShortCut(LPCTSTR org_file_path, LPCTSTR dst_folder_path, int mail_status, int what_kind_box);
	void UpdateColumn(int flag);
	void AddList(SLISTSTACK *addlist);
	void SetItem(LPCTSTR path);
	void SetStatus(int nItem, LPCTSTR status);
	BOOL ClearStatus(int nItem);
	BOOL UnmarkStatus(int nItem);
	BOOL MarkDStatus(int nItem);
	void SelectNext();
	void SelectPrev();
	void DeleteMail(CUIntArray &index_array);
	void WriteList(); // write out m_array_list into list file

public:
	void SortWithRequiredCheck(int nColumn = -1, int nOrder = -1);
	void SetNoSortHeader(BOOL b);
	void SelectNextUnreadMail();
	int GetUnreadCount(const CString& strPath);
	void ReadIniColumnOrder();
	void WriteIniColumnOrder();
	void ReadIconImage(void);
	void UpdateSummaryView(void);
	void SetIconUsed(bool bUsed);
	void SetReadFont(const LOGFONT* lpLogFont);
	void SetUnreadFont(const LOGFONT* lpLogFont);
	void SetReadTextColor(COLORREF colColor);
	void SetReadBkColor(COLORREF colColor);
	void SetUnreadTextColor(COLORREF colColor);
	void SetUnreadBkColor(COLORREF colColor);
	void SetSelectTextColor(COLORREF colColor);
	void SetSelectBkColor(COLORREF colColor);
//2005/07/14 move kondou start
	void RedrawUnreadCount();
//2005/07/14 move kondou end
//2005/07/14 move kondou start
	void SaveUnreadCount(const CString& strPath, const int nUnread, const int nStack);
//2005/07/14 move kondou end	
	BOOL GetStatusChanged();
	void SetStatusChanged(BOOL status);
	int  GetStackNum();
	void SetStackNum(int stack_num);
	int  GetIndex();
	void SetIndex(int index);
	
private:
	int MakeCommaNumber(LPCTSTR lpszSrc, LPTSTR lpNumberStr, int cchNumber);
	void Sort(int nColumn = -1, int nOrder = -1);
	bool IsSortRequired(const CString& strPath = _T(""));
	void SetSortRequired(const CString& strPath = _T(""), bool bSortRequired = false);
	void SelectItem(const int& nSelect);
//2005/07/14 move kondou start
//	void RedrawUnreadCount();
//2005/07/14 move kondou end
	int CalcUnreadCount(const CString& strPath);
//2005/07/14 move kondou start
//	void SaveUnreadCount(const CString& strPath, const int nUnread, const int nStack);
//2005/07/14 move kondou end	
	LPCTSTR MakeShortString(CDC* pDC, LPCTSTR lpszLong, int nColumnLen, int nOffset);
	void RepaintSelectedItems(void);
	COLORREF ReadIniColor(LPCTSTR lpszKeyName, COLORREF colDefault);
	bool ReadIniFont(LPCTSTR lpszKeyName, LOGFONT* lpLogFont);

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B

	//{{AFX_VIRTUAL(CSummaryView)
	public:
	virtual void OnInitialUpdate();
	virtual BOOL OnChildNotify(UINT message, WPARAM wParam, LPARAM lParam, LRESULT* pLResult);
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void OnDraw(CDC* pDC);	// ̃r[`悷邽߂ɃI[o[Ch܂B
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void MeasureItem(LPMEASUREITEMSTRUCT lpMeasureItemStruct);
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Cve[V
protected:
	virtual ~CSummaryView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// ꂽbZ[W }bv֐
protected:
	//{{AFX_MSG(CSummaryView)
	afx_msg void OnGetdispinfo(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDblclk(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnBegindrag(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnColumnclick(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnRclick(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnPopupDel();
	afx_msg void OnPopupHeaderInfo();
	afx_msg void OnPopupRawmailInfo();
	afx_msg void OnPopupRebuild();
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnNextMail();
	afx_msg void OnPrevMail();
	afx_msg void OnNextUnreadMail();
	afx_msg LRESULT OnSendMailThreadCommand(WPARAM wParam, LPARAM lParam);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_MOOLISTVIEW_H__B0C245D6_42EA_11D5_B88C_00008659960F__INCLUDED_)
