// MimeDecode.h: CMimeDecode NX̃C^[tFCX
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MIMEDECODE_H__F4358FA3_7996_4994_B5AA_9A8A9845626B__INCLUDED_)
#define AFX_MIMEDECODE_H__F4358FA3_7996_4994_B5AA_9A8A9845626B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "HeaderInfo.h"

class CMimeDecode
{
public:
	CString GetCharSet();
	BOOL IsPgpMime();
	void Initialize();
	CHeaderInfo m_hi;
	BOOL DoIt(CString path);
	BOOL DoIt2(CString mail);
	BOOL IsMultipart();
	int HowManyPart();
	int GetEncodingType(int part);
	CString GetFileName(int part);
	CString GetContentType(int part);
	CString GetMultipartType(); // multipart̎ނԂ mixed altanativeimultipartoȂꍇ͋CStringԂ
	CString GetRawCT(int part);
	CString GetRawCD(int part);
	CString GetRawCTE(int part);
	void GetBody(int part, CStringArray &dst);
	CMimeDecode();
	virtual ~CMimeDecode();

protected:
	BOOL AnalyzeMultiPart(int start, CString boundary);
	BOOL GetHeaderEndPoint(CStringArray &mail, int &p);
	struct MULTIPART_STRUCT
	{
		int start;				// t@Cmultipart̎n܂Ƃ
		int end;				// IƂ
		int end_header;			// multipart̃wb_̏IƂ
		CString boundary;		// p[gqȂboudary͋ł͂Ȃ
		CString name;			// Ytt@C̖O
		CString	content_type;	// text/plain text/html Ƃ
		int encoding_type;		// 7bit 8bit bin base64 quoted-printable Ƃ
		CString raw_content_type;
		CString raw_content_transfer_encoding;
		CString raw_content_disposition;
	};
	CArray<MULTIPART_STRUCT, MULTIPART_STRUCT> m_data;
	CStringArray m_mail;
};

#endif // !defined(AFX_MIMEDECODE_H__F4358FA3_7996_4994_B5AA_9A8A9845626B__INCLUDED_)
