/*
 * MIME mail decoding.
 *
 * This module contains decoding routines for converting
 * quoted-printable data into pure 8-bit data, in MIME
 * formatted messages.
 *
 * By Henrik Storner <storner@image.dk>
 *
 * Configuration file support for fetchmail 4.3.8 by
 * Frank Damgaard <frda@post3.tele.dk>
 *
 * For license terms, see the file COPYING in this directory.
 *
 * Modified by Shinji Hiranaka
 */

#include "stdafx.h"

unsigned char unhex(unsigned char c)
{
	if ((c >= '0') && (c <= '9'))
		return (c - '0');
	else if ((c >= 'A') && (c <= 'F'))
		return (c - 'A' + 10);
	else if ((c >= 'a') && (c <= 'f'))
		return (c - 'a' + 10);
	else
		return 16; /* invalid hex character */
}

int qp_char(unsigned char c1, unsigned char c2, unsigned char *c_out)
{
	c1 = unhex(c1);
	c2 = unhex(c2);

	if ((c1 > 15) || (c2 > 15))
		return 1;
	else {
		*c_out = 16*c1+c2;
		return 0;
	}
}

int fromQPtobits(char *out, char *in, int maxlen)
{	
	int len = 0;

	do
	{
		if(*in == '_'){
			*out = ' ';
			in++;
			out++; len++;
			continue;
		}
		if(*in == '='){
			if(qp_char(*(in+1), *(in+2), (unsigned char *)out) == 0){
				in += 3;
				out++; len++;
				continue;
			}
			else if(*(in+1) == '\r' && *(in+2) == '\n'){
				in += 3;
				continue;
			}
		}
		*out = *in;
		in++;
		out++; len++;
	}while
		(*in);

	*out = '\0';
	return len;
}
