// NotifyIcon class - Copyright(C) 2003 minamina
//
// ^XNgCACR⏕NX
// Initialize  Set nŕKvȏZbg
// Add, Delete, Modify ֐Ń^XNgCACR𑀍
// ACR\[X͎ō폜
//
//////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include <assert.h>
#include "NotifyIcon.h"

#define NOTIFYICON_ID (0)

CNotifyIcon::CNotifyIcon()
{
	::ZeroMemory(&m_notifyIconData, sizeof(NOTIFYICONDATA));

	m_notifyIconData.cbSize = sizeof(NOTIFYICONDATA);
	m_notifyIconData.hWnd = NULL;
	m_notifyIconData.uID = NOTIFYICON_ID;
	m_notifyIconData.uFlags = NIF_ICON | NIF_MESSAGE | NIF_TIP;
	m_notifyIconData.uCallbackMessage = NULL;
	m_notifyIconData.hIcon = NULL;
	m_notifyIconData.szTip[0] = _T('\0');

	m_uTaskbarCreated = ::RegisterWindowMessage(_T("TaskbarCreated"));
	m_hInstance = NULL;
	m_bActive = false;
}

// ACR͎IɃ^XNgC폜ACR\[X폜
CNotifyIcon::~CNotifyIcon()
{
	Delete();
	DestroyIcon();
}

// 
// hInstance : \[XǂݍނƂK{
// hWnd : bZ[W𑗂EBhE
// uCallbackMessage : R[obNbZ[WB ) #define WM_USER_NOTIFYICON (WIN_APP + 100)
void CNotifyIcon::Initialize(HINSTANCE hInstance, HWND hWnd, UINT uCallbackMessage)
{
	SetHInstance(hInstance);
	SetWindow(hWnd);
	m_notifyIconData.uCallbackMessage = uCallbackMessage;
}

// ACR^XNgCɒǉ (݂̐ݒ)
bool CNotifyIcon::Add()
{
	assert(m_notifyIconData.hWnd != NULL);
	assert(m_notifyIconData.hIcon != NULL);

	if (!IsActive())
	{
		m_bActive = ::Shell_NotifyIcon(NIM_ADD, &m_notifyIconData) != FALSE;
	}
	return (m_bActive);
}

// ACR^XNgCɒǉ (\[X)
bool CNotifyIcon::AddIcon(WORD wResourceID)
{
	SetIcon(wResourceID);
	return Add();
}

// ACR^XNgCɒǉ (t@C)
bool CNotifyIcon::AddIcon(LPCTSTR lpszFilename)
{
	SetIcon(lpszFilename);
	return Add();
}

// ACR^XNgC폜 (݂̐ݒ)
bool CNotifyIcon::Delete()
{
	assert(IsActive());
	assert(m_notifyIconData.hWnd != NULL);
	assert(m_notifyIconData.hIcon != NULL);

	m_bActive = false;
	return (::Shell_NotifyIcon(NIM_DELETE, &m_notifyIconData) != FALSE);
}

// ^XNgCACRύX (݂̐ݒ)
bool CNotifyIcon::Modify()
{
	assert(IsActive());
	assert(m_notifyIconData.hWnd != NULL);
	assert(m_notifyIconData.hIcon != NULL);

	return (::Shell_NotifyIcon(NIM_MODIFY, &m_notifyIconData) != FALSE);
}

// ^XNgCACRύX (\[X)
bool CNotifyIcon::ModifyIcon(WORD wResourceID)
{
	assert(m_hInstance != NULL);

	SetIcon(wResourceID);
	return Modify();
}

// ^XNgCACRύX (t@C)
bool CNotifyIcon::ModifyIcon(LPCTSTR lpszFilename)
{
	SetIcon(lpszFilename);
	return Modify();
}

// ^XNgCACR̃c[`bvύX (\[X)
bool CNotifyIcon::ModifyTip(WORD wResourceID)
{
	SetTip(wResourceID);
	return Modify();
}

// ^XNgCACR̃c[`bvύX (񂩂)
bool CNotifyIcon::ModifyTip(LPCTSTR lpszTip)
{
	SetTip(lpszTip);
	return Modify();
}

// ACR\[X폜
void CNotifyIcon::DestroyIcon()
{
	if (m_notifyIconData.hIcon != NULL)
	{
		::DestroyIcon(m_notifyIconData.hIcon);
		m_notifyIconData.hIcon = NULL;
	}
}

// bZ[WMEBhEw
void CNotifyIcon::SetWindow(HWND hWnd)
{
	assert(hWnd != NULL);

	m_notifyIconData.hWnd = hWnd;
}

// ACR ID w
// ɓo^ς݂̂Ƃ ID ςƍ폜łȂȂĂ܂̂
// ύXO Delete Ăł
void CNotifyIcon::SetID(UINT uID)
{
	if (IsActive())
	{
		Delete();
	}
	m_notifyIconData.uID = uID;
}

// ACR ID 擾
UINT CNotifyIcon::GetID()
{
	return m_notifyIconData.uID;
}

// \[X擾郂W[ HINSTANCE w
void CNotifyIcon::SetHInstance(HINSTANCE hInstance)
{
	m_hInstance = hInstance;
}

// ACRݒ (\[X)
bool CNotifyIcon::SetIcon(WORD wResourceID)
{
	assert(m_hInstance != NULL);

	DestroyIcon();

	m_notifyIconData.hIcon = (HICON)::LoadImage(m_hInstance, MAKEINTRESOURCE(wResourceID), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);

	return (m_notifyIconData.hIcon != NULL);
}

// ACRݒ (t@C)
bool CNotifyIcon::SetIcon(LPCTSTR lpszFilename)
{
	DestroyIcon();

	m_notifyIconData.hIcon = (HICON)::LoadImage(0, lpszFilename, IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR | LR_LOADFROMFILE);

	return (m_notifyIconData.hIcon != NULL);
}

// c[`bvݒ (\[X)
void CNotifyIcon::SetTip(WORD wResourceID)
{
	assert(m_hInstance != NULL);

	TCHAR tcBuffer[64];
	if (::LoadString(m_hInstance, wResourceID, tcBuffer, 64) > 0)
	{
		SetTip(tcBuffer);
	}
}

// c[`bvݒ (񂩂)
void CNotifyIcon::SetTip(LPCTSTR lpszTip)
{
	_tcsncpy(m_notifyIconData.szTip, lpszTip, 63);
	m_notifyIconData.szTip[63] = _T('\n');
}

// ^XNgCɃACR邩?
bool CNotifyIcon::IsActive()
{
	return m_bActive;
}
