/*
 * For license terms, see the file COPYING in this directory.
 */

////////////////////////////////////////////////////////////////////////////
//
// splitex.cpp
// (c) 1997, Oleg G. Galkin
//
//		2001.8 Modified by chik
//			added ShowRow() and HideRow()
//		2003.2 Modified by s.hiranaka
//			added SetStaticBorder() and m_static_border
//
////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "splitex.h"
#include "mainfrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

////////////////////////////////////////////////////////////////////////////
//
// CSplitterWndEx

CSplitterWndEx::CSplitterWndEx() :
    m_nHidedCol(-1)
{
	m_static_border = FALSE;
}

void CSplitterWndEx::ShowColumn()
{
	ASSERT_VALID(this);
	ASSERT(m_nCols < m_nMaxCols);
	ASSERT(m_nHidedCol != -1);

	int colNew = m_nHidedCol;
	m_nHidedCol = -1;
	int cxNew = m_pColInfo[m_nCols].nCurSize;
	m_nCols++;  // add a column
	ASSERT(m_nCols == m_nMaxCols);

	// fill the hided column
	int col;
	for (int row = 0; row < m_nRows; row++)
	{
		CWnd* pPaneShow = GetDlgItem(
			AFX_IDW_PANE_FIRST + row * 16 + m_nCols);
		ASSERT(pPaneShow != NULL);
		pPaneShow->ShowWindow(SW_SHOWNA);

		for (col = m_nCols - 2; col >= colNew; col--)
		{
			CWnd* pPane = GetPane(row, col);
			ASSERT(pPane != NULL);
			pPane->SetDlgCtrlID(IdFromRowCol(row, col + 1));
		}

		pPaneShow->SetDlgCtrlID(IdFromRowCol(row, colNew));
	}

	// new panes have been created -- recalculate layout
	for (col = colNew + 1; col < m_nCols; col++)
		m_pColInfo[col].nIdealSize = m_pColInfo[col - 1].nCurSize;
	m_pColInfo[colNew].nIdealSize = cxNew;
	RecalcLayout();
}

void CSplitterWndEx::HideColumn(int colHide)
{
	ASSERT_VALID(this);
	ASSERT(m_nCols > 1);
	ASSERT(colHide < m_nCols);
	ASSERT(m_nHidedCol == -1);
	m_nHidedCol = colHide;

	// if the column has an active window -- change it
	int rowActive, colActive;
	if(GetActivePane(&rowActive, &colActive) != NULL &&
		colActive == colHide)
	{
		if(++colActive >= m_nCols)
			colActive = 0;
		SetActivePane(rowActive, colActive);
	}

	// hide all column panes
	for (int row = 0; row < m_nRows; row++)
	{
		CWnd* pPaneHide = GetPane(row, colHide);
		ASSERT(pPaneHide != NULL);
		pPaneHide->ShowWindow(SW_HIDE);
		pPaneHide->SetDlgCtrlID(
			AFX_IDW_PANE_FIRST + row * 16 + m_nCols);

		for (int col = colHide + 1; col < m_nCols; col++)
		{
			CWnd* pPane = GetPane(row, col);
			ASSERT(pPane != NULL);
			pPane->SetDlgCtrlID(IdFromRowCol(row, col - 1));
		}
	}
	m_nCols--;
	m_pColInfo[m_nCols].nCurSize = m_pColInfo[colHide].nCurSize;
	RecalcLayout();
}

void CSplitterWndEx::ShowRow()
{
	ASSERT_VALID(this);
	ASSERT(m_nRows < m_nMaxRows);
	ASSERT(m_nHidedRow != -1);

	int rowNew = m_nHidedRow;
	m_nHidedRow = -1;
	int cxNew = m_pRowInfo[m_nRows].nCurSize;
	m_nRows++;  // add a row
	ASSERT(m_nRows == m_nMaxRows);

    // fill the hided column
	int row;
	for (int col = 0; col < m_nCols; col++)
	{
		CWnd* pPaneShow = GetDlgItem(
			AFX_IDW_PANE_FIRST + m_nRows * 16 + col);
		ASSERT(pPaneShow != NULL);
		pPaneShow->ShowWindow(SW_SHOWNA);

		for(row = m_nRows - 2; row >= rowNew; row--)
		{
			CWnd* pPane = GetPane(row, col);
			ASSERT(pPane != NULL);
			pPane->SetDlgCtrlID(IdFromRowCol(row +1, col));
		}

		pPaneShow->SetDlgCtrlID(IdFromRowCol(rowNew, col));
	}

	// new panes have been created -- recalculate layout
	for (row = rowNew + 1; row < m_nRows; row++)
		m_pRowInfo[row].nIdealSize = m_pRowInfo[row - 1].nCurSize;
	m_pRowInfo[rowNew].nIdealSize = cxNew;
	RecalcLayout();
}

void CSplitterWndEx::HideRow(int rowHide)
{
	ASSERT_VALID(this);
	ASSERT(m_nRows > 1);
	ASSERT(rowHide < m_nRows);
	ASSERT(m_nHidedCol == -1);
	m_nHidedRow = rowHide;

	// if the column has an active window -- change it
	int rowActive, colActive; 
	if(GetActivePane(&rowActive, &colActive) != NULL &&
		rowActive == rowHide)
	{
		if(++rowActive >= m_nRows)
			rowActive = 0;
		SetActivePane(rowActive, colActive);
	}

    // hide all column panes
	for (int col = 0; col < m_nCols; col++)
	{
		CWnd* pPaneHide = GetPane(rowHide, col);
		ASSERT(pPaneHide != NULL); 
		pPaneHide->ShowWindow(SW_HIDE);
		pPaneHide->SetDlgCtrlID(
			AFX_IDW_PANE_FIRST + m_nRows * 16 + col);

		for (int row = rowHide + 1; row < m_nRows; row++)
		{
			CWnd* pPane = GetPane(row, col);
			ASSERT(pPane != NULL);
			pPane->SetDlgCtrlID(IdFromRowCol(row -1, col));
		}
	}
	m_nRows--;
	m_pRowInfo[m_nRows].nCurSize = m_pRowInfo[rowHide].nCurSize;
	RecalcLayout();
}

BEGIN_MESSAGE_MAP(CSplitterWndEx, CSplitterWnd)
//{{AFX_MSG_MAP(CSplitterWndEx)
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CSplitterWndEx::OnMouseMove(UINT nFlags, CPoint point) 
{
	TRACE("%d,%d\n",point.x,point.y);
	if(!m_static_border)
		CSplitterWnd::OnMouseMove(nFlags, point);
}

void CSplitterWndEx::OnLButtonDown(UINT nFlags, CPoint point) 
{
	if(!m_static_border)
		CSplitterWnd::OnLButtonDown(nFlags, point);
}

void CSplitterWndEx::NoBorder()
{
	m_cxSplitter=0;//3;
	m_cySplitter=0;//3;
	m_cxBorderShare=0;
	m_cyBorderShare=0;
	m_cxSplitterGap=1;//3;
	m_cySplitterGap=1;//3;
}

void CSplitterWndEx::SetStaticBorder(BOOL b)
{
	m_static_border = b;
}
