/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.dev;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.LittleEndian;

public final class PPTXMLDump {
    public static final int HEADER_SIZE = 8;
    public static final int PICT_HEADER_SIZE = 25;
    public static final String PPDOC_ENTRY = "PowerPoint Document";
    public static final String PICTURES_ENTRY = "Pictures";
    public static String CR = System.getProperty("line.separator");
    protected Writer out;
    protected byte[] docstream;
    protected byte[] pictstream;
    protected boolean hexHeader = true;
    private static final byte[] hexval = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    public PPTXMLDump(File ppt) throws IOException {
        FileInputStream fis = new FileInputStream(ppt);
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)fis);
        fis.close();
        DocumentEntry entry = (DocumentEntry)fs.getRoot().getEntry(PPDOC_ENTRY);
        this.docstream = new byte[entry.getSize()];
        DocumentInputStream is = fs.createDocumentInputStream(PPDOC_ENTRY);
        is.read(this.docstream);
        try {
            entry = (DocumentEntry)fs.getRoot().getEntry(PICTURES_ENTRY);
            this.pictstream = new byte[entry.getSize()];
            is = fs.createDocumentInputStream(PICTURES_ENTRY);
            is.read(this.pictstream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void dump(Writer out) throws IOException {
        this.out = out;
        int padding = 0;
        PPTXMLDump.write(out, "<Presentation>" + CR, padding);
        ++padding;
        if (this.pictstream != null) {
            PPTXMLDump.write(out, "<Pictures>" + CR, padding);
            this.dumpPictures(this.pictstream, padding);
            PPTXMLDump.write(out, "</Pictures>" + CR, padding);
        }
        PPTXMLDump.write(out, "<PowerPointDocument>" + CR, padding);
        this.dump(this.docstream, 0, this.docstream.length, ++padding);
        PPTXMLDump.write(out, "</PowerPointDocument>" + CR, --padding);
        PPTXMLDump.write(out, "</Presentation>", --padding);
    }

    public void dump(byte[] data, int offset, int length, int padding) throws IOException {
        int pos = offset;
        while (pos <= offset + length - 8) {
            boolean isContainer;
            if (pos < 0) break;
            int info = LittleEndian.getUShort((byte[])data, (int)pos);
            int type = LittleEndian.getUShort((byte[])data, (int)(pos += 2));
            int size = (int)LittleEndian.getUInt((byte[])data, (int)(pos += 2));
            String recname = RecordTypes.recordName(type);
            PPTXMLDump.write(this.out, "<" + recname + " info=\"" + info + "\" type=\"" + type + "\" size=\"" + size + "\" offset=\"" + ((pos += 4) - 8) + "\"", padding);
            if (this.hexHeader) {
                this.out.write(" header=\"");
                PPTXMLDump.dump(this.out, data, pos - 8, 8, 0, false);
                this.out.write("\"");
            }
            this.out.write(">" + CR);
            ++padding;
            boolean bl = isContainer = (info & 0xF) == 15;
            if (isContainer) {
                this.dump(data, pos, size, padding);
            } else {
                PPTXMLDump.dump(this.out, data, pos, Math.min(size, data.length - pos), padding, true);
            }
            PPTXMLDump.write(this.out, "</" + recname + ">" + CR, --padding);
            pos += size;
        }
    }

    public void dumpPictures(byte[] data, int padding) throws IOException {
        int pos = 0;
        while (pos < data.length) {
            byte[] header = new byte[25];
            System.arraycopy(data, pos, header, 0, header.length);
            int size = LittleEndian.getInt((byte[])header, (int)4) - 17;
            byte[] pictdata = new byte[size];
            System.arraycopy(data, pos + 25, pictdata, 0, pictdata.length);
            pos += 25 + size;
            PPTXMLDump.write(this.out, "<picture size=\"" + size + "\" type=\"" + this.getPictureType(header) + "\">" + CR, ++padding);
            PPTXMLDump.write(this.out, "<header>" + CR, ++padding);
            PPTXMLDump.dump(this.out, header, 0, header.length, padding, true);
            PPTXMLDump.write(this.out, "</header>" + CR, padding);
            PPTXMLDump.write(this.out, "<imgdata>" + CR, padding);
            PPTXMLDump.dump(this.out, pictdata, 0, Math.min(pictdata.length, 100), padding, true);
            PPTXMLDump.write(this.out, "</imgdata>" + CR, padding);
            PPTXMLDump.write(this.out, "</picture>" + CR, --padding);
            --padding;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Usage: PPTXMLDump (options) pptfile\nWhere options include:\n    -f     write output to <pptfile>.xml file in the current directory");
            return;
        }
        boolean outFile = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-")) {
                if ("-f".equals(args[i])) {
                    outFile = true;
                }
            } else {
                Writer out;
                File ppt = new File(args[i]);
                PPTXMLDump dump = new PPTXMLDump(ppt);
                System.out.println("Dumping " + args[i]);
                if (outFile) {
                    out = new FileWriter(String.valueOf(ppt.getName()) + ".xml");
                    dump.dump(out);
                    ((OutputStreamWriter)out).close();
                } else {
                    out = new StringWriter();
                    dump.dump(out);
                    System.out.println(((StringWriter)out).toString());
                }
            }
            ++i;
        }
    }

    private static void write(Writer out, String str, int padding) throws IOException {
        int i = 0;
        while (i < padding) {
            out.write("  ");
            ++i;
        }
        out.write(str);
    }

    private String getPictureType(byte[] header) {
        String type;
        int meta = LittleEndian.getUShort((byte[])header, (int)0);
        switch (meta) {
            case 18080: {
                type = "jpeg";
                break;
            }
            case 8544: {
                type = "wmf";
                break;
            }
            case 28160: {
                type = "png";
                break;
            }
            default: {
                type = "unknown";
            }
        }
        return type;
    }

    private static void dump(Writer out, byte[] data, int offset, int length, int padding, boolean nl) throws IOException {
        int linesize = 25;
        int i = 0;
        while (i < padding) {
            out.write("  ");
            ++i;
        }
        i = offset;
        while (i < offset + length) {
            byte c = data[i];
            out.write((char)hexval[(c & 0xF0) >> 4]);
            out.write((char)hexval[(c & 0xF) >> 0]);
            out.write(32);
            if ((i + 1 - offset) % linesize == 0 && i != offset + length - 1) {
                out.write(CR);
                int j = 0;
                while (j < padding) {
                    out.write("  ");
                    ++j;
                }
            }
            ++i;
        }
        if (nl && length > 0) {
            out.write(CR);
        }
    }
}

