/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.PlexOfCps;
import org.apache.poi.hwpf.model.PropertyNode;
import org.apache.poi.hwpf.model.SEPX;
import org.apache.poi.hwpf.model.SectionDescriptor;
import org.apache.poi.hwpf.model.TextPieceTable;
import org.apache.poi.hwpf.model.io.HWPFFileSystem;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class SectionTable {
    private static final POILogger _logger;
    private static final int SED_SIZE = 12;
    protected ArrayList _sections = new ArrayList();
    protected List _text;
    private TextPieceTable tpt;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.hwpf.model.SectionTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _logger = POILogFactory.getLogger((Class)clazz);
    }

    public SectionTable() {
    }

    public SectionTable(byte[] documentStream, byte[] tableStream, int offset, int size, int fcMin, TextPieceTable tpt, int mainLength) {
        PlexOfCps sedPlex = new PlexOfCps(tableStream, offset, size, 12);
        this.tpt = tpt;
        this._text = tpt.getTextPieces();
        int length = sedPlex.length();
        int x = 0;
        while (x < length) {
            GenericPropertyNode node = sedPlex.getProperty(x);
            SectionDescriptor sed = new SectionDescriptor(node.getBytes(), 0);
            int fileOffset = sed.getFc();
            int startAt = node.getStart();
            int endAt = node.getEnd();
            if (fileOffset == -1) {
                this._sections.add(new SEPX(sed, startAt, endAt, new byte[0]));
            } else {
                short sepxSize = LittleEndian.getShort((byte[])documentStream, (int)fileOffset);
                byte[] buf = new byte[sepxSize];
                System.arraycopy(documentStream, fileOffset += 2, buf, 0, buf.length);
                this._sections.add(new SEPX(sed, startAt, endAt, buf));
            }
            ++x;
        }
        int mainEndsAt = mainLength;
        boolean matchAt = false;
        boolean matchHalf = false;
        int i = 0;
        while (i < this._sections.size()) {
            SEPX s = (SEPX)this._sections.get(i);
            if (s.getEnd() == mainEndsAt) {
                matchAt = true;
            } else if (s.getEnd() == mainEndsAt || s.getEnd() == mainEndsAt - 1) {
                matchHalf = true;
            }
            ++i;
        }
        if (!matchAt && matchHalf) {
            _logger.log(POILogger.WARN, (Object)"Your document seemed to be mostly unicode, but the section definition was in bytes! Trying anyway, but things may well go wrong!");
            i = 0;
            while (i < this._sections.size()) {
                SEPX s = (SEPX)this._sections.get(i);
                GenericPropertyNode node = sedPlex.getProperty(i);
                int startAt = node.getStart();
                int endAt = node.getEnd();
                s.setStart(startAt);
                s.setEnd(endAt);
                ++i;
            }
        }
        Collections.sort(this._sections, PropertyNode.StartComparator.instance);
    }

    public void adjustForInsert(int listIndex, int length) {
        int size = this._sections.size();
        SEPX sepx = (SEPX)this._sections.get(listIndex);
        sepx.setEnd(sepx.getEnd() + length);
        int x = listIndex + 1;
        while (x < size) {
            sepx = (SEPX)this._sections.get(x);
            sepx.setStart(sepx.getStart() + length);
            sepx.setEnd(sepx.getEnd() + length);
            ++x;
        }
    }

    public ArrayList getSections() {
        return this._sections;
    }

    public void writeTo(HWPFFileSystem sys, int fcMin) throws IOException {
        HWPFOutputStream docStream = sys.getStream("WordDocument");
        HWPFOutputStream tableStream = sys.getStream("1Table");
        this.writeTo(docStream, tableStream);
    }

    public void writeTo(HWPFOutputStream wordDocumentStream, HWPFOutputStream tableStream) throws IOException {
        int offset = wordDocumentStream.getOffset();
        int len = this._sections.size();
        PlexOfCps plex = new PlexOfCps(12);
        int x = 0;
        while (x < len) {
            SEPX sepx = (SEPX)this._sections.get(x);
            byte[] grpprl = sepx.getGrpprl();
            byte[] shortBuf = new byte[2];
            LittleEndian.putShort((byte[])shortBuf, (short)((short)grpprl.length));
            wordDocumentStream.write(shortBuf);
            wordDocumentStream.write(grpprl);
            SectionDescriptor sed = sepx.getSectionDescriptor();
            sed.setFc(offset);
            GenericPropertyNode property = new GenericPropertyNode(sepx.getStart(), sepx.getEnd(), sed.toByteArray());
            plex.addProperty(property);
            offset = wordDocumentStream.getOffset();
            ++x;
        }
        tableStream.write(plex.toByteArray());
    }
}

