/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.model.geom;

import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.xslf.model.geom.CustomGeometry;
import org.apache.poi.xslf.model.geom.Formula;
import org.apache.poi.xslf.model.geom.Guide;
import org.apache.poi.xslf.model.geom.IAdjustableShape;

public class Context {
    final Map _ctx = new HashMap();
    final IAdjustableShape _props;
    final Rectangle2D _anchor;

    public Context(CustomGeometry geom, Rectangle2D anchor, IAdjustableShape props) {
        Guide gd;
        this._props = props;
        this._anchor = anchor;
        Iterator iterator = geom.adjusts.iterator();
        while (iterator.hasNext()) {
            gd = (Guide)iterator.next();
            this.evaluate(gd);
        }
        iterator = geom.guides.iterator();
        while (iterator.hasNext()) {
            gd = (Guide)iterator.next();
            this.evaluate(gd);
        }
    }

    public Rectangle2D getShapeAnchor() {
        return this._anchor;
    }

    public Guide getAdjustValue(String name) {
        return this._props.getAdjustValue(name);
    }

    public double getValue(String key) {
        if (key.matches("(\\+|-)?\\d+")) {
            return Double.parseDouble(key);
        }
        Formula builtIn = (Formula)Formula.builtInFormulas.get(key);
        if (builtIn != null) {
            return builtIn.evaluate(this);
        }
        if (!this._ctx.containsKey(key)) {
            throw new RuntimeException("undefined variable: " + key);
        }
        return (Double)this._ctx.get(key);
    }

    public double evaluate(Formula fmla) {
        double result = fmla.evaluate(this);
        String key = fmla.getName();
        if (key != null) {
            this._ctx.put(key, new Double(result));
        }
        return result;
    }
}

