/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLException;
import org.apache.poi.hssf.record.PasswordRecord;
import org.apache.poi.hssf.util.PaneInformation;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.PartAlreadyExistsException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.FormulaShifter;
import org.apache.poi.ss.usermodel.AutoFilter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellRange;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.ss.util.SSCellRange;
import org.apache.poi.ss.util.SheetUtil;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.usermodel.XSSFAutoFilter;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFEvenFooter;
import org.apache.poi.xssf.usermodel.XSSFEvenHeader;
import org.apache.poi.xssf.usermodel.XSSFFactory;
import org.apache.poi.xssf.usermodel.XSSFFirstFooter;
import org.apache.poi.xssf.usermodel.XSSFFirstHeader;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFName;
import org.apache.poi.xssf.usermodel.XSSFOddFooter;
import org.apache.poi.xssf.usermodel.XSSFOddHeader;
import org.apache.poi.xssf.usermodel.XSSFPrintSetup;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheetConditionalFormatting;
import org.apache.poi.xssf.usermodel.XSSFTable;
import org.apache.poi.xssf.usermodel.XSSFVMLDrawing;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.helpers.ColumnHelper;
import org.apache.poi.xssf.usermodel.helpers.XSSFRowShifter;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.officeDocument.x2006.relationships.STRelationshipId;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTAutoFilter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBreak;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellFormula;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCol;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCols;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTComment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCommentList;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDataValidation;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDataValidations;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTHeaderFooter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTLegacyDrawing;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTMergeCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTMergeCells;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTOutlinePr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPageBreak;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPageMargins;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPageSetUpPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPane;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPrintOptions;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRow;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSelection;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetCalcPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetFormatPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetProtection;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetView;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetViews;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTablePart;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableParts;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCellFormulaType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPane;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPaneState;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STUnsignedShortHex;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.WorksheetDocument;

public class XSSFSheet
extends POIXMLDocumentPart
implements Sheet {
    private static final POILogger logger;
    protected CTSheet sheet;
    protected CTWorksheet worksheet;
    private TreeMap _rows;
    private List hyperlinks;
    private ColumnHelper columnHelper;
    private CommentsTable sheetComments;
    private Map sharedFormulas;
    private TreeMap tables;
    private List arrayFormulas;
    private XSSFDataValidationHelper dataValidationHelper = new XSSFDataValidationHelper(this);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.xssf.usermodel.XSSFSheet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = POILogFactory.getLogger((Class)clazz);
    }

    protected XSSFSheet() {
        this.onDocumentCreate();
    }

    protected XSSFSheet(PackagePart part, PackageRelationship rel) {
        super(part, rel);
    }

    public Workbook getWorkbook() {
        return (XSSFWorkbook)this.getParent();
    }

    protected void onDocumentRead() {
        try {
            this.read(this.getPackagePart().getInputStream());
        }
        catch (IOException e) {
            throw new POIXMLException(e);
        }
    }

    protected void read(InputStream is) throws IOException {
        try {
            this.worksheet = WorksheetDocument.Factory.parse((InputStream)is).getWorksheet();
        }
        catch (XmlException e) {
            throw new POIXMLException(e);
        }
        this.initRows(this.worksheet);
        this.columnHelper = new ColumnHelper(this.worksheet);
        Iterator iterator = this.getRelations().iterator();
        while (iterator.hasNext()) {
            POIXMLDocumentPart p = (POIXMLDocumentPart)iterator.next();
            if (p instanceof CommentsTable) {
                this.sheetComments = (CommentsTable)p;
                break;
            }
            if (!(p instanceof XSSFTable)) continue;
            this.tables.put(p.getPackageRelationship().getId(), (XSSFTable)p);
        }
        this.initHyperlinks();
    }

    protected void onDocumentCreate() {
        this.worksheet = XSSFSheet.newSheet();
        this.initRows(this.worksheet);
        this.columnHelper = new ColumnHelper(this.worksheet);
        this.hyperlinks = new ArrayList();
    }

    private void initRows(CTWorksheet worksheet) {
        this._rows = new TreeMap();
        this.tables = new TreeMap();
        this.sharedFormulas = new HashMap();
        this.arrayFormulas = new ArrayList();
        int i = 0;
        while (i < worksheet.getSheetData().getRowArray().length) {
            CTRow row = worksheet.getSheetData().getRowArray()[i];
            XSSFRow r = new XSSFRow(row, this);
            this._rows.put(new Integer(r.getRowNum()), r);
            ++i;
        }
    }

    private void initHyperlinks() {
        this.hyperlinks = new ArrayList();
        if (!this.worksheet.isSetHyperlinks()) {
            return;
        }
        try {
            PackageRelationshipCollection hyperRels = this.getPackagePart().getRelationshipsByType(XSSFRelation.SHEET_HYPERLINKS.getRelation());
            int i = 0;
            while (i < this.worksheet.getHyperlinks().getHyperlinkArray().length) {
                CTHyperlink hyperlink = this.worksheet.getHyperlinks().getHyperlinkArray()[i];
                PackageRelationship hyperRel = null;
                if (hyperlink.getId() != null) {
                    hyperRel = hyperRels.getRelationshipByID(hyperlink.getId());
                }
                this.hyperlinks.add(new XSSFHyperlink(hyperlink, hyperRel));
                ++i;
            }
        }
        catch (InvalidFormatException e) {
            throw new POIXMLException(e);
        }
    }

    private static CTWorksheet newSheet() {
        CTWorksheet worksheet = CTWorksheet.Factory.newInstance();
        CTSheetFormatPr ctFormat = worksheet.addNewSheetFormatPr();
        ctFormat.setDefaultRowHeight(15.0);
        CTSheetView ctView = worksheet.addNewSheetViews().addNewSheetView();
        ctView.setWorkbookViewId(0L);
        worksheet.addNewDimension().setRef("A1");
        worksheet.addNewSheetData();
        CTPageMargins ctMargins = worksheet.addNewPageMargins();
        ctMargins.setBottom(0.75);
        ctMargins.setFooter(0.3);
        ctMargins.setHeader(0.3);
        ctMargins.setLeft(0.7);
        ctMargins.setRight(0.7);
        ctMargins.setTop(0.75);
        return worksheet;
    }

    public CTWorksheet getCTWorksheet() {
        return this.worksheet;
    }

    public ColumnHelper getColumnHelper() {
        return this.columnHelper;
    }

    public String getSheetName() {
        return this.sheet.getName();
    }

    public int addMergedRegion(CellRangeAddress region) {
        region.validate(SpreadsheetVersion.EXCEL2007);
        this.validateArrayFormulas(region);
        CTMergeCells ctMergeCells = this.worksheet.isSetMergeCells() ? this.worksheet.getMergeCells() : this.worksheet.addNewMergeCells();
        CTMergeCell ctMergeCell = ctMergeCells.addNewMergeCell();
        ctMergeCell.setRef(region.formatAsString());
        return ctMergeCells.sizeOfMergeCellArray();
    }

    private void validateArrayFormulas(CellRangeAddress region) {
        int firstRow = region.getFirstRow();
        int firstColumn = region.getFirstColumn();
        int lastRow = region.getLastRow();
        int lastColumn = region.getLastColumn();
        int rowIn = firstRow;
        while (rowIn <= lastRow) {
            int colIn = firstColumn;
            while (colIn <= lastColumn) {
                CellRangeAddress arrayRange;
                XSSFCell cell;
                XSSFRow row = (XSSFRow)this.getRow(rowIn);
                if (row != null && (cell = (XSSFCell)row.getCell(colIn)) != null && cell.isPartOfArrayFormulaGroup() && (arrayRange = cell.getArrayFormulaRange()).getNumberOfCells() > 1 && (arrayRange.isInRange(region.getFirstRow(), region.getFirstColumn()) || arrayRange.isInRange(region.getFirstRow(), region.getFirstColumn()))) {
                    String msg = "The range " + region.formatAsString() + " intersects with a multi-cell array formula. " + "You cannot merge cells of an array.";
                    throw new IllegalStateException(msg);
                }
                ++colIn;
            }
            ++rowIn;
        }
    }

    public void autoSizeColumn(int column) {
        this.autoSizeColumn(column, false);
    }

    public void autoSizeColumn(int column, boolean useMergedCells) {
        double width = SheetUtil.getColumnWidth((Sheet)this, (int)column, (boolean)useMergedCells);
        if (width != -1.0) {
            int maxColumnWidth = 65280;
            if ((width *= 256.0) > (double)maxColumnWidth) {
                width = maxColumnWidth;
            }
            this.setColumnWidth(column, (int)width);
            this.columnHelper.setColBestFit(column, true);
        }
    }

    public Drawing createDrawingPatriarch() {
        XSSFDrawing drawing = null;
        CTDrawing ctDrawing = this.getCTDrawing();
        if (ctDrawing == null) {
            int drawingNumber = this.getPackagePart().getPackage().getPartsByContentType(XSSFRelation.DRAWINGS.getContentType()).size() + 1;
            drawing = (XSSFDrawing)this.createRelationship(XSSFRelation.DRAWINGS, XSSFFactory.getInstance(), drawingNumber);
            String relId = drawing.getPackageRelationship().getId();
            ctDrawing = this.worksheet.addNewDrawing();
            ctDrawing.setId(relId);
        } else {
            Iterator iterator = this.getRelations().iterator();
            while (iterator.hasNext()) {
                POIXMLDocumentPart p = (POIXMLDocumentPart)iterator.next();
                if (!(p instanceof XSSFDrawing)) continue;
                XSSFDrawing dr = (XSSFDrawing)p;
                String drId = dr.getPackageRelationship().getId();
                if (!drId.equals(ctDrawing.getId())) break;
                drawing = dr;
                break;
            }
            if (drawing == null) {
                logger.log(POILogger.ERROR, (Object)("Can't find drawing with id=" + ctDrawing.getId() + " in the list of the sheet's relationships"));
            }
        }
        return drawing;
    }

    protected XSSFVMLDrawing getVMLDrawing(boolean autoCreate) {
        XSSFVMLDrawing drawing = null;
        CTLegacyDrawing ctDrawing = this.getCTLegacyDrawing();
        if (ctDrawing == null) {
            if (autoCreate) {
                int drawingNumber = this.getPackagePart().getPackage().getPartsByContentType(XSSFRelation.VML_DRAWINGS.getContentType()).size() + 1;
                drawing = (XSSFVMLDrawing)this.createRelationship(XSSFRelation.VML_DRAWINGS, XSSFFactory.getInstance(), drawingNumber);
                String relId = drawing.getPackageRelationship().getId();
                ctDrawing = this.worksheet.addNewLegacyDrawing();
                ctDrawing.setId(relId);
            }
        } else {
            Iterator iterator = this.getRelations().iterator();
            while (iterator.hasNext()) {
                POIXMLDocumentPart p = (POIXMLDocumentPart)iterator.next();
                if (!(p instanceof XSSFVMLDrawing)) continue;
                XSSFVMLDrawing dr = (XSSFVMLDrawing)p;
                String drId = dr.getPackageRelationship().getId();
                if (!drId.equals(ctDrawing.getId())) break;
                drawing = dr;
                break;
            }
            if (drawing == null) {
                logger.log(POILogger.ERROR, (Object)("Can't find VML drawing with id=" + ctDrawing.getId() + " in the list of the sheet's relationships"));
            }
        }
        return drawing;
    }

    protected CTDrawing getCTDrawing() {
        return this.worksheet.getDrawing();
    }

    protected CTLegacyDrawing getCTLegacyDrawing() {
        return this.worksheet.getLegacyDrawing();
    }

    public void createFreezePane(int colSplit, int rowSplit) {
        this.createFreezePane(colSplit, rowSplit, colSplit, rowSplit);
    }

    public void createFreezePane(int colSplit, int rowSplit, int leftmostColumn, int topRow) {
        CTSheetView ctView = this.getDefaultSheetView();
        if (colSplit == 0 && rowSplit == 0) {
            if (ctView.isSetPane()) {
                ctView.unsetPane();
            }
            ctView.setSelectionArray(null);
            return;
        }
        if (!ctView.isSetPane()) {
            ctView.addNewPane();
        }
        CTPane pane = ctView.getPane();
        if (colSplit > 0) {
            pane.setXSplit((double)colSplit);
        } else if (pane.isSetXSplit()) {
            pane.unsetXSplit();
        }
        if (rowSplit > 0) {
            pane.setYSplit((double)rowSplit);
        } else if (pane.isSetYSplit()) {
            pane.unsetYSplit();
        }
        pane.setState(STPaneState.FROZEN);
        if (rowSplit == 0) {
            pane.setTopLeftCell(new CellReference(0, leftmostColumn).formatAsString());
            pane.setActivePane(STPane.TOP_RIGHT);
        } else if (colSplit == 0) {
            pane.setTopLeftCell(new CellReference(topRow, 0).formatAsString());
            pane.setActivePane(STPane.BOTTOM_LEFT);
        } else {
            pane.setTopLeftCell(new CellReference(topRow, leftmostColumn).formatAsString());
            pane.setActivePane(STPane.BOTTOM_RIGHT);
        }
        ctView.setSelectionArray(null);
        CTSelection sel = ctView.addNewSelection();
        sel.setPane(pane.getActivePane());
    }

    public Comment createComment() {
        return this.createDrawingPatriarch().createCellComment((ClientAnchor)new XSSFClientAnchor());
    }

    public Row createRow(int rownum) {
        CTRow ctRow;
        XSSFRow prev = (XSSFRow)this._rows.get(new Integer(rownum));
        if (prev != null) {
            ctRow = prev.getCTRow();
            ctRow.set((XmlObject)CTRow.Factory.newInstance());
        } else if (this._rows.isEmpty() || rownum > (Integer)this._rows.lastKey()) {
            ctRow = this.worksheet.getSheetData().addNewRow();
        } else {
            int idx = this._rows.headMap(new Integer(rownum)).size();
            ctRow = this.worksheet.getSheetData().insertNewRow(idx);
        }
        XSSFRow r = new XSSFRow(ctRow, this);
        r.setRowNum(rownum);
        this._rows.put(new Integer(rownum), r);
        return r;
    }

    public void createSplitPane(int xSplitPos, int ySplitPos, int leftmostColumn, int topRow, int activePane) {
        this.createFreezePane(xSplitPos, ySplitPos, leftmostColumn, topRow);
        this.getPane().setState(STPaneState.SPLIT);
        this.getPane().setActivePane(STPane.Enum.forInt((int)activePane));
    }

    public Comment getCellComment(int row, int column) {
        if (this.sheetComments == null) {
            return null;
        }
        String ref = new CellReference(row, column).formatAsString();
        CTComment ctComment = this.sheetComments.getCTComment(ref);
        if (ctComment == null) {
            return null;
        }
        XSSFVMLDrawing vml = this.getVMLDrawing(false);
        return new XSSFComment(this.sheetComments, ctComment, vml == null ? null : vml.findCommentShape(row, column));
    }

    public XSSFHyperlink getHyperlink(int row, int column) {
        String ref = new CellReference(row, column).formatAsString();
        Iterator iterator = this.hyperlinks.iterator();
        while (iterator.hasNext()) {
            XSSFHyperlink hyperlink = (XSSFHyperlink)iterator.next();
            if (!hyperlink.getCellRef().equals(ref)) continue;
            return hyperlink;
        }
        return null;
    }

    public int[] getColumnBreaks() {
        if (!this.worksheet.isSetColBreaks() || this.worksheet.getColBreaks().sizeOfBrkArray() == 0) {
            return new int[0];
        }
        CTBreak[] brkArray = this.worksheet.getColBreaks().getBrkArray();
        int[] breaks = new int[brkArray.length];
        int i = 0;
        while (i < brkArray.length) {
            CTBreak brk = brkArray[i];
            breaks[i] = (int)brk.getId() - 1;
            ++i;
        }
        return breaks;
    }

    public int getColumnWidth(int columnIndex) {
        CTCol col = this.columnHelper.getColumn(columnIndex, false);
        double width = col == null || !col.isSetWidth() ? (double)this.getDefaultColumnWidth() : col.getWidth();
        return (int)(width * 256.0);
    }

    public int getDefaultColumnWidth() {
        CTSheetFormatPr pr = this.worksheet.getSheetFormatPr();
        return pr == null ? 8 : (int)pr.getBaseColWidth();
    }

    public short getDefaultRowHeight() {
        return (short)(this.getDefaultRowHeightInPoints() * 20.0f);
    }

    public float getDefaultRowHeightInPoints() {
        CTSheetFormatPr pr = this.worksheet.getSheetFormatPr();
        return (float)(pr == null ? 0.0 : pr.getDefaultRowHeight());
    }

    private CTSheetFormatPr getSheetTypeSheetFormatPr() {
        return this.worksheet.isSetSheetFormatPr() ? this.worksheet.getSheetFormatPr() : this.worksheet.addNewSheetFormatPr();
    }

    public CellStyle getColumnStyle(int column) {
        int idx = this.columnHelper.getColDefaultStyle(column);
        return this.getWorkbook().getCellStyleAt((short)(idx == -1 ? 0 : idx));
    }

    public void setRightToLeft(boolean value) {
        CTSheetView view = this.getDefaultSheetView();
        view.setRightToLeft(value);
    }

    public boolean isRightToLeft() {
        CTSheetView view = this.getDefaultSheetView();
        return view == null ? false : view.getRightToLeft();
    }

    public boolean getDisplayGuts() {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        CTOutlinePr outlinePr = sheetPr.getOutlinePr() == null ? CTOutlinePr.Factory.newInstance() : sheetPr.getOutlinePr();
        return outlinePr.getShowOutlineSymbols();
    }

    public void setDisplayGuts(boolean value) {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        CTOutlinePr outlinePr = sheetPr.getOutlinePr() == null ? sheetPr.addNewOutlinePr() : sheetPr.getOutlinePr();
        outlinePr.setShowOutlineSymbols(value);
    }

    public boolean isDisplayZeros() {
        CTSheetView view = this.getDefaultSheetView();
        return view == null ? true : view.getShowZeros();
    }

    public void setDisplayZeros(boolean value) {
        CTSheetView view = this.getSheetTypeSheetView();
        view.setShowZeros(value);
    }

    public int getFirstRowNum() {
        return this._rows.size() == 0 ? 0 : (Integer)this._rows.firstKey();
    }

    public boolean getFitToPage() {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        CTPageSetUpPr psSetup = sheetPr == null || !sheetPr.isSetPageSetUpPr() ? CTPageSetUpPr.Factory.newInstance() : sheetPr.getPageSetUpPr();
        return psSetup.getFitToPage();
    }

    private CTSheetPr getSheetTypeSheetPr() {
        if (this.worksheet.getSheetPr() == null) {
            this.worksheet.setSheetPr(CTSheetPr.Factory.newInstance());
        }
        return this.worksheet.getSheetPr();
    }

    private CTHeaderFooter getSheetTypeHeaderFooter() {
        if (this.worksheet.getHeaderFooter() == null) {
            this.worksheet.setHeaderFooter(CTHeaderFooter.Factory.newInstance());
        }
        return this.worksheet.getHeaderFooter();
    }

    public Footer getFooter() {
        return this.getOddFooter();
    }

    public Header getHeader() {
        return this.getOddHeader();
    }

    public Footer getOddFooter() {
        return new XSSFOddFooter(this.getSheetTypeHeaderFooter());
    }

    public Footer getEvenFooter() {
        return new XSSFEvenFooter(this.getSheetTypeHeaderFooter());
    }

    public Footer getFirstFooter() {
        return new XSSFFirstFooter(this.getSheetTypeHeaderFooter());
    }

    public Header getOddHeader() {
        return new XSSFOddHeader(this.getSheetTypeHeaderFooter());
    }

    public Header getEvenHeader() {
        return new XSSFEvenHeader(this.getSheetTypeHeaderFooter());
    }

    public Header getFirstHeader() {
        return new XSSFFirstHeader(this.getSheetTypeHeaderFooter());
    }

    public boolean getHorizontallyCenter() {
        CTPrintOptions opts = this.worksheet.getPrintOptions();
        return opts != null && opts.getHorizontalCentered();
    }

    public int getLastRowNum() {
        return this._rows.size() == 0 ? 0 : (Integer)this._rows.lastKey();
    }

    public short getLeftCol() {
        String cellRef = this.worksheet.getSheetViews().getSheetViewArray(0).getTopLeftCell();
        CellReference cellReference = new CellReference(cellRef);
        return cellReference.getCol();
    }

    public double getMargin(short margin) {
        if (!this.worksheet.isSetPageMargins()) {
            return 0.0;
        }
        CTPageMargins pageMargins = this.worksheet.getPageMargins();
        switch (margin) {
            case 0: {
                return pageMargins.getLeft();
            }
            case 1: {
                return pageMargins.getRight();
            }
            case 2: {
                return pageMargins.getTop();
            }
            case 3: {
                return pageMargins.getBottom();
            }
            case 4: {
                return pageMargins.getHeader();
            }
            case 5: {
                return pageMargins.getFooter();
            }
        }
        throw new IllegalArgumentException("Unknown margin constant:  " + margin);
    }

    public void setMargin(short margin, double size) {
        CTPageMargins pageMargins = this.worksheet.isSetPageMargins() ? this.worksheet.getPageMargins() : this.worksheet.addNewPageMargins();
        switch (margin) {
            case 0: {
                pageMargins.setLeft(size);
                break;
            }
            case 1: {
                pageMargins.setRight(size);
                break;
            }
            case 2: {
                pageMargins.setTop(size);
                break;
            }
            case 3: {
                pageMargins.setBottom(size);
                break;
            }
            case 4: {
                pageMargins.setHeader(size);
                break;
            }
            case 5: {
                pageMargins.setFooter(size);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown margin constant:  " + margin);
            }
        }
    }

    public CellRangeAddress getMergedRegion(int index) {
        CTMergeCells ctMergeCells = this.worksheet.getMergeCells();
        if (ctMergeCells == null) {
            throw new IllegalStateException("This worksheet does not contain merged regions");
        }
        CTMergeCell ctMergeCell = ctMergeCells.getMergeCellArray(index);
        String ref = ctMergeCell.getRef();
        return CellRangeAddress.valueOf((String)ref);
    }

    public int getNumMergedRegions() {
        CTMergeCells ctMergeCells = this.worksheet.getMergeCells();
        return ctMergeCells == null ? 0 : ctMergeCells.sizeOfMergeCellArray();
    }

    public int getNumHyperlinks() {
        return this.hyperlinks.size();
    }

    public PaneInformation getPaneInformation() {
        CTPane pane = this.getDefaultSheetView().getPane();
        if (pane == null) {
            return null;
        }
        CellReference cellRef = pane.isSetTopLeftCell() ? new CellReference(pane.getTopLeftCell()) : null;
        return new PaneInformation((short)pane.getXSplit(), (short)pane.getYSplit(), (short)(cellRef == null ? 0 : cellRef.getRow()), cellRef == null ? (short)0 : cellRef.getCol(), (byte)(pane.getActivePane().intValue() - 1), pane.getState() == STPaneState.FROZEN);
    }

    public int getPhysicalNumberOfRows() {
        return this._rows.size();
    }

    public PrintSetup getPrintSetup() {
        return new XSSFPrintSetup(this.worksheet);
    }

    public boolean getProtect() {
        return this.worksheet.isSetSheetProtection() && this.sheetProtectionEnabled();
    }

    public void protectSheet(String password) {
        if (password != null) {
            CTSheetProtection sheetProtection = this.worksheet.addNewSheetProtection();
            sheetProtection.xsetPassword(this.stringToExcelPassword(password));
            sheetProtection.setSheet(true);
            sheetProtection.setScenarios(true);
            sheetProtection.setObjects(true);
        } else {
            this.worksheet.unsetSheetProtection();
        }
    }

    private STUnsignedShortHex stringToExcelPassword(String password) {
        STUnsignedShortHex hexPassword = STUnsignedShortHex.Factory.newInstance();
        hexPassword.setStringValue(String.valueOf(HexDump.shortToHex((int)PasswordRecord.hashPassword((String)password))).substring(2));
        return hexPassword;
    }

    public Row getRow(int rownum) {
        return (Row)this._rows.get(new Integer(rownum));
    }

    public int[] getRowBreaks() {
        if (!this.worksheet.isSetRowBreaks() || this.worksheet.getRowBreaks().sizeOfBrkArray() == 0) {
            return new int[0];
        }
        CTBreak[] brkArray = this.worksheet.getRowBreaks().getBrkArray();
        int[] breaks = new int[brkArray.length];
        int i = 0;
        while (i < brkArray.length) {
            CTBreak brk = brkArray[i];
            breaks[i] = (int)brk.getId() - 1;
            ++i;
        }
        return breaks;
    }

    public boolean getRowSumsBelow() {
        CTOutlinePr outlinePr;
        CTSheetPr sheetPr = this.worksheet.getSheetPr();
        CTOutlinePr cTOutlinePr = outlinePr = sheetPr != null && sheetPr.isSetOutlinePr() ? sheetPr.getOutlinePr() : null;
        return outlinePr == null || outlinePr.getSummaryBelow();
    }

    public void setRowSumsBelow(boolean value) {
        this.ensureOutlinePr().setSummaryBelow(value);
    }

    public boolean getRowSumsRight() {
        CTSheetPr sheetPr = this.worksheet.getSheetPr();
        CTOutlinePr outlinePr = sheetPr != null && sheetPr.isSetOutlinePr() ? sheetPr.getOutlinePr() : CTOutlinePr.Factory.newInstance();
        return outlinePr.getSummaryRight();
    }

    public void setRowSumsRight(boolean value) {
        this.ensureOutlinePr().setSummaryRight(value);
    }

    private CTOutlinePr ensureOutlinePr() {
        CTSheetPr sheetPr = this.worksheet.isSetSheetPr() ? this.worksheet.getSheetPr() : this.worksheet.addNewSheetPr();
        return sheetPr.isSetOutlinePr() ? sheetPr.getOutlinePr() : sheetPr.addNewOutlinePr();
    }

    public boolean getScenarioProtect() {
        return this.worksheet.isSetSheetProtection() && this.worksheet.getSheetProtection().getScenarios();
    }

    public short getTopRow() {
        String cellRef = this.getSheetTypeSheetView().getTopLeftCell();
        CellReference cellReference = new CellReference(cellRef);
        return (short)cellReference.getRow();
    }

    public boolean getVerticallyCenter() {
        CTPrintOptions opts = this.worksheet.getPrintOptions();
        return opts != null && opts.getVerticalCentered();
    }

    public void groupColumn(int fromColumn, int toColumn) {
        this.groupColumn1Based(fromColumn + 1, toColumn + 1);
    }

    private void groupColumn1Based(int fromColumn, int toColumn) {
        CTCols ctCols = this.worksheet.getColsArray(0);
        CTCol ctCol = CTCol.Factory.newInstance();
        ctCol.setMin((long)fromColumn);
        ctCol.setMax((long)toColumn);
        this.columnHelper.addCleanColIntoCols(ctCols, ctCol);
        int index = fromColumn;
        while (index <= toColumn) {
            CTCol col = this.columnHelper.getColumn1Based(index, false);
            short outlineLevel = col.getOutlineLevel();
            col.setOutlineLevel((short)(outlineLevel + 1));
            index = (int)col.getMax();
            ++index;
        }
        this.worksheet.setColsArray(0, ctCols);
        this.setSheetFormatPrOutlineLevelCol();
    }

    public void groupRow(int fromRow, int toRow) {
        int i = fromRow;
        while (i <= toRow) {
            XSSFRow xrow = (XSSFRow)this.getRow(i);
            if (xrow == null) {
                xrow = (XSSFRow)this.createRow(i);
            }
            CTRow ctrow = xrow.getCTRow();
            short outlineLevel = ctrow.getOutlineLevel();
            ctrow.setOutlineLevel((short)(outlineLevel + 1));
            ++i;
        }
        this.setSheetFormatPrOutlineLevelRow();
    }

    private short getMaxOutlineLevelRows() {
        short outlineLevel = 0;
        Iterator iterator = this._rows.values().iterator();
        while (iterator.hasNext()) {
            XSSFRow xrow = (XSSFRow)iterator.next();
            short s = outlineLevel = xrow.getCTRow().getOutlineLevel() > outlineLevel ? xrow.getCTRow().getOutlineLevel() : outlineLevel;
        }
        return outlineLevel;
    }

    private short getMaxOutlineLevelCols() {
        CTCols ctCols = this.worksheet.getColsArray(0);
        short outlineLevel = 0;
        int i = 0;
        while (i < ctCols.getColArray().length) {
            CTCol col = ctCols.getColArray()[i];
            outlineLevel = col.getOutlineLevel() > outlineLevel ? col.getOutlineLevel() : outlineLevel;
            ++i;
        }
        return outlineLevel;
    }

    public boolean isColumnBroken(int column) {
        int[] colBreaks = this.getColumnBreaks();
        int i = 0;
        while (i < colBreaks.length) {
            if (colBreaks[i] == column) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isColumnHidden(int columnIndex) {
        CTCol col = this.columnHelper.getColumn(columnIndex, false);
        return col != null && col.getHidden();
    }

    public boolean isDisplayFormulas() {
        return this.getSheetTypeSheetView().getShowFormulas();
    }

    public boolean isDisplayGridlines() {
        return this.getSheetTypeSheetView().getShowGridLines();
    }

    public void setDisplayGridlines(boolean show) {
        this.getSheetTypeSheetView().setShowGridLines(show);
    }

    public boolean isDisplayRowColHeadings() {
        return this.getSheetTypeSheetView().getShowRowColHeaders();
    }

    public void setDisplayRowColHeadings(boolean show) {
        this.getSheetTypeSheetView().setShowRowColHeaders(show);
    }

    public boolean isPrintGridlines() {
        CTPrintOptions opts = this.worksheet.getPrintOptions();
        return opts != null && opts.getGridLines();
    }

    public void setPrintGridlines(boolean value) {
        CTPrintOptions opts = this.worksheet.isSetPrintOptions() ? this.worksheet.getPrintOptions() : this.worksheet.addNewPrintOptions();
        opts.setGridLines(value);
    }

    public boolean isRowBroken(int row) {
        int[] rowBreaks = this.getRowBreaks();
        int i = 0;
        while (i < rowBreaks.length) {
            if (rowBreaks[i] == row) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setRowBreak(int row) {
        CTPageBreak pgBreak;
        CTPageBreak cTPageBreak = pgBreak = this.worksheet.isSetRowBreaks() ? this.worksheet.getRowBreaks() : this.worksheet.addNewRowBreaks();
        if (!this.isRowBroken(row)) {
            CTBreak brk = pgBreak.addNewBrk();
            brk.setId((long)(row + 1));
            brk.setMan(true);
            brk.setMax((long)SpreadsheetVersion.EXCEL2007.getLastColumnIndex());
            pgBreak.setCount((long)pgBreak.sizeOfBrkArray());
            pgBreak.setManualBreakCount((long)pgBreak.sizeOfBrkArray());
        }
    }

    public void removeColumnBreak(int column) {
        if (!this.worksheet.isSetColBreaks()) {
            return;
        }
        CTPageBreak pgBreak = this.worksheet.getColBreaks();
        CTBreak[] brkArray = pgBreak.getBrkArray();
        int i = 0;
        while (i < brkArray.length) {
            if (brkArray[i].getId() == (long)(column + 1)) {
                pgBreak.removeBrk(i);
            }
            ++i;
        }
    }

    public void removeMergedRegion(int index) {
        CTMergeCells ctMergeCells = this.worksheet.getMergeCells();
        CTMergeCell[] mergeCellsArray = new CTMergeCell[ctMergeCells.sizeOfMergeCellArray() - 1];
        int i = 0;
        while (i < ctMergeCells.sizeOfMergeCellArray()) {
            if (i < index) {
                mergeCellsArray[i] = ctMergeCells.getMergeCellArray(i);
            } else if (i > index) {
                mergeCellsArray[i - 1] = ctMergeCells.getMergeCellArray(i);
            }
            ++i;
        }
        if (mergeCellsArray.length > 0) {
            ctMergeCells.setMergeCellArray(mergeCellsArray);
        } else {
            this.worksheet.unsetMergeCells();
        }
    }

    public void removeRow(Row row) {
        Cell cell;
        if (row.getSheet() != this) {
            throw new IllegalArgumentException("Specified row does not belong to this sheet");
        }
        ArrayList<XSSFCell> cellsToDelete = new ArrayList<XSSFCell>();
        Iterator iterator = row.iterator();
        while (iterator.hasNext()) {
            cell = (Cell)iterator.next();
            cellsToDelete.add((XSSFCell)cell);
        }
        iterator = cellsToDelete.iterator();
        while (iterator.hasNext()) {
            cell = (XSSFCell)iterator.next();
            row.removeCell(cell);
        }
        int idx = this._rows.headMap(new Integer(row.getRowNum())).size();
        this._rows.remove(new Integer(row.getRowNum()));
        this.worksheet.getSheetData().removeRow(idx);
    }

    public void removeRowBreak(int row) {
        if (!this.worksheet.isSetRowBreaks()) {
            return;
        }
        CTPageBreak pgBreak = this.worksheet.getRowBreaks();
        CTBreak[] brkArray = pgBreak.getBrkArray();
        int i = 0;
        while (i < brkArray.length) {
            if (brkArray[i].getId() == (long)(row + 1)) {
                pgBreak.removeBrk(i);
            }
            ++i;
        }
    }

    public void setForceFormulaRecalculation(boolean value) {
        if (this.worksheet.isSetSheetCalcPr()) {
            CTSheetCalcPr calc = this.worksheet.getSheetCalcPr();
            calc.setFullCalcOnLoad(value);
        } else if (value) {
            CTSheetCalcPr calc = this.worksheet.addNewSheetCalcPr();
            calc.setFullCalcOnLoad(value);
        }
    }

    public boolean getForceFormulaRecalculation() {
        if (this.worksheet.isSetSheetCalcPr()) {
            CTSheetCalcPr calc = this.worksheet.getSheetCalcPr();
            return calc.getFullCalcOnLoad();
        }
        return false;
    }

    public Iterator rowIterator() {
        return this._rows.values().iterator();
    }

    public Iterator iterator() {
        return this.rowIterator();
    }

    public boolean getAutobreaks() {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        CTPageSetUpPr psSetup = sheetPr == null || !sheetPr.isSetPageSetUpPr() ? CTPageSetUpPr.Factory.newInstance() : sheetPr.getPageSetUpPr();
        return psSetup.getAutoPageBreaks();
    }

    public void setAutobreaks(boolean value) {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        CTPageSetUpPr psSetup = sheetPr.isSetPageSetUpPr() ? sheetPr.getPageSetUpPr() : sheetPr.addNewPageSetUpPr();
        psSetup.setAutoPageBreaks(value);
    }

    public void setColumnBreak(int column) {
        if (!this.isColumnBroken(column)) {
            CTPageBreak pgBreak = this.worksheet.isSetColBreaks() ? this.worksheet.getColBreaks() : this.worksheet.addNewColBreaks();
            CTBreak brk = pgBreak.addNewBrk();
            brk.setId((long)(column + 1));
            brk.setMan(true);
            brk.setMax((long)SpreadsheetVersion.EXCEL2007.getLastRowIndex());
            pgBreak.setCount((long)pgBreak.sizeOfBrkArray());
            pgBreak.setManualBreakCount((long)pgBreak.sizeOfBrkArray());
        }
    }

    public void setColumnGroupCollapsed(int columnNumber, boolean collapsed) {
        if (collapsed) {
            this.collapseColumn(columnNumber);
        } else {
            this.expandColumn(columnNumber);
        }
    }

    private void collapseColumn(int columnNumber) {
        CTCol col;
        CTCols cols = this.worksheet.getColsArray(0);
        int colInfoIx = this.columnHelper.getIndexOfColumn(cols, col = this.columnHelper.getColumn(columnNumber, false));
        if (colInfoIx == -1) {
            return;
        }
        int groupStartColInfoIx = this.findStartOfColumnOutlineGroup(colInfoIx);
        CTCol columnInfo = cols.getColArray(groupStartColInfoIx);
        int lastColMax = this.setGroupHidden(groupStartColInfoIx, columnInfo.getOutlineLevel(), true);
        this.setColumn(lastColMax + 1, null, new Integer(0), null, null, Boolean.TRUE);
    }

    private void setColumn(int targetColumnIx, Short xfIndex, Integer style, Integer level, Boolean hidden, Boolean collapsed) {
        boolean columnChanged;
        CTCols cols = this.worksheet.getColsArray(0);
        CTCol ci = null;
        int k = 0;
        k = 0;
        while (k < cols.sizeOfColArray()) {
            CTCol tci = cols.getColArray(k);
            if (tci.getMin() >= (long)targetColumnIx && tci.getMax() <= (long)targetColumnIx) {
                ci = tci;
                break;
            }
            if (tci.getMin() > (long)targetColumnIx) break;
            ++k;
        }
        if (ci == null) {
            CTCol nci = CTCol.Factory.newInstance();
            nci.setMin((long)targetColumnIx);
            nci.setMax((long)targetColumnIx);
            this.unsetCollapsed(collapsed, nci);
            this.columnHelper.addCleanColIntoCols(cols, nci);
            return;
        }
        boolean styleChanged = style != null && ci.getStyle() != (long)style.intValue();
        boolean levelChanged = level != null && ci.getOutlineLevel() != level.intValue();
        boolean hiddenChanged = hidden != null && ci.getHidden() != hidden.booleanValue();
        boolean collapsedChanged = collapsed != null && ci.getCollapsed() != collapsed.booleanValue();
        boolean bl = columnChanged = levelChanged || hiddenChanged || collapsedChanged || styleChanged;
        if (!columnChanged) {
            return;
        }
        if (ci.getMin() == (long)targetColumnIx && ci.getMax() == (long)targetColumnIx) {
            this.unsetCollapsed(collapsed, ci);
            return;
        }
        if (ci.getMin() == (long)targetColumnIx || ci.getMax() == (long)targetColumnIx) {
            if (ci.getMin() == (long)targetColumnIx) {
                ci.setMin((long)(targetColumnIx + 1));
            } else {
                ci.setMax((long)(targetColumnIx - 1));
                ++k;
            }
            CTCol nci = this.columnHelper.cloneCol(cols, ci);
            nci.setMin((long)targetColumnIx);
            this.unsetCollapsed(collapsed, nci);
            this.columnHelper.addCleanColIntoCols(cols, nci);
        } else {
            CTCol ciStart = ci;
            CTCol ciMid = this.columnHelper.cloneCol(cols, ci);
            CTCol ciEnd = this.columnHelper.cloneCol(cols, ci);
            int lastcolumn = (int)ci.getMax();
            ciStart.setMax((long)(targetColumnIx - 1));
            ciMid.setMin((long)targetColumnIx);
            ciMid.setMax((long)targetColumnIx);
            this.unsetCollapsed(collapsed, ciMid);
            this.columnHelper.addCleanColIntoCols(cols, ciMid);
            ciEnd.setMin((long)(targetColumnIx + 1));
            ciEnd.setMax((long)lastcolumn);
            this.columnHelper.addCleanColIntoCols(cols, ciEnd);
        }
    }

    private void unsetCollapsed(boolean collapsed, CTCol ci) {
        if (collapsed) {
            ci.setCollapsed(collapsed);
        } else {
            ci.unsetCollapsed();
        }
    }

    private int setGroupHidden(int pIdx, int level, boolean hidden) {
        CTCols cols = this.worksheet.getColsArray(0);
        int idx = pIdx;
        CTCol columnInfo = cols.getColArray(idx);
        while (idx < cols.sizeOfColArray()) {
            columnInfo.setHidden(hidden);
            if (idx + 1 < cols.sizeOfColArray()) {
                CTCol nextColumnInfo = cols.getColArray(idx + 1);
                if (!this.isAdjacentBefore(columnInfo, nextColumnInfo) || nextColumnInfo.getOutlineLevel() < level) break;
                columnInfo = nextColumnInfo;
            }
            ++idx;
        }
        return (int)columnInfo.getMax();
    }

    private boolean isAdjacentBefore(CTCol col, CTCol other_col) {
        return col.getMax() == other_col.getMin() - 1L;
    }

    private int findStartOfColumnOutlineGroup(int pIdx) {
        CTCols cols = this.worksheet.getColsArray(0);
        CTCol columnInfo = cols.getColArray(pIdx);
        short level = columnInfo.getOutlineLevel();
        int idx = pIdx;
        while (idx != 0) {
            CTCol prevColumnInfo = cols.getColArray(idx - 1);
            if (!this.isAdjacentBefore(prevColumnInfo, columnInfo) || prevColumnInfo.getOutlineLevel() < level) break;
            --idx;
            columnInfo = prevColumnInfo;
        }
        return idx;
    }

    private int findEndOfColumnOutlineGroup(int colInfoIndex) {
        CTCols cols = this.worksheet.getColsArray(0);
        CTCol columnInfo = cols.getColArray(colInfoIndex);
        short level = columnInfo.getOutlineLevel();
        int idx = colInfoIndex;
        while (idx < cols.sizeOfColArray() - 1) {
            CTCol nextColumnInfo = cols.getColArray(idx + 1);
            if (!this.isAdjacentBefore(columnInfo, nextColumnInfo) || nextColumnInfo.getOutlineLevel() < level) break;
            ++idx;
            columnInfo = nextColumnInfo;
        }
        return idx;
    }

    private void expandColumn(int columnIndex) {
        CTCols cols = this.worksheet.getColsArray(0);
        CTCol col = this.columnHelper.getColumn(columnIndex, false);
        int colInfoIx = this.columnHelper.getIndexOfColumn(cols, col);
        int idx = this.findColInfoIdx((int)col.getMax(), colInfoIx);
        if (idx == -1) {
            return;
        }
        if (!this.isColumnGroupCollapsed(idx)) {
            return;
        }
        int startIdx = this.findStartOfColumnOutlineGroup(idx);
        int endIdx = this.findEndOfColumnOutlineGroup(idx);
        CTCol columnInfo = cols.getColArray(endIdx);
        if (!this.isColumnGroupHiddenByParent(idx)) {
            short outlineLevel = columnInfo.getOutlineLevel();
            boolean nestedGroup = false;
            int i = startIdx;
            while (i <= endIdx) {
                CTCol ci = cols.getColArray(i);
                if (outlineLevel == ci.getOutlineLevel()) {
                    ci.unsetHidden();
                    if (nestedGroup) {
                        nestedGroup = false;
                        ci.setCollapsed(true);
                    }
                } else {
                    nestedGroup = true;
                }
                ++i;
            }
        }
        this.setColumn((int)columnInfo.getMax() + 1, null, null, null, Boolean.FALSE, Boolean.FALSE);
    }

    private boolean isColumnGroupHiddenByParent(int idx) {
        CTCol prevInfo;
        CTCols cols = this.worksheet.getColsArray(0);
        short endLevel = 0;
        boolean endHidden = false;
        int endOfOutlineGroupIdx = this.findEndOfColumnOutlineGroup(idx);
        if (endOfOutlineGroupIdx < cols.sizeOfColArray()) {
            CTCol nextInfo = cols.getColArray(endOfOutlineGroupIdx + 1);
            if (this.isAdjacentBefore(cols.getColArray(endOfOutlineGroupIdx), nextInfo)) {
                endLevel = nextInfo.getOutlineLevel();
                endHidden = nextInfo.getHidden();
            }
        }
        short startLevel = 0;
        boolean startHidden = false;
        int startOfOutlineGroupIdx = this.findStartOfColumnOutlineGroup(idx);
        if (startOfOutlineGroupIdx > 0 && this.isAdjacentBefore(prevInfo = cols.getColArray(startOfOutlineGroupIdx - 1), cols.getColArray(startOfOutlineGroupIdx))) {
            startLevel = prevInfo.getOutlineLevel();
            startHidden = prevInfo.getHidden();
        }
        if (endLevel > startLevel) {
            return endHidden;
        }
        return startHidden;
    }

    private int findColInfoIdx(int columnValue, int fromColInfoIdx) {
        CTCols cols = this.worksheet.getColsArray(0);
        if (columnValue < 0) {
            throw new IllegalArgumentException("column parameter out of range: " + columnValue);
        }
        if (fromColInfoIdx < 0) {
            throw new IllegalArgumentException("fromIdx parameter out of range: " + fromColInfoIdx);
        }
        int k = fromColInfoIdx;
        while (k < cols.sizeOfColArray()) {
            CTCol ci = cols.getColArray(k);
            if (this.containsColumn(ci, columnValue)) {
                return k;
            }
            if (ci.getMin() > (long)fromColInfoIdx) break;
            ++k;
        }
        return -1;
    }

    private boolean containsColumn(CTCol col, int columnIndex) {
        return col.getMin() <= (long)columnIndex && (long)columnIndex <= col.getMax();
    }

    private boolean isColumnGroupCollapsed(int idx) {
        CTCols cols = this.worksheet.getColsArray(0);
        int endOfOutlineGroupIdx = this.findEndOfColumnOutlineGroup(idx);
        int nextColInfoIx = endOfOutlineGroupIdx + 1;
        if (nextColInfoIx >= cols.sizeOfColArray()) {
            return false;
        }
        CTCol nextColInfo = cols.getColArray(nextColInfoIx);
        CTCol col = cols.getColArray(endOfOutlineGroupIdx);
        if (!this.isAdjacentBefore(col, nextColInfo)) {
            return false;
        }
        return nextColInfo.getCollapsed();
    }

    public void setColumnHidden(int columnIndex, boolean hidden) {
        this.columnHelper.setColHidden(columnIndex, hidden);
    }

    public void setColumnWidth(int columnIndex, int width) {
        if (width > 65280) {
            throw new IllegalArgumentException("The maximum column width for an individual cell is 255 characters.");
        }
        this.columnHelper.setColWidth(columnIndex, (double)width / 256.0);
        this.columnHelper.setCustomWidth(columnIndex, true);
    }

    public void setDefaultColumnStyle(int column, CellStyle style) {
        this.columnHelper.setColDefaultStyle((long)column, style);
    }

    public void setDefaultColumnWidth(int width) {
        this.getSheetTypeSheetFormatPr().setBaseColWidth((long)width);
    }

    public void setDefaultRowHeight(short height) {
        this.setDefaultRowHeightInPoints((float)height / 20.0f);
    }

    public void setDefaultRowHeightInPoints(float height) {
        CTSheetFormatPr pr = this.getSheetTypeSheetFormatPr();
        pr.setDefaultRowHeight((double)height);
        pr.setCustomHeight(true);
    }

    public void setDisplayFormulas(boolean show) {
        this.getSheetTypeSheetView().setShowFormulas(show);
    }

    private CTSheetView getSheetTypeSheetView() {
        if (this.getDefaultSheetView() == null) {
            this.getSheetTypeSheetViews().setSheetViewArray(0, CTSheetView.Factory.newInstance());
        }
        return this.getDefaultSheetView();
    }

    public void setFitToPage(boolean b) {
        this.getSheetTypePageSetUpPr().setFitToPage(b);
    }

    public void setHorizontallyCenter(boolean value) {
        CTPrintOptions opts = this.worksheet.isSetPrintOptions() ? this.worksheet.getPrintOptions() : this.worksheet.addNewPrintOptions();
        opts.setHorizontalCentered(value);
    }

    public void setVerticallyCenter(boolean value) {
        CTPrintOptions opts = this.worksheet.isSetPrintOptions() ? this.worksheet.getPrintOptions() : this.worksheet.addNewPrintOptions();
        opts.setVerticalCentered(value);
    }

    public void setRowGroupCollapsed(int rowIndex, boolean collapse) {
        if (collapse) {
            this.collapseRow(rowIndex);
        } else {
            this.expandRow(rowIndex);
        }
    }

    private void collapseRow(int rowIndex) {
        XSSFRow row = (XSSFRow)this.getRow(rowIndex);
        if (row != null) {
            int startRow = this.findStartOfRowOutlineGroup(rowIndex);
            int lastRow = this.writeHidden(row, startRow, true);
            if (this.getRow(lastRow) != null) {
                ((XSSFRow)this.getRow(lastRow)).getCTRow().setCollapsed(true);
            } else {
                XSSFRow newRow = (XSSFRow)this.createRow(lastRow);
                newRow.getCTRow().setCollapsed(true);
            }
        }
    }

    private int findStartOfRowOutlineGroup(int rowIndex) {
        short level = ((XSSFRow)this.getRow(rowIndex)).getCTRow().getOutlineLevel();
        int currentRow = rowIndex;
        while (this.getRow(currentRow) != null) {
            if (((XSSFRow)this.getRow(currentRow)).getCTRow().getOutlineLevel() < level) {
                return currentRow + 1;
            }
            --currentRow;
        }
        return currentRow;
    }

    private int writeHidden(XSSFRow xRow, int rowIndex, boolean hidden) {
        short level = xRow.getCTRow().getOutlineLevel();
        Iterator it = this.rowIterator();
        while (it.hasNext()) {
            xRow = (XSSFRow)it.next();
            if (xRow.getCTRow().getOutlineLevel() < level) continue;
            xRow.getCTRow().setHidden(hidden);
            ++rowIndex;
        }
        return rowIndex;
    }

    private void expandRow(int rowNumber) {
        if (rowNumber == -1) {
            return;
        }
        XSSFRow row = (XSSFRow)this.getRow(rowNumber);
        if (!row.getCTRow().isSetHidden()) {
            return;
        }
        int startIdx = this.findStartOfRowOutlineGroup(rowNumber);
        int endIdx = this.findEndOfRowOutlineGroup(rowNumber);
        if (!this.isRowGroupHiddenByParent(rowNumber)) {
            int i = startIdx;
            while (i < endIdx) {
                if (row.getCTRow().getOutlineLevel() == ((XSSFRow)this.getRow(i)).getCTRow().getOutlineLevel()) {
                    ((XSSFRow)this.getRow(i)).getCTRow().unsetHidden();
                } else if (!this.isRowGroupCollapsed(i)) {
                    ((XSSFRow)this.getRow(i)).getCTRow().unsetHidden();
                }
                ++i;
            }
        }
        ((XSSFRow)this.getRow(endIdx)).getCTRow().unsetCollapsed();
    }

    public int findEndOfRowOutlineGroup(int row) {
        short level = ((XSSFRow)this.getRow(row)).getCTRow().getOutlineLevel();
        int currentRow = row;
        while (currentRow < this.getLastRowNum()) {
            if (this.getRow(currentRow) == null || ((XSSFRow)this.getRow(currentRow)).getCTRow().getOutlineLevel() < level) break;
            ++currentRow;
        }
        return currentRow;
    }

    private boolean isRowGroupHiddenByParent(int row) {
        boolean startHidden;
        short startLevel;
        boolean endHidden;
        short endLevel;
        int endOfOutlineGroupIdx = this.findEndOfRowOutlineGroup(row);
        if (this.getRow(endOfOutlineGroupIdx) == null) {
            endLevel = 0;
            endHidden = false;
        } else {
            endLevel = ((XSSFRow)this.getRow(endOfOutlineGroupIdx)).getCTRow().getOutlineLevel();
            endHidden = ((XSSFRow)this.getRow(endOfOutlineGroupIdx)).getCTRow().getHidden();
        }
        int startOfOutlineGroupIdx = this.findStartOfRowOutlineGroup(row);
        if (startOfOutlineGroupIdx < 0 || this.getRow(startOfOutlineGroupIdx) == null) {
            startLevel = 0;
            startHidden = false;
        } else {
            startLevel = ((XSSFRow)this.getRow(startOfOutlineGroupIdx)).getCTRow().getOutlineLevel();
            startHidden = ((XSSFRow)this.getRow(startOfOutlineGroupIdx)).getCTRow().getHidden();
        }
        if (endLevel > startLevel) {
            return endHidden;
        }
        return startHidden;
    }

    private boolean isRowGroupCollapsed(int row) {
        int collapseRow = this.findEndOfRowOutlineGroup(row) + 1;
        if (this.getRow(collapseRow) == null) {
            return false;
        }
        return ((XSSFRow)this.getRow(collapseRow)).getCTRow().getCollapsed();
    }

    public void setZoom(int numerator, int denominator) {
        int zoom = 100 * numerator / denominator;
        this.setZoom(zoom);
    }

    public void setZoom(int scale) {
        if (scale < 10 || scale > 400) {
            throw new IllegalArgumentException("Valid scale values range from 10 to 400");
        }
        this.getSheetTypeSheetView().setZoomScale((long)scale);
    }

    public void shiftRows(int startRow, int endRow, int n) {
        this.shiftRows(startRow, endRow, n, false, false);
    }

    public void shiftRows(int startRow, int endRow, int n, boolean copyRowHeight, boolean resetOriginalRowHeight) {
        Iterator it = this.rowIterator();
        while (it.hasNext()) {
            XSSFRow row = (XSSFRow)it.next();
            int rownum = row.getRowNum();
            if (rownum < startRow) continue;
            if (!copyRowHeight) {
                row.setHeight((short)-1);
            }
            if (this.removeRow(startRow, endRow, n, rownum)) {
                int idx = this._rows.headMap(new Integer(row.getRowNum())).size();
                this.worksheet.getSheetData().removeRow(idx);
                it.remove();
            } else if (rownum >= startRow && rownum <= endRow) {
                row.shift(n);
            }
            if (this.sheetComments == null) continue;
            CTCommentList lst = this.sheetComments.getCTComments().getCommentList();
            int i = 0;
            while (i < lst.getCommentArray().length) {
                CTComment comment = lst.getCommentArray()[i];
                CellReference ref = new CellReference(comment.getRef());
                if (ref.getRow() == rownum) {
                    ref = new CellReference(rownum + n, ref.getCol());
                    comment.setRef(ref.formatAsString());
                }
                ++i;
            }
        }
        XSSFRowShifter rowShifter = new XSSFRowShifter(this);
        int sheetIndex = this.getWorkbook().getSheetIndex((Sheet)this);
        FormulaShifter shifter = FormulaShifter.createForRowShift((int)sheetIndex, (int)startRow, (int)endRow, (int)n);
        rowShifter.updateNamedRanges(shifter);
        rowShifter.updateFormulas(shifter);
        rowShifter.shiftMerged(startRow, endRow, n);
        rowShifter.updateConditionalFormatting(shifter);
        TreeMap<Integer, XSSFRow> map = new TreeMap<Integer, XSSFRow>();
        Iterator iterator = this._rows.values().iterator();
        while (iterator.hasNext()) {
            XSSFRow r = (XSSFRow)iterator.next();
            map.put(new Integer(r.getRowNum()), r);
        }
        this._rows = map;
    }

    public void showInPane(short toprow, short leftcol) {
        CellReference cellReference = new CellReference((int)toprow, leftcol);
        String cellRef = cellReference.formatAsString();
        this.getPane().setTopLeftCell(cellRef);
    }

    public void ungroupColumn(int fromColumn, int toColumn) {
        CTCols cols = this.worksheet.getColsArray(0);
        int index = fromColumn;
        while (index <= toColumn) {
            CTCol col = this.columnHelper.getColumn(index, false);
            if (col != null) {
                short outlineLevel = col.getOutlineLevel();
                col.setOutlineLevel((short)(outlineLevel - 1));
                index = (int)col.getMax();
                if (col.getOutlineLevel() <= 0) {
                    int colIndex = this.columnHelper.getIndexOfColumn(cols, col);
                    this.worksheet.getColsArray(0).removeCol(colIndex);
                }
            }
            ++index;
        }
        this.worksheet.setColsArray(0, cols);
        this.setSheetFormatPrOutlineLevelCol();
    }

    public void ungroupRow(int fromRow, int toRow) {
        int i = fromRow;
        while (i <= toRow) {
            XSSFRow xrow = (XSSFRow)this.getRow(i);
            if (xrow != null) {
                CTRow ctrow = xrow.getCTRow();
                short outlinelevel = ctrow.getOutlineLevel();
                ctrow.setOutlineLevel((short)(outlinelevel - 1));
                if (ctrow.getOutlineLevel() == 0 && xrow.getFirstCellNum() == -1) {
                    this.removeRow(xrow);
                }
            }
            ++i;
        }
        this.setSheetFormatPrOutlineLevelRow();
    }

    private void setSheetFormatPrOutlineLevelRow() {
        short maxLevelRow = this.getMaxOutlineLevelRows();
        this.getSheetTypeSheetFormatPr().setOutlineLevelRow(maxLevelRow);
    }

    private void setSheetFormatPrOutlineLevelCol() {
        short maxLevelCol = this.getMaxOutlineLevelCols();
        this.getSheetTypeSheetFormatPr().setOutlineLevelCol(maxLevelCol);
    }

    private CTSheetViews getSheetTypeSheetViews() {
        if (this.worksheet.getSheetViews() == null) {
            this.worksheet.setSheetViews(CTSheetViews.Factory.newInstance());
            this.worksheet.getSheetViews().addNewSheetView();
        }
        return this.worksheet.getSheetViews();
    }

    public boolean isSelected() {
        CTSheetView view = this.getDefaultSheetView();
        return view != null && view.getTabSelected();
    }

    public void setSelected(boolean value) {
        CTSheetViews views = this.getSheetTypeSheetViews();
        int i = 0;
        while (i < views.getSheetViewArray().length) {
            CTSheetView view = views.getSheetViewArray()[i];
            view.setTabSelected(value);
            ++i;
        }
    }

    public static void setCellComment(String cellRef, XSSFComment comment) {
        CellReference cellReference = new CellReference(cellRef);
        comment.setRow(cellReference.getRow());
        comment.setColumn(cellReference.getCol());
    }

    public void addHyperlink(XSSFHyperlink hyperlink) {
        this.hyperlinks.add(hyperlink);
    }

    public String getActiveCell() {
        return this.getSheetTypeSelection().getActiveCell();
    }

    public void setActiveCell(String cellRef) {
        CTSelection ctsel = this.getSheetTypeSelection();
        ctsel.setActiveCell(cellRef);
        ctsel.setSqref(Arrays.asList(cellRef));
    }

    public boolean hasComments() {
        if (this.sheetComments == null) {
            return false;
        }
        return this.sheetComments.getNumberOfComments() > 0;
    }

    protected int getNumberOfComments() {
        if (this.sheetComments == null) {
            return 0;
        }
        return this.sheetComments.getNumberOfComments();
    }

    private CTSelection getSheetTypeSelection() {
        if (this.getSheetTypeSheetView().sizeOfSelectionArray() == 0) {
            this.getSheetTypeSheetView().insertNewSelection(0);
        }
        return this.getSheetTypeSheetView().getSelectionArray(0);
    }

    private CTSheetView getDefaultSheetView() {
        int sz;
        CTSheetViews views = this.getSheetTypeSheetViews();
        int n = sz = views == null ? 0 : views.sizeOfSheetViewArray();
        if (sz == 0) {
            return null;
        }
        return views.getSheetViewArray(sz - 1);
    }

    protected CommentsTable getCommentsTable(boolean create) {
        if (this.sheetComments == null && create) {
            try {
                this.sheetComments = (CommentsTable)this.createRelationship(XSSFRelation.SHEET_COMMENTS, XSSFFactory.getInstance(), (int)this.sheet.getSheetId());
            }
            catch (PartAlreadyExistsException e) {
                this.sheetComments = (CommentsTable)this.createRelationship(XSSFRelation.SHEET_COMMENTS, XSSFFactory.getInstance(), -1);
            }
        }
        return this.sheetComments;
    }

    private CTPageSetUpPr getSheetTypePageSetUpPr() {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        return sheetPr.isSetPageSetUpPr() ? sheetPr.getPageSetUpPr() : sheetPr.addNewPageSetUpPr();
    }

    private boolean removeRow(int startRow, int endRow, int n, int rownum) {
        if (rownum >= startRow + n && rownum <= endRow + n) {
            if (n > 0 && rownum > endRow) {
                return true;
            }
            if (n < 0 && rownum < startRow) {
                return true;
            }
        }
        return false;
    }

    private CTPane getPane() {
        if (this.getDefaultSheetView().getPane() == null) {
            this.getDefaultSheetView().addNewPane();
        }
        return this.getDefaultSheetView().getPane();
    }

    CTCellFormula getSharedFormula(int sid) {
        return (CTCellFormula)this.sharedFormulas.get(new Integer(sid));
    }

    void onReadCell(XSSFCell cell) {
        CTCell ct = cell.getCTCell();
        CTCellFormula f = ct.getF();
        if (f != null && f.getT() == STCellFormulaType.SHARED && f.isSetRef() && f.getStringValue() != null) {
            CTCellFormula sf = (CTCellFormula)f.copy();
            CellRangeAddress sfRef = CellRangeAddress.valueOf((String)sf.getRef());
            CellReference cellRef = new CellReference((Cell)cell);
            if (cellRef.getCol() > sfRef.getFirstColumn() || cellRef.getRow() > sfRef.getFirstRow()) {
                String effectiveRef = new CellRangeAddress(Math.max(cellRef.getRow(), sfRef.getFirstRow()), sfRef.getLastRow(), Math.max(cellRef.getCol(), sfRef.getFirstColumn()), sfRef.getLastColumn()).formatAsString();
                sf.setRef(effectiveRef);
            }
            this.sharedFormulas.put(new Integer((int)f.getSi()), sf);
        }
        if (f != null && f.getT() == STCellFormulaType.ARRAY && f.getRef() != null) {
            this.arrayFormulas.add(CellRangeAddress.valueOf((String)f.getRef()));
        }
    }

    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.write(out);
        out.close();
    }

    protected void write(OutputStream out) throws IOException {
        CTCols col;
        if (this.worksheet.sizeOfColsArray() == 1 && (col = this.worksheet.getColsArray(0)).sizeOfColArray() == 0) {
            this.worksheet.setColsArray(null);
        }
        if (this.hyperlinks.size() > 0) {
            if (this.worksheet.getHyperlinks() == null) {
                this.worksheet.addNewHyperlinks();
            }
            CTHyperlink[] ctHls = new CTHyperlink[this.hyperlinks.size()];
            int i = 0;
            while (i < ctHls.length) {
                XSSFHyperlink hyperlink = (XSSFHyperlink)this.hyperlinks.get(i);
                hyperlink.generateRelationIfNeeded(this.getPackagePart());
                ctHls[i] = hyperlink.getCTHyperlink();
                ++i;
            }
            this.worksheet.getHyperlinks().setHyperlinkArray(ctHls);
        }
        Iterator iterator = this._rows.values().iterator();
        while (iterator.hasNext()) {
            XSSFRow row = (XSSFRow)iterator.next();
            row.onDocumentWrite();
        }
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTWorksheet.type.getName().getNamespaceURI(), "worksheet"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(STRelationshipId.type.getName().getNamespaceURI(), "r");
        xmlOptions.setSaveSuggestedPrefixes(map);
        this.worksheet.save(out, xmlOptions);
    }

    public boolean isAutoFilterLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getAutoFilter();
    }

    public boolean isDeleteColumnsLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getDeleteColumns();
    }

    public boolean isDeleteRowsLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getDeleteRows();
    }

    public boolean isFormatCellsLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getFormatCells();
    }

    public boolean isFormatColumnsLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getFormatColumns();
    }

    public boolean isFormatRowsLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getFormatRows();
    }

    public boolean isInsertColumnsLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getInsertColumns();
    }

    public boolean isInsertHyperlinksLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getInsertHyperlinks();
    }

    public boolean isInsertRowsLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getInsertRows();
    }

    public boolean isPivotTablesLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getPivotTables();
    }

    public boolean isSortLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getSort();
    }

    public boolean isObjectsLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getObjects();
    }

    public boolean isScenariosLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getScenarios();
    }

    public boolean isSelectLockedCellsLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getSelectLockedCells();
    }

    public boolean isSelectUnlockedCellsLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getSelectUnlockedCells();
    }

    public boolean isSheetLocked() {
        this.createProtectionFieldIfNotPresent();
        return this.sheetProtectionEnabled() && this.worksheet.getSheetProtection().getSheet();
    }

    public void enableLocking() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setSheet(true);
    }

    public void disableLocking() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setSheet(false);
    }

    public void lockAutoFilter() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setAutoFilter(true);
    }

    public void lockDeleteColumns() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setDeleteColumns(true);
    }

    public void lockDeleteRows() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setDeleteRows(true);
    }

    public void lockFormatCells() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setDeleteColumns(true);
    }

    public void lockFormatColumns() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setFormatColumns(true);
    }

    public void lockFormatRows() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setFormatRows(true);
    }

    public void lockInsertColumns() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setInsertColumns(true);
    }

    public void lockInsertHyperlinks() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setInsertHyperlinks(true);
    }

    public void lockInsertRows() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setInsertRows(true);
    }

    public void lockPivotTables() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setPivotTables(true);
    }

    public void lockSort() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setSort(true);
    }

    public void lockObjects() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setObjects(true);
    }

    public void lockScenarios() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setScenarios(true);
    }

    public void lockSelectLockedCells() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setSelectLockedCells(true);
    }

    public void lockSelectUnlockedCells() {
        this.createProtectionFieldIfNotPresent();
        this.worksheet.getSheetProtection().setSelectUnlockedCells(true);
    }

    private void createProtectionFieldIfNotPresent() {
        if (this.worksheet.getSheetProtection() == null) {
            this.worksheet.setSheetProtection(CTSheetProtection.Factory.newInstance());
        }
    }

    private boolean sheetProtectionEnabled() {
        return this.worksheet.getSheetProtection().getSheet();
    }

    boolean isCellInArrayFormulaContext(XSSFCell cell) {
        Iterator iterator = this.arrayFormulas.iterator();
        while (iterator.hasNext()) {
            CellRangeAddress range = (CellRangeAddress)iterator.next();
            if (!range.isInRange(cell.getRowIndex(), cell.getColumnIndex())) continue;
            return true;
        }
        return false;
    }

    XSSFCell getFirstCellInArrayFormula(XSSFCell cell) {
        Iterator iterator = this.arrayFormulas.iterator();
        while (iterator.hasNext()) {
            CellRangeAddress range = (CellRangeAddress)iterator.next();
            if (!range.isInRange(cell.getRowIndex(), cell.getColumnIndex())) continue;
            return (XSSFCell)this.getRow(range.getFirstRow()).getCell(range.getFirstColumn());
        }
        return null;
    }

    private CellRange getCellRange(CellRangeAddress range) {
        int firstRow = range.getFirstRow();
        int firstColumn = range.getFirstColumn();
        int lastRow = range.getLastRow();
        int lastColumn = range.getLastColumn();
        int height = lastRow - firstRow + 1;
        int width = lastColumn - firstColumn + 1;
        ArrayList<XSSFCell> temp = new ArrayList<XSSFCell>(height * width);
        int rowIn = firstRow;
        while (rowIn <= lastRow) {
            int colIn = firstColumn;
            while (colIn <= lastColumn) {
                XSSFCell cell;
                XSSFRow row = (XSSFRow)this.getRow(rowIn);
                if (row == null) {
                    row = (XSSFRow)this.createRow(rowIn);
                }
                if ((cell = (XSSFCell)row.getCell(colIn)) == null) {
                    cell = (XSSFCell)row.createCell(colIn);
                }
                temp.add(cell);
                ++colIn;
            }
            ++rowIn;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.apache.poi.xssf.usermodel.XSSFCell");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return SSCellRange.create((int)firstRow, (int)firstColumn, (int)height, (int)width, temp, (Class)clazz);
    }

    public CellRange setArrayFormula(String formula, CellRangeAddress range) {
        CellRange cr = this.getCellRange(range);
        XSSFCell mainArrayFormulaCell = (XSSFCell)cr.getTopLeftCell();
        mainArrayFormulaCell.setCellArrayFormula(formula, range);
        this.arrayFormulas.add(range);
        return cr;
    }

    public CellRange removeArrayFormula(Cell cell) {
        if (cell.getSheet() != this) {
            throw new IllegalArgumentException("Specified cell does not belong to this sheet.");
        }
        Iterator iterator = this.arrayFormulas.iterator();
        while (iterator.hasNext()) {
            CellRangeAddress range = (CellRangeAddress)iterator.next();
            if (!range.isInRange(cell.getRowIndex(), cell.getColumnIndex())) continue;
            this.arrayFormulas.remove(range);
            CellRange cr = this.getCellRange(range);
            Iterator iterator2 = cr.iterator();
            while (iterator2.hasNext()) {
                XSSFCell c = (XSSFCell)iterator2.next();
                c.setCellType(3);
            }
            return cr;
        }
        String ref = ((XSSFCell)cell).getCTCell().getR();
        throw new IllegalArgumentException("Cell " + ref + " is not part of an array formula.");
    }

    public DataValidationHelper getDataValidationHelper() {
        return this.dataValidationHelper;
    }

    public List getDataValidations() {
        ArrayList<XSSFDataValidation> xssfValidations = new ArrayList<XSSFDataValidation>();
        CTDataValidations dataValidations = this.worksheet.getDataValidations();
        if (dataValidations != null && dataValidations.getCount() > 0L) {
            int j = 0;
            while (j < dataValidations.getDataValidationArray().length) {
                CTDataValidation ctDataValidation = dataValidations.getDataValidationArray()[j];
                CellRangeAddressList addressList = new CellRangeAddressList();
                List sqref = ctDataValidation.getSqref();
                Iterator iterator = sqref.iterator();
                while (iterator.hasNext()) {
                    String stRef = (String)iterator.next();
                    String[] regions = stRef.split(" ");
                    int i = 0;
                    while (i < regions.length) {
                        String[] parts = regions[i].split(":");
                        CellReference begin = new CellReference(parts[0]);
                        CellReference end = parts.length > 1 ? new CellReference(parts[1]) : begin;
                        CellRangeAddress cellRangeAddress = new CellRangeAddress(begin.getRow(), end.getRow(), (int)begin.getCol(), (int)end.getCol());
                        addressList.addCellRangeAddress(cellRangeAddress);
                        ++i;
                    }
                }
                XSSFDataValidation xssfDataValidation = new XSSFDataValidation(addressList, ctDataValidation);
                xssfValidations.add(xssfDataValidation);
                ++j;
            }
        }
        return xssfValidations;
    }

    public void addValidationData(DataValidation dataValidation) {
        XSSFDataValidation xssfDataValidation = (XSSFDataValidation)dataValidation;
        CTDataValidations dataValidations = this.worksheet.getDataValidations();
        if (dataValidations == null) {
            dataValidations = this.worksheet.addNewDataValidations();
        }
        int currentCount = dataValidations.sizeOfDataValidationArray();
        CTDataValidation newval = dataValidations.addNewDataValidation();
        newval.set((XmlObject)xssfDataValidation.getCtDdataValidation());
        dataValidations.setCount((long)(currentCount + 1));
    }

    public AutoFilter setAutoFilter(CellRangeAddress range) {
        CTAutoFilter af = this.worksheet.getAutoFilter();
        if (af == null) {
            af = this.worksheet.addNewAutoFilter();
        }
        CellRangeAddress norm = new CellRangeAddress(range.getFirstRow(), range.getLastRow(), range.getFirstColumn(), range.getLastColumn());
        String ref = norm.formatAsString();
        af.setRef(ref);
        XSSFWorkbook wb = (XSSFWorkbook)this.getWorkbook();
        int sheetIndex = this.getWorkbook().getSheetIndex((Sheet)this);
        XSSFName name = wb.getBuiltInName("_xlnm._FilterDatabase", sheetIndex);
        if (name == null) {
            name = wb.createBuiltInName("_xlnm._FilterDatabase", sheetIndex);
            name.getCTName().setHidden(true);
            CellReference r1 = new CellReference(this.getSheetName(), range.getFirstRow(), range.getFirstColumn(), true, true);
            CellReference r2 = new CellReference(null, range.getLastRow(), range.getLastColumn(), true, true);
            String fmla = String.valueOf(r1.formatAsString()) + ":" + r2.formatAsString();
            name.setRefersToFormula(fmla);
        }
        return new XSSFAutoFilter(this);
    }

    public XSSFTable createTable() {
        if (!this.worksheet.isSetTableParts()) {
            this.worksheet.addNewTableParts();
        }
        CTTableParts tblParts = this.worksheet.getTableParts();
        CTTablePart tbl = tblParts.addNewTablePart();
        int tableNumber = this.getPackagePart().getPackage().getPartsByContentType(XSSFRelation.TABLE.getContentType()).size() + 1;
        XSSFTable table = (XSSFTable)this.createRelationship(XSSFRelation.TABLE, XSSFFactory.getInstance(), tableNumber);
        tbl.setId(table.getPackageRelationship().getId());
        this.tables.put(tbl.getId(), table);
        return table;
    }

    public List getTables() {
        ArrayList tableList = new ArrayList(this.tables.values());
        return tableList;
    }

    public SheetConditionalFormatting getSheetConditionalFormatting() {
        return new XSSFSheetConditionalFormatting(this);
    }

    public void setTabColor(int colorIndex) {
        CTSheetPr pr = this.worksheet.getSheetPr();
        if (pr == null) {
            pr = this.worksheet.addNewSheetPr();
        }
        CTColor color = CTColor.Factory.newInstance();
        color.setIndexed((long)colorIndex);
        pr.setTabColor(color);
    }
}

