/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel.charts;

import org.apache.poi.ss.usermodel.charts.AxisCrosses;
import org.apache.poi.ss.usermodel.charts.AxisOrientation;
import org.apache.poi.ss.usermodel.charts.AxisPosition;
import org.apache.poi.ss.usermodel.charts.ChartAxis;
import org.apache.poi.xssf.usermodel.XSSFChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxPos;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTCrosses;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTLogBase;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumFmt;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTOrientation;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScaling;
import org.openxmlformats.schemas.drawingml.x2006.chart.STAxPos;
import org.openxmlformats.schemas.drawingml.x2006.chart.STCrosses;
import org.openxmlformats.schemas.drawingml.x2006.chart.STOrientation;

public abstract class XSSFChartAxis
implements ChartAxis {
    protected XSSFChart chart;
    private static final double MIN_LOG_BASE = 2.0;
    private static final double MAX_LOG_BASE = 1000.0;

    protected XSSFChartAxis(XSSFChart chart) {
        this.chart = chart;
    }

    public AxisPosition getPosition() {
        return XSSFChartAxis.toAxisPosition(this.getCTAxPos());
    }

    public void setPosition(AxisPosition position) {
        this.getCTAxPos().setVal(XSSFChartAxis.fromAxisPosition(position));
    }

    public void setNumberFormat(String format) {
        this.getCTNumFmt().setFormatCode(format);
        this.getCTNumFmt().setSourceLinked(true);
    }

    public String getNumberFormat() {
        return this.getCTNumFmt().getFormatCode();
    }

    public boolean isSetLogBase() {
        return this.getCTScaling().isSetLogBase();
    }

    public void setLogBase(double logBase) {
        if (logBase < 2.0 || 1000.0 < logBase) {
            throw new IllegalArgumentException("Axis log base must be between 2 and 1000 (inclusive), got: " + logBase);
        }
        CTScaling scaling = this.getCTScaling();
        if (scaling.isSetLogBase()) {
            scaling.getLogBase().setVal(logBase);
        } else {
            scaling.addNewLogBase().setVal(logBase);
        }
    }

    public double getLogBase() {
        CTLogBase logBase = this.getCTScaling().getLogBase();
        if (logBase != null) {
            return logBase.getVal();
        }
        return 0.0;
    }

    public boolean isSetMinimum() {
        return this.getCTScaling().isSetMin();
    }

    public void setMinimum(double min) {
        CTScaling scaling = this.getCTScaling();
        if (scaling.isSetMin()) {
            scaling.getMin().setVal(min);
        } else {
            scaling.addNewMin().setVal(min);
        }
    }

    public double getMinimum() {
        CTScaling scaling = this.getCTScaling();
        if (scaling.isSetMin()) {
            return scaling.getMin().getVal();
        }
        return 0.0;
    }

    public boolean isSetMaximum() {
        return this.getCTScaling().isSetMax();
    }

    public void setMaximum(double max) {
        CTScaling scaling = this.getCTScaling();
        if (scaling.isSetMax()) {
            scaling.getMax().setVal(max);
        } else {
            scaling.addNewMax().setVal(max);
        }
    }

    public double getMaximum() {
        CTScaling scaling = this.getCTScaling();
        if (scaling.isSetMax()) {
            return scaling.getMax().getVal();
        }
        return 0.0;
    }

    public AxisOrientation getOrientation() {
        return XSSFChartAxis.toAxisOrientation(this.getCTScaling().getOrientation());
    }

    public void setOrientation(AxisOrientation orientation) {
        CTScaling scaling = this.getCTScaling();
        STOrientation.Enum stOrientation = XSSFChartAxis.fromAxisOrientation(orientation);
        if (scaling.isSetOrientation()) {
            scaling.getOrientation().setVal(stOrientation);
        } else {
            this.getCTScaling().addNewOrientation().setVal(stOrientation);
        }
    }

    public AxisCrosses getCrosses() {
        return XSSFChartAxis.toAxisCrosses(this.getCTCrosses());
    }

    public void setCrosses(AxisCrosses crosses) {
        this.getCTCrosses().setVal(XSSFChartAxis.fromAxisCrosses(crosses));
    }

    protected abstract CTAxPos getCTAxPos();

    protected abstract CTNumFmt getCTNumFmt();

    protected abstract CTScaling getCTScaling();

    protected abstract CTCrosses getCTCrosses();

    private static STOrientation.Enum fromAxisOrientation(AxisOrientation orientation) {
        if (AxisOrientation.MIN_MAX.equals(orientation)) {
            return STOrientation.MIN_MAX;
        }
        if (AxisOrientation.MAX_MIN.equals(orientation)) {
            return STOrientation.MAX_MIN;
        }
        throw new IllegalArgumentException();
    }

    private static AxisOrientation toAxisOrientation(CTOrientation ctOrientation) {
        switch (ctOrientation.getVal().intValue()) {
            case 2: {
                return AxisOrientation.MIN_MAX;
            }
            case 1: {
                return AxisOrientation.MAX_MIN;
            }
        }
        throw new IllegalArgumentException();
    }

    private static STCrosses.Enum fromAxisCrosses(AxisCrosses crosses) {
        if (AxisCrosses.AUTO_ZERO.equals(crosses)) {
            return STCrosses.AUTO_ZERO;
        }
        if (AxisCrosses.MIN.equals(crosses)) {
            return STCrosses.MIN;
        }
        if (AxisCrosses.MAX.equals(crosses)) {
            return STCrosses.MAX;
        }
        throw new IllegalArgumentException();
    }

    private static AxisCrosses toAxisCrosses(CTCrosses ctCrosses) {
        switch (ctCrosses.getVal().intValue()) {
            case 1: {
                return AxisCrosses.AUTO_ZERO;
            }
            case 2: {
                return AxisCrosses.MAX;
            }
            case 3: {
                return AxisCrosses.MIN;
            }
        }
        throw new IllegalArgumentException();
    }

    private static STAxPos.Enum fromAxisPosition(AxisPosition position) {
        if (AxisPosition.BOTTOM.equals(position)) {
            return STAxPos.B;
        }
        if (AxisPosition.LEFT.equals(position)) {
            return STAxPos.L;
        }
        if (AxisPosition.RIGHT.equals(position)) {
            return STAxPos.R;
        }
        if (AxisPosition.TOP.equals(position)) {
            return STAxPos.T;
        }
        throw new IllegalArgumentException();
    }

    private static AxisPosition toAxisPosition(CTAxPos ctAxPos) {
        switch (ctAxPos.getVal().intValue()) {
            case 1: {
                return AxisPosition.BOTTOM;
            }
            case 2: {
                return AxisPosition.LEFT;
            }
            case 3: {
                return AxisPosition.RIGHT;
            }
            case 4: {
                return AxisPosition.TOP;
            }
        }
        return AxisPosition.BOTTOM;
    }
}

